/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.userMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.RedisKeyEnum;
import com.uscale.common.exception.file.ConfFileException;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.SecurityUtils;
import com.uscale.system.dao.PsContactsDao;
import com.uscale.system.entity.Endpoints;
import com.uscale.system.entity.License;
import com.uscale.system.entity.PsContacts;
import com.uscale.system.entity.SipUser;
import com.uscale.system.model.sip.CreateSip;
import com.uscale.system.model.sip.QuerySip;
import com.uscale.system.service.IEndpointsService;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.tool.LicenseUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Api(tags={"POTS\u7528\u6237"})
@RestController
@RequestMapping(value={"/userMng/potsUser"})
public class UmPotsUserController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmPotsUserController.class);
    private static final Gson GSON = new Gson();
    private final ISipUserService iSipUserService;
    private final JedisPool jedisPool;
    private final PsContactsDao contactsDao;
    @Autowired
    private IEndpointsService iEndpointsService;

    @Autowired
    public UmPotsUserController(ISipUserService iSipUserService, JedisPool jedisPool, PsContactsDao contactsDao) {
        this.iSipUserService = iSipUserService;
        this.jedisPool = jedisPool;
        this.contactsDao = contactsDao;
    }

    @ApiOperation(value="\u67e5\u8be2POTS\u7528\u6237\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo<SipUser> list(QuerySip querySip, Integer pageNum, Integer pageSize) throws UnknownHostException {
        LOGGER.debug("SIP\u7528\u6237\u5217\u8868\u5206\u9875\u67e5\u8be2\uff0cpageNum=[{}], pageSize=[{}], querySip=[{}]", new Object[]{pageNum, pageSize, GSON.toJson((Object)querySip)});
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!ObjectUtils.isEmpty((Object)querySip.getStartNum())) {
            wrapper.nested(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.ge(SipUser::getNumber, (Object)querySip.getStartNum())).or()).ge(SipUser::getReplaceOldNumber, (Object)querySip.getStartNum());
            });
        }
        if (!ObjectUtils.isEmpty((Object)querySip.getEndNum())) {
            wrapper.nested(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.le(SipUser::getNumber, (Object)querySip.getEndNum())).or()).le(SipUser::getReplaceOldNumber, (Object)querySip.getEndNum());
            });
        }
        if (!ObjectUtils.isEmpty((Object)querySip.getCallSourceNo())) {
            wrapper.eq(SipUser::getCallSourceNo, (Object)querySip.getCallSourceNo());
        }
        if (!ObjectUtils.isEmpty((Object)querySip.getDeviceType())) {
            wrapper.eq(SipUser::getDeviceType, (Object)querySip.getDeviceType());
        }
        if (!ObjectUtils.isEmpty((Object)querySip.getNumber())) {
            wrapper.eq(SipUser::getNumber, (Object)querySip.getNumber());
        }
        if (!ObjectUtils.isEmpty((Object)querySip.getSlot())) {
            wrapper.eq(SipUser::getSlot, (Object)querySip.getSlot());
        }
        wrapper.eq(SipUser::getType, (Object)"POTS");
        if (querySip.getUserStatus() != null) {
            ArrayList<String> deviceIds = new ArrayList<String>();
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.select(1);
                String key = RedisKeyEnum.EXTENSION_STATE.getKey() + "*";
                Set keys = jedis.keys(key);
                if (CollectionUtils.isNotEmpty((Collection)keys)) {
                    for (String k : keys) {
                        String status = jedis.get(k);
                        if (!StringUtils.equals((CharSequence)status, (CharSequence)String.valueOf(querySip.getUserStatus()))) continue;
                        deviceIds.add(k.split("::")[1]);
                    }
                }
            }
            if (CollectionUtils.isEmpty(deviceIds)) {
                return this.getDataTable(new Page((long)pageNum.intValue(), (long)pageSize.intValue()));
            }
            wrapper.in(SipUser::getDeviceId, deviceIds);
        }
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        Page userPage = (Page)this.iSipUserService.page((IPage)page, (Wrapper)wrapper);
        userPage.getRecords().forEach(item -> {
            Endpoints endpoints = (Endpoints)this.iEndpointsService.getById((Serializable)((Object)item.getDeviceId()));
            this.iSipUserService.setCallerName(endpoints, item);
        });
        this.getStatusFromRdb(userPage);
        return this.getDataTable(userPage);
    }

    private void getStatusFromRdb(Page<SipUser> userPage) {
        List sipUsers = userPage.getRecords();
        if (sipUsers.isEmpty()) {
            return;
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            sipUsers.forEach(sipUser -> {
                String key = RedisKeyEnum.EXTENSION_STATE.getKey() + sipUser.getDeviceId();
                String status = jedis.get(key);
                if (StringUtils.isNotBlank((CharSequence)status)) {
                    sipUser.setUserStatus(status);
                    PsContacts contacts = this.contactsDao.getByEndpoint(sipUser.getDeviceId());
                    if (contacts != null) {
                        sipUser.setIp(contacts.getViaAddr());
                        String userAgent = contacts.getUserAgent();
                        sipUser.setRegisteredTerminalType(com.uscale.common.utils.StringUtils.isBlank((CharSequence)userAgent) ? userAgent : userAgent.split(" ")[0]);
                    }
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sipUser.getSlot(), sipUser.getPort()})) {
                    sipUser.setSlotPort(sipUser.getSlot() + "/" + sipUser.getPort());
                }
            });
        }
    }

    @ApiOperation(value="\u83b7\u53d6POTS\u7528\u6237\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult<SipUser> getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.iSipUserService.getPotsById(id));
    }

    @ApiOperation(value="\u65b0\u589ePOTS\u7528\u6237")
    @Log(title="POTS\u7528\u6237", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody CreateSip user) throws ConfFileException {
        LOGGER.debug("\u65b0\u589ePOTS\u7528\u6237\uff0c\u83b7\u53d6\u5230\u53c2\u6570\uff1acreateSip=[{}]", (Object)GSON.toJson((Object)user));
        int count = this.iSipUserService.getUserCount();
        int userCount = user.getUserCount();
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            LicenseUtils licenseUtils = LicenseUtils.getInstance();
            License license = licenseUtils.getLicense(jedis, true);
            if (ObjectUtils.isEmpty((Object)license)) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SipUserController.max.user", (Object[])new Object[0]));
                return ajaxResult;
            }
            if (userCount + count > Integer.parseInt(license.getLsrUserNum())) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SipUserController.max.user", (Object[])new Object[0]));
                return ajaxResult;
            }
        }
        return this.iSipUserService.createPotsUser(user);
    }

    @ApiOperation(value="\u4fee\u6539POTS\u7528\u6237")
    @Log(title="POTS\u7528\u6237", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SipUser umPotsUser) {
        if (!ObjectUtils.isEmpty((Object)umPotsUser.getSelfServiceLoginPassword())) {
            umPotsUser.setSelfServiceLoginPassword(SecurityUtils.encryptPassword((String)umPotsUser.getSelfServiceLoginPassword()));
        }
        return this.iSipUserService.updatePots(umPotsUser);
    }

    @ApiOperation(value="\u5220\u9664POTS\u7528\u6237")
    @Log(title="POTS\u7528\u6237", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.iSipUserService.deletePots(Arrays.asList((Object[])ids.clone()));
    }
}

