/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.userMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.License;
import com.uscale.system.entity.UmDeviceId;
import com.uscale.system.model.CreateUmDeviceId;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.service.IUmDeviceIdService;
import com.uscale.system.tool.LicenseUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Api(tags={"\u8bbe\u5907\u6807\u8bc6"})
@RestController
@RequestMapping(value={"/userMng/deviceId"})
public class UmDeviceIdController
extends BaseController {
    private final IUmDeviceIdService umDeviceIdService;
    private final ISipUserService iSipUserService;
    private final JedisPool jedisPool;

    @Autowired
    public UmDeviceIdController(IUmDeviceIdService umDeviceIdService, ISipUserService iSipUserService, JedisPool jedisPool) {
        this.umDeviceIdService = umDeviceIdService;
        this.iSipUserService = iSipUserService;
        this.jedisPool = jedisPool;
    }

    @ApiOperation(value="\u67e5\u8be2\u8bbe\u5907\u6807\u8bc6\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo<UmDeviceId> list(String startDeviceId, String endDeviceId, Integer pageNum, Integer pageSize) {
        QueryWrapper wrapper = new QueryWrapper();
        if (!ObjectUtils.isEmpty((Object)startDeviceId)) {
            wrapper.ge((Object)"device_id", (Object)startDeviceId);
        }
        if (!ObjectUtils.isEmpty((Object)endDeviceId)) {
            wrapper.le((Object)"device_id", (Object)endDeviceId);
        }
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        this.umDeviceIdService.page((IPage)page, (Wrapper)wrapper);
        page.getRecords().forEach(item -> item.setPassword("******"));
        return this.getDataTable(page);
    }

    @ApiOperation(value="\u83b7\u53d6\u8bbe\u5907\u6807\u8bc6\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult<UmDeviceId> getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.umDeviceIdService.getById((Serializable)id));
    }

    @ApiOperation(value="\u65b0\u589e\u8bbe\u5907\u6807\u8bc6")
    @Log(title="\u8bbe\u5907\u6807\u8bc6", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody @Validated CreateUmDeviceId createUmDeviceId) {
        int count = this.iSipUserService.getUserCount();
        int userCount = createUmDeviceId.getDeviceNumber();
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            LicenseUtils licenseUtils = LicenseUtils.getInstance();
            License license = licenseUtils.getLicense(jedis, true);
            if (ObjectUtils.isEmpty((Object)license)) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SipUserController.max.user", (Object[])new Object[0]));
                return ajaxResult;
            }
            if (userCount + count > Integer.parseInt(license.getLsrUserNum())) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SipUserController.max.user", (Object[])new Object[0]));
                return ajaxResult;
            }
        }
        return this.umDeviceIdService.save(createUmDeviceId);
    }

    @ApiOperation(value="\u4fee\u6539\u8bbe\u5907\u6807\u8bc6")
    @Log(title="\u8bbe\u5907\u6807\u8bc6", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody @Validated UmDeviceId createUmDeviceId) {
        return this.toAjax(this.umDeviceIdService.updateById((Object)createUmDeviceId));
    }

    @ApiOperation(value="\u5220\u9664\u8bbe\u5907\u6807\u8bc6")
    @Log(title="\u8bbe\u5907\u6807\u8bc6", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.umDeviceIdService.removeByIds(Arrays.asList((Object[])ids.clone())));
    }
}

