/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.userMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.SipUserBusinessEnum;
import com.uscale.system.entity.SipUser;
import com.uscale.system.entity.UmSipUserTrunkBasedCallLimitRel;
import com.uscale.system.service.CallTimeLimitIndexService;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.service.IUmSipUserTrunkBasedCallLimitRelService;
import com.uscale.system.tool.UserBusinessUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Sip\u7528\u6237\u64cd\u4f5c\u53ca\u4e1a\u52a1\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/userMng/sip"})
public class SipUserTrunkBasedCallLimitRelController
extends BaseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final ISipUserService iSipUserService;
    private final CallTimeLimitIndexService callTimeLimitIndexService;
    private final IUmSipUserTrunkBasedCallLimitRelService umSipUserTrunkBasedCallLimitRelService;

    @Autowired
    public SipUserTrunkBasedCallLimitRelController(ISipUserService iSipUserService, CallTimeLimitIndexService callTimeLimitIndexService, IUmSipUserTrunkBasedCallLimitRelService umSipUserTrunkBasedCallLimitRelService) {
        this.iSipUserService = iSipUserService;
        this.callTimeLimitIndexService = callTimeLimitIndexService;
        this.umSipUserTrunkBasedCallLimitRelService = umSipUserTrunkBasedCallLimitRelService;
    }

    @ApiOperation(value="\u67e5\u8be2SIP\u4e2d\u7ee7\u547c\u53eb\u9650\u65f6\u5217\u8868")
    @GetMapping(value={"/trunkBasedCallLimitRel/list"})
    public AjaxResult<List<UmSipUserTrunkBasedCallLimitRel>> trunkBasedCallLimitRelList(String deviceId) {
        this.LOGGER.debug("\u67e5\u8be2SIP\u4e2d\u7ee7\u547c\u53eb\u9650\u65f6\u5217\u8868\uff0cdeviceId=[{}]", (Object)deviceId);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UmSipUserTrunkBasedCallLimitRel::getDeviceId, (Object)deviceId);
        return AjaxResult.success((Object)this.umSipUserTrunkBasedCallLimitRelService.list((Wrapper)wrapper));
    }

    @ApiOperation(value="\u67e5\u8be2SIP\u4e2d\u7ee7\u547c\u53eb\u9650\u65f6\u7d22\u5f15\u4e0b\u62c9\u6846")
    @GetMapping(value={"/trunkBasedCallLimitRel/getTimeIndexDropdown"})
    public AjaxResult trunkBasedCallLimitRelGetTimeIndexDropdown() {
        this.LOGGER.debug("\u67e5\u8be2SIP\u4e2d\u7ee7\u547c\u53eb\u9650\u65f6\u7d22\u5f15\u4e0b\u62c9\u6846");
        List list = this.callTimeLimitIndexService.list();
        ArrayList res = new ArrayList();
        list.forEach(item -> {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("dictValue", item.getCallTimeLimitIndex());
            String identify = item.getCallTimeLimitIdentifier();
            if (ObjectUtils.isEmpty((Object)identify)) {
                identify = "";
            }
            map.put("dictLabel", item.getCallTimeLimitIndex() + "(" + identify + ")");
            map.put("callTimeLimitIndex", item.getCallTimeLimitIndex());
            map.put("callTimeLimitIdentifier", item.getCallTimeLimitIdentifier());
            map.put("officeRouteId", item.getOfficeRouteId());
            map.put("time", item.getTime());
            res.add(map);
        });
        return AjaxResult.success(res);
    }

    @ApiOperation(value="SIP\u4e2d\u7ee7\u547c\u53eb\u9650\u65f6\u7f16\u8f91")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u4e2d\u7ee7\u547c\u53eb\u9650\u65f6\u7d22\u5f15", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/trunkBasedCallLimitRel/edit"})
    @Transactional(rollbackFor={Exception.class})
    public AjaxResult trunkBasedCallLimitRelEdit(@RequestBody List<UmSipUserTrunkBasedCallLimitRel> params) {
        if (CollectionUtils.isEmpty(params)) {
            return this.toAjax(false);
        }
        String deviceId = params.get(0).getDeviceId();
        SipUser sipUser = this.iSipUserService.getSipUserByDeviceId(deviceId);
        if (ObjectUtils.isEmpty((Object)sipUser)) {
            this.LOGGER.error("SIP\u4e2d\u7ee7\u547c\u53eb\u9650\u65f6\u7f16\u8f91\uff0c\u6839\u636e\u8bb0\u5f55\u4e2d\u7684\u53f7\u7801\uff0c\u672a\u67e5\u8be2\u5230\u7528\u6237\uff1adeviceId=[{}]", (Object)deviceId);
            return this.toAjax(false);
        }
        UserBusinessUtils.addComplexBusiness((String)SipUserBusinessEnum.COMPLEX_TRUNK_BASED_CALL_TIME_LIMIT.getCode(), (SipUser)sipUser);
        this.iSipUserService.updateById((Object)sipUser);
        return this.toAjax(this.umSipUserTrunkBasedCallLimitRelService.saveOrUpdateBatch(params));
    }

    @ApiOperation(value="SIP\u4e2d\u7ee7\u547c\u53eb\u9650\u65f6\u5220\u9664")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u4e2d\u7ee7\u547c\u53eb\u9650\u65f6\u7d22\u5f15", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/trunkBasedCallLimitRel/delete/{deviceId}/{ids}"})
    public AjaxResult trunkBasedCallLimitRelDelete(@PathVariable(value="deviceId") String deviceId, @PathVariable Long[] ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return this.toAjax(0);
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UmSipUserTrunkBasedCallLimitRel::getDeviceId, (Object)deviceId);
        int cnt = this.umSipUserTrunkBasedCallLimitRelService.count((Wrapper)wrapper);
        if (cnt == ids.length) {
            SipUser sipUser = this.iSipUserService.getSipUserByDeviceId(deviceId);
            if (ObjectUtils.isEmpty((Object)sipUser)) {
                this.LOGGER.error("SIP\u4e2d\u7ee7\u547c\u53eb\u9650\u65f6\u7f16\u8f91\uff0c\u6839\u636e\u8bb0\u5f55\u4e2d\u7684\u53f7\u7801\uff0c\u672a\u67e5\u8be2\u5230\u7528\u6237\uff1adeviceId=[{}]", (Object)deviceId);
                return this.toAjax(false);
            }
            UserBusinessUtils.delComplexBusiness((String)SipUserBusinessEnum.COMPLEX_TRUNK_BASED_CALL_TIME_LIMIT.getCode(), (SipUser)sipUser);
            this.iSipUserService.updateById((Object)sipUser);
        }
        return this.toAjax(this.umSipUserTrunkBasedCallLimitRelService.removeByIds(Arrays.asList((Object[])ids.clone())));
    }
}

