/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.userMng;

import com.uscale.common.annotation.Log;
import com.uscale.common.annotation.RepeatSubmit;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.system.entity.SipUserSecret;
import com.uscale.system.service.SipUserSecretService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ecf\u7406\u79d8\u4e66"})
@RestController
@RequestMapping(value={"/sip/user/secret"})
public class SipUserSecretController
extends BaseController {
    private final SipUserSecretService sipUserSecretService;

    @Autowired
    public SipUserSecretController(SipUserSecretService sipUserSecretService) {
        this.sipUserSecretService = sipUserSecretService;
    }

    @ApiOperation(value="\u6839\u636e\u8bbe\u5907ID\u67e5\u8be2\u7ecf\u7406\u79d8\u4e66\u914d\u7f6e")
    @GetMapping(value={"/{deviceId}"})
    public AjaxResult<SipUserSecret> get(@PathVariable(value="deviceId") String deviceId) {
        return AjaxResult.success((Object)this.sipUserSecretService.getByDeviceId(deviceId));
    }

    @ApiOperation(value="\u5220\u9664\u7ecf\u7406\u79d8\u4e66\u914d\u7f6e")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u7ecf\u7406\u79d8\u4e66", businessType=BusinessType.DELETE)
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    public AjaxResult delete(@PathVariable(value="id") Long id) {
        return this.toAjax(this.sipUserSecretService.removeById((Serializable)id));
    }

    @ApiOperation(value="\u6dfb\u52a0\u7ecf\u7406\u79d8\u4e66\u914d\u7f6e")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u7ecf\u7406\u79d8\u4e66", businessType=BusinessType.INSERT)
    @RepeatSubmit
    @PostMapping
    public AjaxResult add(@RequestBody SipUserSecret sipUserSecret) {
        return this.toAjax(this.sipUserSecretService.addSecret(sipUserSecret));
    }
}

