/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.userMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.annotation.RepeatSubmit;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.SipUserBusinessEnum;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.GsBlfGroup;
import com.uscale.system.entity.GsHuntGroupMember;
import com.uscale.system.entity.GsMla;
import com.uscale.system.entity.SipUser;
import com.uscale.system.handler.SipUserBusinessConflictResponsibilityChain;
import com.uscale.system.service.GsMlaService;
import com.uscale.system.service.IEndpointsService;
import com.uscale.system.service.IGsBlfGroupService;
import com.uscale.system.service.IGsHuntGroupMemberService;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.tool.UserBusinessUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u540c\u673a\u6539\u53f7"})
@RestController
@RequestMapping(value={"/userMng/sip"})
public class SipUserReplaceNumberController
extends BaseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final Gson GSON = new Gson();
    private final ISipUserService iSipUserService;
    private final IGsBlfGroupService gsBlfGroupService;
    private final GsMlaService gsMlaService;
    private final IGsHuntGroupMemberService gsHuntGroupMemberService;
    private final SipUserBusinessConflictResponsibilityChain sipUserBusinessConflictResponsibilityChain;
    private final IEndpointsService iEndpointsService;

    @Autowired
    public SipUserReplaceNumberController(ISipUserService iSipUserService, IEndpointsService iEndpointsService, SipUserBusinessConflictResponsibilityChain sipUserBusinessConflictResponsibilityChain, IGsBlfGroupService gsBlfGroupService, GsMlaService gsMlaService, IGsHuntGroupMemberService gsHuntGroupMemberService) {
        this.iSipUserService = iSipUserService;
        this.sipUserBusinessConflictResponsibilityChain = sipUserBusinessConflictResponsibilityChain;
        this.iEndpointsService = iEndpointsService;
        this.gsBlfGroupService = gsBlfGroupService;
        this.gsMlaService = gsMlaService;
        this.gsHuntGroupMemberService = gsHuntGroupMemberService;
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u540c\u673a\u6539\u53f7\u914d\u7f6e")
    @GetMapping(value={"/getReplaceNumberConfig/{sipUserId}"})
    public AjaxResult<SipUser> getReplaceNumberConfig(@PathVariable(value="sipUserId") Long sipUserId) {
        if (ObjectUtils.isEmpty((Object)sipUserId)) {
            this.LOGGER.error("\u83b7\u53d6\u7528\u6237\u540c\u673a\u6539\u53f7\u914d\u7f6e\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5931\u8d25");
            return AjaxResult.error();
        }
        SipUser sipUser = (SipUser)this.iSipUserService.getById((Serializable)sipUserId);
        if (ObjectUtils.isEmpty((Object)sipUser)) {
            this.LOGGER.error("\u83b7\u53d6\u7528\u6237\u540c\u673a\u6539\u53f7\u914d\u7f6e\uff0c\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u5931\u8d25\uff1asipUserId=[{}]", (Object)sipUserId);
            return AjaxResult.error();
        }
        return AjaxResult.success((Object)sipUser);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u540c\u673a\u6539\u53f7\u914d\u7f6e")
    @RepeatSubmit
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u540c\u673a\u6539\u53f7", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/saveOrUpdateReplaceNumberConfig"})
    @Transactional(rollbackFor={Exception.class})
    public AjaxResult saveOrUpdateReplaceNumberConfig(@RequestBody SipUser sipUser) {
        if (ObjectUtils.isEmpty((Object)sipUser) || ObjectUtils.isEmpty((Object)sipUser.getId())) {
            this.LOGGER.error("\u4fdd\u5b58\u7528\u6237\u540c\u673a\u6539\u53f7\u914d\u7f6e\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5931\u8d25\uff1asipUser=[{}]", (Object)GSON.toJson((Object)sipUser));
            return AjaxResult.error();
        }
        SipUser origin = (SipUser)this.iSipUserService.getById((Serializable)sipUser.getId());
        if (ObjectUtils.isEmpty((Object)origin)) {
            this.LOGGER.error("\u4fdd\u5b58\u7528\u6237\u540c\u673a\u6539\u53f7\u914d\u7f6e\uff0c\u6839\u636eID\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u5931\u8d25\uff1asipUser=[{}]", (Object)GSON.toJson((Object)sipUser));
            return AjaxResult.error();
        }
        this.LOGGER.error("\u6309\u7167\u521b\u5efa\u65f6\uff08\u540c\u673a\u6539\u53f7\u524d\uff09\u7684sip\u7528\u6237\u8fdb\u884c\u6821\u9a8c\u4e1a\u52a1\u51b2\u7a81\u7b49\u60c5\u51b5\uff1asipUser=[{}]", (Object)GSON.toJson((Object)sipUser));
        UserBusinessUtils.addComplexBusiness((String)SipUserBusinessEnum.COMPLEX_REPLACE_NUMBER.getCode(), (SipUser)sipUser);
        if (!this.sipUserBusinessConflictResponsibilityChain.handle(sipUser)) {
            this.LOGGER.error("\u4fdd\u5b58\u7528\u6237\u540c\u673a\u6539\u53f7\u914d\u7f6e\uff0c\u7528\u6237\u4e1a\u52a1\u51b2\u7a81\uff0c\u5931\u8d25\uff1asipUser=[{}]", (Object)GSON.toJson((Object)sipUser));
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserReplaceNumberController.business.conflic", (Object[])new Object[0]));
        }
        SipUser check = new SipUser();
        check.setNumber(sipUser.getReplaceOldNumber());
        check.setLongNumber(sipUser.getReplaceOldLongNumber());
        ArrayList<SipUser> list = new ArrayList<SipUser>();
        list.add(check);
        if (!this.iSipUserService.checkNumberAndLongNumberUnique(list)) {
            this.LOGGER.error("\u4fdd\u5b58\u7528\u6237\u540c\u673a\u6539\u53f7\u914d\u7f6e\uff0c\u68c0\u67e5\u5230\u53f7\u7801\u4e0d\u552f\u4e00\uff0c\u5931\u8d25\uff1acheck=[{}]", (Object)GSON.toJson((Object)check));
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserReplaceNumberController.new.number", (Object[])new Object[0]));
        }
        sipUser.setComplexBusiness(origin.getComplexBusiness());
        UserBusinessUtils.addComplexBusiness((String)SipUserBusinessEnum.COMPLEX_REPLACE_NUMBER.getCode(), (SipUser)sipUser);
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)lambdaUpdateWrapper.set(SipUser::getComplexBusiness, (Object)sipUser.getComplexBusiness())).set(SipUser::getNumber, (Object)sipUser.getNumber())).set(SipUser::getLongNumber, (Object)sipUser.getLongNumber())).eq(SipUser::getId, (Object)sipUser.getId());
        if (!ObjectUtils.isEmpty((Object)sipUser.getReplaceOldNumber())) {
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)lambdaUpdateWrapper.set(SipUser::getReplaceOldNumber, (Object)sipUser.getReplaceOldNumber())).set(SipUser::getReplaceOldLongNumber, (Object)sipUser.getReplaceOldLongNumber())).set(SipUser::getReplaceNumberAutoCall, (Object)sipUser.getReplaceNumberAutoCall());
        }
        LambdaUpdateWrapper lambdaUpdateWrapper1 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)lambdaUpdateWrapper1.set(GsBlfGroup::getUserNumber, (Object)sipUser.getReplaceOldNumber())).eq(GsBlfGroup::getDeviceId, (Object)origin.getDeviceId());
        this.gsBlfGroupService.update((Wrapper)lambdaUpdateWrapper1);
        LambdaUpdateWrapper lambdaUpdateWrapper2 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)lambdaUpdateWrapper2.set(GsMla::getMainNumber, (Object)sipUser.getReplaceOldNumber())).eq(GsMla::getMemberDeviceId, (Object)origin.getDeviceId());
        this.gsMlaService.update((Wrapper)lambdaUpdateWrapper2);
        LambdaUpdateWrapper lambdaUpdateWrapper3 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)lambdaUpdateWrapper3.set(GsHuntGroupMember::getMemberNumber, (Object)sipUser.getReplaceOldNumber())).eq(GsHuntGroupMember::getMemberDeviceId, (Object)origin.getDeviceId());
        this.gsHuntGroupMemberService.update((Wrapper)lambdaUpdateWrapper3);
        return this.toAjax(this.iSipUserService.update((Wrapper)lambdaUpdateWrapper));
    }

    @ApiOperation(value="\u5173\u95ed\u7528\u6237\u540c\u673a\u6539\u53f7\u4e1a\u52a1")
    @RepeatSubmit
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u540c\u673a\u6539\u53f7", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/closeReplaceNumberConfig/{sipUserId}"})
    @Transactional(rollbackFor={Exception.class})
    public AjaxResult closeReplaceNumberConfig(@PathVariable Long sipUserId) {
        if (ObjectUtils.isEmpty((Object)sipUserId)) {
            this.LOGGER.error("\u5173\u95ed\u7528\u6237\u540c\u673a\u6539\u53f7\u4e1a\u52a1\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5931\u8d25");
            return AjaxResult.error();
        }
        SipUser origin = (SipUser)this.iSipUserService.getById((Serializable)sipUserId);
        if (ObjectUtils.isEmpty((Object)origin)) {
            this.LOGGER.error("\u5173\u95ed\u7528\u6237\u540c\u673a\u6539\u53f7\u4e1a\u52a1\uff0c\u6839\u636eID\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u5931\u8d25\uff1asipUserId=[{}]", (Object)sipUserId);
            return AjaxResult.error();
        }
        UserBusinessUtils.delComplexBusiness((String)SipUserBusinessEnum.COMPLEX_REPLACE_NUMBER.getCode(), (SipUser)origin);
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        if (ObjectUtils.isEmpty((Object)origin.getReplaceOldNumber())) {
            return AjaxResult.success((String)MessageUtils.message((String)"SipUserReplaceNumberController.close", (Object[])new Object[0]));
        }
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)lambdaUpdateWrapper.set(SipUser::getReplaceOldNumber, null)).set(SipUser::getReplaceOldLongNumber, null)).set(SipUser::getReplaceNumberAutoCall, null)).set(SipUser::getComplexBusiness, (Object)origin.getComplexBusiness())).eq(SipUser::getId, (Object)origin.getId());
        LambdaUpdateWrapper lambdaUpdateWrapper1 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)lambdaUpdateWrapper1.set(GsBlfGroup::getUserNumber, (Object)origin.getReplaceOldNumber())).eq(GsBlfGroup::getDeviceId, (Object)origin.getDeviceId());
        this.gsBlfGroupService.update((Wrapper)lambdaUpdateWrapper1);
        LambdaUpdateWrapper lambdaUpdateWrapper2 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)lambdaUpdateWrapper2.set(GsMla::getMainNumber, (Object)origin.getReplaceOldNumber())).eq(GsMla::getMemberDeviceId, (Object)origin.getDeviceId());
        this.gsMlaService.update((Wrapper)lambdaUpdateWrapper2);
        LambdaUpdateWrapper lambdaUpdateWrapper3 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)lambdaUpdateWrapper3.set(GsHuntGroupMember::getMemberNumber, (Object)origin.getReplaceOldNumber())).eq(GsHuntGroupMember::getMemberDeviceId, (Object)origin.getDeviceId());
        this.gsHuntGroupMemberService.update((Wrapper)lambdaUpdateWrapper3);
        return this.toAjax(this.iSipUserService.update((Wrapper)lambdaUpdateWrapper));
    }
}

