/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.userMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.SipUserBusinessEnum;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.SipUser;
import com.uscale.system.entity.UmPbxGroupConfig;
import com.uscale.system.entity.UmPbxGroupNumber;
import com.uscale.system.model.pbxGroup.QueryUmPbxGroupConfig;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.service.IUmPbxGroupConfigService;
import com.uscale.system.service.IUmPbxGroupNumberService;
import com.uscale.system.tool.UserBusinessUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Sip\u7528\u6237\u64cd\u4f5c\u53ca\u4e1a\u52a1\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/userMng/sip"})
public class SipUserPbxGroupController
extends BaseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final ISipUserService sipUserService;
    private final IUmPbxGroupConfigService umPbxGroupConfigService;
    private final IUmPbxGroupNumberService umPbxGroupNumberService;

    @Autowired
    public SipUserPbxGroupController(ISipUserService sipUserService, IUmPbxGroupConfigService umPbxGroupConfigService, IUmPbxGroupNumberService umPbxGroupNumberService) {
        this.sipUserService = sipUserService;
        this.umPbxGroupConfigService = umPbxGroupConfigService;
        this.umPbxGroupNumberService = umPbxGroupNumberService;
    }

    @ApiOperation(value="\u67e5\u8be2SIP\u5c0f\u4ea4\u7fa4\u7ec4\u5217\u8868")
    @GetMapping(value={"/pbxGroupNumber/list"})
    public TableDataInfo<UmPbxGroupNumber> pbxGroupNumberList(Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.umPbxGroupNumberService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="SIP\u5c0f\u4ea4\u7fa4\u7ec4\u7f16\u8f91")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u5c0f\u4ea4\u7fa4", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/pbxGroupNumber/edit"})
    public AjaxResult pbxGroupNumberEdit(@RequestBody List<UmPbxGroupNumber> list) {
        if (CollectionUtils.isEmpty(list)) {
            return this.toAjax(0);
        }
        boolean bool = this.umPbxGroupNumberService.saveOrUpdateBatch(list);
        return this.toAjax(bool);
    }

    @ApiOperation(value="SIP\u5c0f\u4ea4\u7fa4\u7ec4\u5220\u9664")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u5c0f\u4ea4\u7fa4", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/pbxGroupNumber/delete/{ids}"})
    public AjaxResult pbxGroupNumberDelete(@PathVariable List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return this.toAjax(0);
        }
        List umPbxGroupNumbers = this.umPbxGroupNumberService.getUmPbxGroupNumberByIds(ids);
        if (!CollectionUtils.isEmpty((Collection)umPbxGroupNumbers)) {
            ArrayList<Long> umPbxGroupNumbIds = new ArrayList<Long>();
            for (UmPbxGroupNumber umPbxGroupNumber : umPbxGroupNumbers) {
                umPbxGroupNumbIds.add(umPbxGroupNumber.getGroupNumber());
            }
            List umPbxGroupConfigs = this.umPbxGroupConfigService.getUmPbxGroupConfigByIds(umPbxGroupNumbIds);
            if (!CollectionUtils.isEmpty((Collection)umPbxGroupConfigs)) {
                StringBuffer buffer = new StringBuffer();
                for (UmPbxGroupConfig umPbxGroupConfig : umPbxGroupConfigs) {
                    if (buffer.length() > 0) {
                        buffer.append(",");
                    }
                    buffer.append(umPbxGroupConfig.getDeviceId());
                }
                return AjaxResult.error((String)MessageUtils.message((String)"SipUserPbxGroupController.to.user", (Object[])new Object[]{buffer.toString()}));
            }
        }
        return this.toAjax(this.umPbxGroupNumberService.removeByIds(ids));
    }

    @ApiOperation(value="\u83b7\u53d6SIP\u5c0f\u4ea4\u7fa4\u7ec4\u914d\u7f6e")
    @GetMapping(value={"/pbxGroupNumber/getConfig/{sipId}"})
    public AjaxResult getPbxGroupNumberConfig(@PathVariable Long sipId) {
        SipUser sipUser = (SipUser)this.sipUserService.getById((Serializable)sipId);
        if (ObjectUtils.isEmpty((Object)sipUser)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserPbxGroupController.sip.user", (Object[])new Object[0]));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(UmPbxGroupConfig::getDeviceId, (Object)sipUser.getDeviceId())).last("limit 1");
        UmPbxGroupConfig config = (UmPbxGroupConfig)this.umPbxGroupConfigService.getOne((Wrapper)wrapper);
        List list = this.umPbxGroupNumberService.list();
        ArrayList groupNumbers = new ArrayList();
        HashMap<String, String> tmp = new HashMap<String, String>(2);
        tmp.put("dictValue", null);
        tmp.put("dictLabel", "None");
        groupNumbers.add(tmp);
        list.forEach(number -> {
            HashMap<String, Long> map = new HashMap<String, Long>(2);
            map.put("dictValue", number.getGroupNumber());
            map.put("dictLabel", number.getGroupNumber());
            groupNumbers.add(map);
        });
        HashMap<String, Object> res = new HashMap<String, Object>(3);
        res.put("sipNumber", sipUser.getNumber());
        res.put("deviceId", sipUser.getDeviceId());
        res.put("config", config);
        res.put("groupNumbers", groupNumbers);
        return AjaxResult.success(res);
    }

    @ApiOperation(value="SIP\u5c0f\u4ea4\u7fa4\u7ec4\u7f16\u8f91")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u5c0f\u4ea4\u7fa4", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/pbxGroupNumber/updateConfig"})
    public AjaxResult pbxGroupUpdateConfig(@RequestBody UmPbxGroupConfig config) {
        if (ObjectUtils.isEmpty((Object)config)) {
            return this.toAjax(0);
        }
        if (!ObjectUtils.isEmpty((Object)config.getGroupNumber())) {
            SipUser sipUser = this.sipUserService.getSipUserByDeviceId(config.getDeviceId());
            if (ObjectUtils.isEmpty((Object)sipUser)) {
                return AjaxResult.error();
            }
            UserBusinessUtils.addComplexBusiness((String)SipUserBusinessEnum.COMPLEX_PBX_GROUP.getCode(), (SipUser)sipUser);
            this.sipUserService.updateById((Object)sipUser);
        }
        return this.toAjax(this.umPbxGroupConfigService.saveOrUpdate((Object)config));
    }

    @ApiOperation(value="SIP\u5c0f\u4ea4\u7fa4\u7ec4\u5173\u95ed")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u5c0f\u4ea4\u7fa4", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/pbxGroupNumber/close/{id}"})
    public AjaxResult pbxGroupUpdateClose(@PathVariable Long id) {
        if (ObjectUtils.isEmpty((Object)id)) {
            return this.toAjax(0);
        }
        UmPbxGroupConfig umPbxGroupConfig = (UmPbxGroupConfig)this.umPbxGroupConfigService.getById((Serializable)id);
        if (umPbxGroupConfig != null) {
            SipUser sipUser = this.sipUserService.getSipUserByDeviceId(umPbxGroupConfig.getDeviceId());
            UserBusinessUtils.delComplexBusiness((String)SipUserBusinessEnum.COMPLEX_PBX_GROUP.getCode(), (SipUser)sipUser);
            UpdateWrapper wrapper = new UpdateWrapper();
            ((UpdateWrapper)wrapper.set((Object)"complex_business", (Object)sipUser.getComplexBusiness())).eq((Object)"id", (Object)sipUser.getId());
            this.sipUserService.update((Wrapper)wrapper);
        }
        return this.toAjax(this.umPbxGroupConfigService.removeById((Serializable)id));
    }

    @ApiOperation(value="SIP\u5c0f\u4ea4\u7fa4\u7ec4\u641c\u7d22")
    @GetMapping(value={"/pbxGroupNumber/getGroupNumbers"})
    public AjaxResult pbxGroupUpdateGetGroupNumbers() {
        this.LOGGER.debug("SIP\u5c0f\u4ea4\u7fa4\u7ec4\u53f7\u67e5\u8be2");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{UmPbxGroupNumber::getGroupNumber});
        List list = this.umPbxGroupNumberService.list((Wrapper)wrapper);
        ArrayList groupNumbers = new ArrayList();
        list.forEach(number -> {
            HashMap<String, Long> map = new HashMap<String, Long>(2);
            map.put("dictValue", number.getGroupNumber());
            map.put("dictLabel", number.getGroupNumber());
            groupNumbers.add(map);
        });
        return AjaxResult.success(groupNumbers);
    }

    @ApiOperation(value="SIP\u5c0f\u4ea4\u7fa4\u7ec4\u641c\u7d22")
    @GetMapping(value={"/pbxGroupNumber/search/{groupNumber}"})
    public AjaxResult<List<QueryUmPbxGroupConfig>> pbxGroupUpdateSearch(@PathVariable Long groupNumber) {
        if (ObjectUtils.isEmpty((Object)groupNumber)) {
            return this.toAjax(0);
        }
        return AjaxResult.success((Object)this.umPbxGroupConfigService.queryPbxGroupNumber(groupNumber));
    }
}

