/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.userMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.SipUserBusinessEnum;
import com.uscale.common.enums.SipUserOnlyServiceEnum;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.SipUser;
import com.uscale.system.entity.UmSipUserOnlyService;
import com.uscale.system.service.IGlsHuntGroupTimeRangeService;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.service.IUmSipUserOnlyServiceService;
import com.uscale.system.tool.UserBusinessUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e00\u53f7\u901a"})
@RestController
@RequestMapping(value={"/userMng/sip/onlyService"})
public class SipUserOnlyServiceController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SipUserOnlyServiceController.class);
    private static final Gson GSON = new Gson();
    private static final Type GSON_LIST_TYPE_ONLY_SERVICE = new /* Unavailable Anonymous Inner Class!! */.getType();
    private final String[] ONLY_SERVICE_CONFLICT_BUSINESS = new String[]{SipUserBusinessEnum.COMPLEX_CHANGE_NUMBER.getCode(), SipUserBusinessEnum.GROUP_MLA.getCode()};
    private final IUmSipUserOnlyServiceService iUmSipUserOnlyServiceService;
    private final ISipUserService iSipUserService;
    private final IGlsHuntGroupTimeRangeService iGlsHuntGroupTimeRangeService;

    @Autowired
    public SipUserOnlyServiceController(ISipUserService iSipUserService, IUmSipUserOnlyServiceService iUmSipUserOnlyServiceService, IGlsHuntGroupTimeRangeService iGlsHuntGroupTimeRangeService) {
        this.iSipUserService = iSipUserService;
        this.iUmSipUserOnlyServiceService = iUmSipUserOnlyServiceService;
        this.iGlsHuntGroupTimeRangeService = iGlsHuntGroupTimeRangeService;
    }

    @GetMapping(value={"/init/{sipId}"})
    public AjaxResult<Map<String, Object>> onlyServiceInit(@PathVariable(value="sipId") Long sipId) {
        if (ObjectUtils.isEmpty((Object)sipId)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserOnlyServiceController.param.null", (Object[])new Object[0]));
        }
        SipUser sipUser = (SipUser)this.iSipUserService.getById((Serializable)sipId);
        if (ObjectUtils.isEmpty((Object)sipUser)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserOnlyServiceController.user.null", (Object[])new Object[0]));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UmSipUserOnlyService::getDeviceId, (Object)sipUser.getDeviceId());
        List tableData = this.iUmSipUserOnlyServiceService.list((Wrapper)wrapper);
        ArrayList deviceIds = new ArrayList();
        tableData.forEach(item -> {
            if (SipUserOnlyServiceEnum.BOUND_TERMINAL_ATTRIBUTES_INTRA.getCode().equals(item.getBoundTerminalAttributes())) {
                deviceIds.add(item.getTerminalNumber());
            }
        });
        if (!CollectionUtils.isEmpty(deviceIds)) {
            LambdaQueryWrapper sipUserQueryWrapper = new LambdaQueryWrapper();
            sipUserQueryWrapper.select(new SFunction[]{SipUser::getNumber, SipUser::getDeviceId}).in(SipUser::getDeviceId, deviceIds);
            List list = this.iSipUserService.list((Wrapper)sipUserQueryWrapper);
            tableData.forEach(item -> list.forEach(user -> {
                if (item.getTerminalNumber().equals(user.getDeviceId())) {
                    item.setTerminalNumber(user.getNumber());
                }
            }));
        }
        List ranges = this.iGlsHuntGroupTimeRangeService.list();
        HashMap<String, Object> res = new HashMap<String, Object>(3);
        res.put("formData", sipUser);
        res.put("tableData", tableData);
        res.put("timeRanges", ranges);
        return AjaxResult.success(res);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4e00\u53f7\u901a\u914d\u7f6e")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u4e00\u53f7\u901a", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/save"})
    public AjaxResult onlyServiceSave(@RequestBody Map<String, Object> params) {
        if (ObjectUtils.isEmpty(params) || ObjectUtils.isEmpty((Object)params.get("formData")) || ObjectUtils.isEmpty((Object)params.get("tableData"))) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserOnlyServiceController.param.null", (Object[])new Object[0]));
        }
        String json = GSON.toJson(params.get("formData"));
        SipUser sipUser = (SipUser)GSON.fromJson(json, SipUser.class);
        if (ObjectUtils.isEmpty((Object)sipUser) || ObjectUtils.isEmpty((Object)sipUser.getId()) || ObjectUtils.isEmpty((Object)this.iSipUserService.getById((Serializable)sipUser.getId()))) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserOnlyServiceController.user.data.null", (Object[])new Object[0]));
        }
        LOGGER.debug("\u4fdd\u5b58\u4e00\u53f7\u901a\u914d\u7f6e\uff0cjson\u6620\u5c04sipUser=[{}]", (Object)GSON.toJson((Object)sipUser));
        if (UserBusinessUtils.isOpenComplexBusiness((String[])this.ONLY_SERVICE_CONFLICT_BUSINESS, (SipUser)sipUser)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserOnlyServiceController.open.tip1", (Object[])new Object[0]));
        }
        json = GSON.toJson(params.get("tableData"));
        List onlyServices = (List)GSON.fromJson(json, GSON_LIST_TYPE_ONLY_SERVICE);
        Optional<UmSipUserOnlyService> only = onlyServices.stream().filter(item -> item.getDeviceId().equals(item.getTerminalNumber())).findFirst();
        only.ifPresent(o -> {
            o.setValidityPeriod(SipUserOnlyServiceEnum.VALIDITY_PERIOD_DEFAULT.getCode());
            this.iUmSipUserOnlyServiceService.updateById(o);
            onlyServices.remove(o);
        });
        ArrayList list = new ArrayList();
        List numbers = onlyServices.stream().filter(item -> SipUserOnlyServiceEnum.BOUND_TERMINAL_ATTRIBUTES_INTRA.getCode().equals(item.getBoundTerminalAttributes())).map(UmSipUserOnlyService::getTerminalNumber).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(numbers)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.select(new SFunction[]{SipUser::getNumber, SipUser::getDeviceId}).in(SipUser::getNumber, numbers)).or()).in(SipUser::getLongNumber, numbers)).or()).in(SipUser::getReplaceOldNumber, numbers)).or()).in(SipUser::getReplaceOldLongNumber, numbers);
            list.addAll(this.iSipUserService.list((Wrapper)wrapper));
        }
        if (list.size() != numbers.size()) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserOnlyServiceController.internal.number.null", (Object[])new Object[0]));
        }
        onlyServices.forEach(item -> {
            if (SipUserOnlyServiceEnum.BOUND_TERMINAL_ATTRIBUTES_INTRA.getCode().equals(item.getBoundTerminalAttributes())) {
                for (SipUser user : list) {
                    if (!user.getNumber().equals(item.getTerminalNumber())) continue;
                    item.setTerminalNumber(user.getDeviceId());
                    break;
                }
            }
        });
        LOGGER.debug("\u4fdd\u5b58\u4e00\u53f7\u901a\u914d\u7f6e\uff0cjson\u6620\u5c04onlyServices=[{}]", (Object)GSON.toJson((Object)onlyServices));
        return this.iUmSipUserOnlyServiceService.saveOnlyServiceData(sipUser, onlyServices);
    }

    @ApiOperation(value="\u5220\u9664\u4e00\u53f7\u901a\u914d\u7f6e")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u4e00\u53f7\u901a", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/delete/{ids}"})
    public AjaxResult onlyServiceDelete(@PathVariable Long[] ids) {
        if (ObjectUtils.isEmpty((Object[])ids)) {
            LOGGER.error("\u5220\u9664\u4e00\u53f7\u901a\u914d\u7f6e\u53c2\u6570\u4e3a\u7a7a");
            return AjaxResult.error();
        }
        return this.toAjax(this.iUmSipUserOnlyServiceService.deleteOnlyServiceDataExceptDefault(Arrays.asList(ids)));
    }
}

