/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.userMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.annotation.RepeatSubmit;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.SipUserBusinessEnum;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.SipUser;
import com.uscale.system.entity.UmSipUserForwardingService;
import com.uscale.system.enums.UmSipUserForwardingServiceRightEnum;
import com.uscale.system.enums.UmSipUserForwardingServiceServiceEnum;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.service.IUmSipUserForwardingServiceService;
import com.uscale.system.service.UmUserBusinessRegisterStateService;
import com.uscale.system.tool.RecordingDiscUtils;
import com.uscale.system.tool.UserBusinessUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u524d\u8f6c\u4e1a\u52a1"})
@RestController
@RequestMapping(value={"/userMng/sip"})
public class SipUserForwardingController
extends BaseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final Gson GSON = new Gson();
    private final SipUserBusinessEnum[][] UNCONDITIONAL_VOICE_CONFLICT_BUSINESS = new SipUserBusinessEnum[][]{{SipUserBusinessEnum.SIMPLE_ABSENT_USER, SipUserBusinessEnum.SIMPLE_CLOCK}, {SipUserBusinessEnum.COMPLEX_PBX_GROUP}};
    private final SipUserBusinessEnum[][] UNCONDITIONAL_NUMBER_CONFLICT_BUSINESS = new SipUserBusinessEnum[][]{{SipUserBusinessEnum.SIMPLE_ABSENT_USER, SipUserBusinessEnum.SIMPLE_DO_NOT_DISTURB, SipUserBusinessEnum.SIMPLE_CLOCK}, {SipUserBusinessEnum.COMPLEX_SECRETARY, SipUserBusinessEnum.COMPLEX_PBX_GROUP}};
    private final SipUserBusinessEnum[][] ON_BUSY_VOICE_CONFLICT_BUSINESS = new SipUserBusinessEnum[][]{{SipUserBusinessEnum.SIMPLE_ABSENT_USER, SipUserBusinessEnum.SIMPLE_CLOCK}, {SipUserBusinessEnum.COMPLEX_PBX_GROUP}};
    private final SipUserBusinessEnum[][] ON_BUSY_NUMBER_CONFLICT_BUSINESS = new SipUserBusinessEnum[][]{{SipUserBusinessEnum.SIMPLE_ABSENT_USER, SipUserBusinessEnum.SIMPLE_DO_NOT_DISTURB, SipUserBusinessEnum.SIMPLE_CLOCK}, {SipUserBusinessEnum.COMPLEX_SECRETARY, SipUserBusinessEnum.COMPLEX_PBX_GROUP}};
    private final SipUserBusinessEnum[][] ON_NO_REPLY_VOICE_CONFLICT_BUSINESS = new SipUserBusinessEnum[][]{{SipUserBusinessEnum.SIMPLE_ABSENT_USER, SipUserBusinessEnum.SIMPLE_DO_NOT_DISTURB, SipUserBusinessEnum.SIMPLE_CLOCK}, {SipUserBusinessEnum.COMPLEX_PBX_GROUP}};
    private final SipUserBusinessEnum[][] ON_NO_REPLY_NUMBER_CONFLICT_BUSINESS = new SipUserBusinessEnum[][]{{SipUserBusinessEnum.SIMPLE_ABSENT_USER, SipUserBusinessEnum.SIMPLE_DO_NOT_DISTURB, SipUserBusinessEnum.SIMPLE_CLOCK}, {SipUserBusinessEnum.COMPLEX_PBX_GROUP}};
    private final SipUserBusinessEnum[][] OFFLINE_VOICE_CONFLICT_BUSINESS = new SipUserBusinessEnum[][]{new SipUserBusinessEnum[0], {SipUserBusinessEnum.COMPLEX_PBX_GROUP}};
    private final SipUserBusinessEnum[][] OFFLINE_NUMBER_CONFLICT_BUSINESS = new SipUserBusinessEnum[][]{new SipUserBusinessEnum[0], {SipUserBusinessEnum.COMPLEX_PBX_GROUP}};
    private final Object[][] CHECK_CONFLICT = new Object[][]{{"\u65e0\u6761\u4ef6\u524d\u8f6c\u8bed\u97f3\u4fe1\u7bb1", "forwardingUnconditionalVoiceMailboxService", "forwardingUnconditionalVoiceMailboxRight", this.UNCONDITIONAL_VOICE_CONFLICT_BUSINESS, SipUserBusinessEnum.COMPLEX_FORWARDING_UNCONDITIONAL_VOICE_MAILBOX}, {"\u65e0\u6761\u4ef6\u547c\u53eb\u524d\u8f6c", "forwardingUnconditionalNumberService", "forwardingUnconditionalNumberRight", this.UNCONDITIONAL_NUMBER_CONFLICT_BUSINESS, SipUserBusinessEnum.COMPLEX_FORWARDING_UNCONDITIONAL_NUMBER}, {"\u65e0\u5e94\u7b54\u524d\u8f6c\u8bed\u97f3\u4fe1\u7bb1", "forwardingOnNoReplyVoiceMailboxService", "forwardingOnNoReplyVoiceMailboxRight", this.ON_NO_REPLY_VOICE_CONFLICT_BUSINESS, SipUserBusinessEnum.COMPLEX_FORWARDING_ON_NO_REPLY_VOICE_MAILBOX}, {"\u65e0\u5e94\u7b54\u547c\u53eb\u524d\u8f6c", "forwardingOnNoReplyNumberService", "forwardingOnNoReplyNumberRight", this.ON_NO_REPLY_NUMBER_CONFLICT_BUSINESS, SipUserBusinessEnum.COMPLEX_FORWARDING_ON_NO_REPLY_NUMBER}, {"\u9047\u5fd9\u524d\u8f6c\u8bed\u97f3\u4fe1\u7bb1", "forwardingOnBusyVoiceMailboxService", "forwardingOnBusyVoiceMailboxRight", this.ON_BUSY_VOICE_CONFLICT_BUSINESS, SipUserBusinessEnum.COMPLEX_FORWARDING_ON_BUSY_VOICE_MAILBOX}, {"\u9047\u5fd9\u547c\u53eb\u524d\u8f6c", "forwardingOnBusyNumberService", "forwardingOnBusyNumberRight", this.ON_BUSY_NUMBER_CONFLICT_BUSINESS, SipUserBusinessEnum.COMPLEX_FORWARDING_ON_BUSY_NUMBER}, {"\u79bb\u7ebf\u524d\u8f6c\u8bed\u97f3\u4fe1\u7bb1", "forwardingOfflineVoiceMailboxService", "forwardingOfflineVoiceMailboxRight", this.OFFLINE_VOICE_CONFLICT_BUSINESS, SipUserBusinessEnum.COMPLEX_FORWARDING_OFFLINE_VOICE_MAILBOX}, {"\u79bb\u7ebf\u547c\u53eb\u524d\u8f6c", "forwardingOfflineNumberService", "forwardingOfflineNumberRight", this.OFFLINE_NUMBER_CONFLICT_BUSINESS, SipUserBusinessEnum.COMPLEX_FORWARDING_OFFLINE_NUMBER}};
    private final ISipUserService iSipUserService;
    private final UmUserBusinessRegisterStateService businessRegisterStateService;
    private final IUmSipUserForwardingServiceService umSipUserForwardingServiceService;

    @Autowired
    public SipUserForwardingController(ISipUserService iSipUserService, UmUserBusinessRegisterStateService businessRegisterStateService, IUmSipUserForwardingServiceService umSipUserForwardingServiceService) {
        this.iSipUserService = iSipUserService;
        this.businessRegisterStateService = businessRegisterStateService;
        this.umSipUserForwardingServiceService = umSipUserForwardingServiceService;
    }

    @ApiOperation(value="\u67e5\u8be2\u524d\u8f6c\u4e1a\u52a1\u5217\u8868")
    @GetMapping(value={"/forwardingServiceList"})
    public TableDataInfo<UmSipUserForwardingService> list(Long startNumber, Long endNumber, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (!ObjectUtils.isEmpty((Object)startNumber)) {
            queryWrapper.ge(UmSipUserForwardingService::getDeviceId, (Object)startNumber);
        }
        if (!ObjectUtils.isEmpty((Object)endNumber)) {
            queryWrapper.le(UmSipUserForwardingService::getDeviceId, (Object)endNumber);
        }
        queryWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(UmSipUserForwardingService::getForwardingUnconditionalVoiceMailboxService, (Object)"enable")).or()).eq(UmSipUserForwardingService::getForwardingUnconditionalNumberService, (Object)"enable")).or()).eq(UmSipUserForwardingService::getForwardingOnNoReplyVoiceMailboxService, (Object)"enable")).or()).eq(UmSipUserForwardingService::getForwardingOnNoReplyNumberService, (Object)"enable")).or()).eq(UmSipUserForwardingService::getForwardingOnBusyVoiceMailboxService, (Object)"enable")).or()).eq(UmSipUserForwardingService::getForwardingOnBusyNumberService, (Object)"enable")).or()).eq(UmSipUserForwardingService::getForwardingOfflineVoiceMailboxService, (Object)"enable")).or()).eq(UmSipUserForwardingService::getForwardingOfflineNumberService, (Object)"enable");
        });
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        Page result = (Page)this.umSipUserForwardingServiceService.page((IPage)page, (Wrapper)queryWrapper);
        if (result != null && page.getRecords() != null) {
            for (UmSipUserForwardingService service : page.getRecords()) {
                String deviceId = service.getDeviceId();
                SipUser sipUser = this.iSipUserService.getSipUserByDeviceId(deviceId);
                if (sipUser == null) continue;
                service.setSipNumber(sipUser.getNumber());
            }
        }
        return this.getDataTable(result);
    }

    @ApiOperation(value="\u6839\u636e\u8bbe\u5907ID\u67e5\u8be2\u524d\u8f6c\u4e1a\u52a1\u4fe1\u606f")
    @GetMapping(value={"/getForwardingService/{deviceId}"})
    public AjaxResult<UmSipUserForwardingService> getForwardingService(@PathVariable String deviceId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UmSipUserForwardingService::getDeviceId, (Object)deviceId);
        return AjaxResult.success((Object)this.umSipUserForwardingServiceService.getOne((Wrapper)wrapper));
    }

    @ApiOperation(value="\u6839\u636e\u53f7\u7801\u67e5\u8be2\u524d\u8f6c\u4e1a\u52a1\u4fe1\u606f")
    @GetMapping(value={"/getForwardingServiceByNumber/{number}"})
    public AjaxResult<UmSipUserForwardingService> getForwardingServiceByNumber(@PathVariable String number) {
        SipUser sipUser = this.iSipUserService.getSipUserByNumber(number);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UmSipUserForwardingService::getDeviceId, (Object)sipUser.getDeviceId());
        return AjaxResult.success((Object)this.umSipUserForwardingServiceService.getOne((Wrapper)wrapper));
    }

    @ApiOperation(value="\u4fee\u6539SIP\u7528\u6237\u590d\u6742\u4e1a\u52a1 \u524d\u8f6c\u4e1a\u52a1")
    @RepeatSubmit
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u524d\u8f6c\u4e1a\u52a1", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/saveOrUpdateForwardingService"})
    public AjaxResult saveOrUpdateForwardingService(@RequestBody UmSipUserForwardingService forwardingService) throws Exception {
        SipUser sipUser;
        if (ObjectUtils.isEmpty((Object)forwardingService)) {
            this.LOGGER.error("\u65b0\u589e\u6216\u4fee\u6539\u524d\u8f6c\u4e1a\u52a1\uff0c\u53c2\u6570\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5931\u8d25");
            return AjaxResult.error();
        }
        String deviceId = forwardingService.getDeviceId();
        if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)deviceId)) {
            sipUser = this.iSipUserService.getSipUserByNumber(forwardingService.getSipNumber());
            deviceId = sipUser.getDeviceId();
        }
        if (ObjectUtils.isEmpty((Object)(sipUser = this.iSipUserService.getSipUserByDeviceId(deviceId)))) {
            this.LOGGER.error("\u65b0\u589e\u6216\u4fee\u6539\u524d\u8f6c\u4e1a\u52a1\uff0c\u6839\u636e\u5f85\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u672a\u67e5\u8be2\u5230\u7528\u6237\uff1aforwardingService=[{}]", (Object)GSON.toJson((Object)forwardingService));
            return AjaxResult.error();
        }
        boolean isCheckForwardingNumber = this.checkForwardingNumber(sipUser, forwardingService);
        if (isCheckForwardingNumber) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserForwardingController.forward.nunber", (Object[])new Object[0]));
        }
        RecordingDiscUtils.checkForwarding((UmSipUserForwardingService)forwardingService);
        List registeredSimpleBusiness = this.businessRegisterStateService.queryRegisteredBusiness(sipUser.getDeviceId());
        UserBusinessUtils.delComplexBusiness((String)SipUserBusinessEnum.COMPLEX_FORWARDING_SERVICE.getCode(), (SipUser)sipUser);
        AjaxResult ajaxResult = this.checkBusinessConflict(sipUser, forwardingService, registeredSimpleBusiness);
        this.addBusiness(sipUser, forwardingService);
        if (ajaxResult.get("code").equals(500)) {
            return ajaxResult;
        }
        LambdaUpdateWrapper sipUserWrapper = new LambdaUpdateWrapper();
        sipUserWrapper.set(SipUser::getComplexBusiness, (Object)sipUser.getComplexBusiness());
        sipUserWrapper.eq(SipUser::getDeviceId, (Object)deviceId);
        this.iSipUserService.saveOrUpdate((Object)new SipUser(), (Wrapper)sipUserWrapper);
        return this.toAjax(this.umSipUserForwardingServiceService.saveOrUpdate((Object)forwardingService));
    }

    private void addBusiness(SipUser sipUser, UmSipUserForwardingService forwardingService) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        for (Object[] obj : this.CHECK_CONFLICT) {
            String field = (String)obj[2];
            PropertyDescriptor prop = new PropertyDescriptor(field, UmSipUserForwardingService.class);
            Method methods = prop.getReadMethod();
            Object res = methods.invoke((Object)forwardingService, new Object[0]);
            String businessKey = ((SipUserBusinessEnum)obj[4]).getCode();
            if (UmSipUserForwardingServiceRightEnum.RIGHT_OFF.equals(res)) {
                UserBusinessUtils.delComplexBusiness((String)businessKey, (SipUser)sipUser);
                continue;
            }
            UserBusinessUtils.addComplexBusiness((String)businessKey, (SipUser)sipUser);
            UserBusinessUtils.addComplexBusiness((String)SipUserBusinessEnum.COMPLEX_FORWARDING_SERVICE.getCode(), (SipUser)sipUser);
        }
    }

    private AjaxResult checkBusinessConflict(SipUser sipUser, UmSipUserForwardingService forwardingService, List<String> registeredSimpleBusiness) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        for (Object[] obj : this.CHECK_CONFLICT) {
            SipUserBusinessEnum[] complexBusinessEnums;
            String field = (String)obj[1];
            PropertyDescriptor prop = new PropertyDescriptor(field, UmSipUserForwardingService.class);
            Method method = prop.getReadMethod();
            Object res = method.invoke((Object)forwardingService, new Object[0]);
            if (ObjectUtils.isEmpty((Object)res)) {
                return AjaxResult.error();
            }
            if (UmSipUserForwardingServiceServiceEnum.SERVICE_DISABLE.equals(res)) continue;
            SipUserBusinessEnum[][] businessEnums = (SipUserBusinessEnum[][])obj[3];
            String message = (String)obj[0];
            SipUserBusinessEnum[] simpleBusinessEnums = businessEnums[0];
            SipUser checkSimpleBusiness = new SipUser();
            checkSimpleBusiness.setSimpleBusiness(registeredSimpleBusiness.toArray(new String[0]));
            for (SipUserBusinessEnum item : simpleBusinessEnums) {
                if (!UserBusinessUtils.isOpenSimpleBusiness((String)item.getCode(), (SipUser)checkSimpleBusiness)) continue;
                this.LOGGER.warn("\u524d\u8f6c\u4e1a\u52a1\u68c0\u67e5\u5230\u7b80\u5355\u4e1a\u52a1\u51b2\u7a81\uff1asimpleBusinessKey=[{}], number=[{}]", (Object)item.getCode(), (Object)sipUser.getNumber());
                String msg = MessageUtils.message((String)"SipUserForwardingController.forward.business.conflict", (Object[])new Object[]{message, item.getName()});
                return AjaxResult.error((String)msg);
            }
            for (SipUserBusinessEnum item : complexBusinessEnums = businessEnums[1]) {
                if (!UserBusinessUtils.isOpenComplexBusiness((String)item.getCode(), (SipUser)sipUser)) continue;
                this.LOGGER.warn("\u524d\u8f6c\u4e1a\u52a1\u68c0\u67e5\u5230\u590d\u6742\u4e1a\u52a1\u51b2\u7a81\uff1acomplexBusinessKey=[{}], number=[{}]", (Object)item.getCode(), (Object)sipUser.getNumber());
                String msg = MessageUtils.message((String)"SipUserForwardingController.forward.business.conflict", (Object[])new Object[]{message, item.getName()});
                return AjaxResult.error((String)msg);
            }
        }
        return AjaxResult.success();
    }

    private boolean checkForwardingNumber(SipUser sipUser, UmSipUserForwardingService forwardingService) {
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)sipUser) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)forwardingService)) {
            String sipNumber = sipUser.getNumber();
            if (StringUtils.isBlank((CharSequence)sipNumber)) {
                return false;
            }
            if (StringUtils.equals((CharSequence)sipNumber, (CharSequence)forwardingService.getForwardingUnconditionalForwardingNumber())) {
                return true;
            }
            if (StringUtils.equals((CharSequence)sipNumber, (CharSequence)forwardingService.getForwardingOnNoReplyForwardingNumber())) {
                return true;
            }
            if (StringUtils.equals((CharSequence)sipNumber, (CharSequence)forwardingService.getForwardingOnBusyForwardingNumber())) {
                return true;
            }
            if (StringUtils.equals((CharSequence)sipNumber, (CharSequence)forwardingService.getForwardingOfflineForwardingNumber())) {
                return true;
            }
        }
        return false;
    }
}

