/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.userMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.SipUserBusinessEnum;
import com.uscale.system.entity.SipUser;
import com.uscale.system.service.IEndpointsService;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.tool.UserBusinessUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f20\u771f"})
@RestController
@RequestMapping(value={"/userMng/sip"})
public class SipUserFaxController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SipUserFaxController.class);
    private static final Gson GSON = new Gson();
    private final ISipUserService iSipUserService;
    private final IEndpointsService iEndpointsService;
    private static final String FAX_SWITCH = "faxSwitch";
    private static final String FAX_MODE = "faxMode";
    private static final String SWITCH_OFF = "off";

    @Autowired
    public SipUserFaxController(ISipUserService iSipUserService, IEndpointsService iEndpointsService) {
        this.iSipUserService = iSipUserService;
        this.iEndpointsService = iEndpointsService;
    }

    @ApiModelProperty(value="\u67e5\u8be2\u4f20\u771f\u6a21\u5f0f")
    @GetMapping(value={"/getFaxMode/{sipUserId}"})
    public AjaxResult<SipUser> getFaxMode(@PathVariable(value="sipUserId") Long sipUserId) {
        if (ObjectUtils.isEmpty((Object)sipUserId)) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237\u4f20\u771f\u914d\u7f6e\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5931\u8d25");
            return AjaxResult.error();
        }
        SipUser sipUser = (SipUser)this.iSipUserService.getById((Serializable)sipUserId);
        if (ObjectUtils.isEmpty((Object)sipUser)) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237\u4f20\u771f\u914d\u7f6e\uff0c\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u5931\u8d25\uff1asipUserId=[{}]", (Object)sipUserId);
            return AjaxResult.error();
        }
        return AjaxResult.success((Object)sipUser);
    }

    @ApiModelProperty(value="\u4fee\u6539\u4f20\u771f\u6570\u636e")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u4f20\u771f", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/saveOrUpdateFaxMode/{sipUserId}"})
    public AjaxResult saveOrUpdateFaxMode(@RequestBody Map<String, Object> map, @PathVariable Long sipUserId) {
        LOGGER.debug("\u4fee\u6539\u4f20\u771f\u6570\u636e\uff0c\u53c2\u6570\uff1asipUserId=[{}], map=[{}]", (Object)sipUserId, (Object)GSON.toJson(map));
        if (ObjectUtils.isEmpty((Object)sipUserId)) {
            LOGGER.error("\u4fee\u6539\u4f20\u771f\u6570\u636e\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5931\u8d25");
            return AjaxResult.error();
        }
        SipUser sipUser = (SipUser)this.iSipUserService.getById((Serializable)sipUserId);
        if (ObjectUtils.isEmpty((Object)sipUser)) {
            LOGGER.error("\u4fee\u6539\u4f20\u771f\u6570\u636e\uff0c\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u5931\u8d25\uff1asipUserId=[{}]", (Object)sipUserId);
            return AjaxResult.error();
        }
        String faxDetect = null;
        int fax_detect_timeout = 0;
        String t38_udptl = "no";
        String t38_udptl_ec = "none";
        int t38_udptl_maxdatagram = 0;
        UpdateWrapper wrapper = new UpdateWrapper();
        if (!SWITCH_OFF.equals(map.get(FAX_SWITCH).toString())) {
            faxDetect = "yes";
            String fax_mode = map.get(FAX_MODE).toString();
            wrapper.set((Object)"fax_switch", (Object)map.get(FAX_SWITCH).toString());
            wrapper.set((Object)"fax_mode", (Object)map.get(FAX_MODE).toString());
            fax_detect_timeout = 30;
            if (StringUtils.equals((CharSequence)fax_mode, (CharSequence)"t38")) {
                t38_udptl = "yes";
                t38_udptl_ec = "none";
                t38_udptl_maxdatagram = 0;
            } else if (StringUtils.equals((CharSequence)fax_mode, (CharSequence)"transparent")) {
                t38_udptl = "no";
                t38_udptl_ec = "none";
                t38_udptl_maxdatagram = 0;
            }
            UserBusinessUtils.addComplexBusiness((String)SipUserBusinessEnum.COMPLEX_FAX.getCode(), (SipUser)sipUser);
        } else {
            faxDetect = "no";
            wrapper.set((Object)"fax_switch", (Object)map.get(FAX_SWITCH).toString());
            wrapper.set((Object)"fax_mode", null);
            UserBusinessUtils.delComplexBusiness((String)SipUserBusinessEnum.COMPLEX_FAX.getCode(), (SipUser)sipUser);
        }
        wrapper.set((Object)"complex_business", (Object)sipUser.getComplexBusiness());
        wrapper.eq((Object)"id", (Object)sipUserId);
        String deviceId = sipUser.getDeviceId();
        if (ObjectUtils.isEmpty((Object)deviceId)) {
            LOGGER.error("\u4fee\u6539\u4f20\u771f\u6570\u636e\uff0c\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u5931\u8d25\uff1asipUserNumber=[{}]", (Object)sipUser.getNumber());
            return AjaxResult.error();
        }
        UpdateWrapper endpointsWrapper = new UpdateWrapper();
        endpointsWrapper.set((Object)"fax_detect", (Object)faxDetect);
        endpointsWrapper.set((Object)"t38_udptl", (Object)t38_udptl);
        endpointsWrapper.set((Object)"t38_udptl_ec", (Object)t38_udptl_ec);
        endpointsWrapper.set((Object)"t38_udptl_maxdatagram", (Object)t38_udptl_maxdatagram);
        endpointsWrapper.set((Object)"fax_detect_timeout", (Object)fax_detect_timeout);
        endpointsWrapper.eq((Object)"id", (Object)deviceId);
        boolean fax_detect_boo = this.iEndpointsService.update((Wrapper)endpointsWrapper);
        if (!fax_detect_boo) {
            LOGGER.error("\u4fee\u6539\u4f20\u771f\u6570\u636e\uff0c\u66f4\u65b0\u4f20\u771f\u5b57\u6bb5\u5931\u8d25!");
            return AjaxResult.error();
        }
        return AjaxResult.success((Object)this.iSipUserService.saveOrUpdate((Object)new SipUser(), (Wrapper)wrapper));
    }
}

