/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.userMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.system.entity.Endpoints;
import com.uscale.system.entity.SipUser;
import com.uscale.system.service.IEndpointsService;
import com.uscale.system.service.ISipUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"SIP\u7528\u6237\u7ec8\u7aef\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/userMng/sip"})
public class SipUserEndpointsController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SipUserEndpointsController.class);
    private static final Gson GSON = new Gson();
    private final ISipUserService iSipUserService;
    private final IEndpointsService iEndpointsService;

    @Autowired
    public SipUserEndpointsController(ISipUserService iSipUserService, IEndpointsService iEndpointsService) {
        this.iSipUserService = iSipUserService;
        this.iEndpointsService = iEndpointsService;
    }

    @ApiOperation(value="\u4fee\u6539IP\u8bdd\u673a\u72b6\u6001\u76d1\u6d4b\u72b6\u6001")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:IP\u8bdd\u673a\u72b6\u6001\u68c0\u6d4b", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/updateIpPhoneStatus/{sipUserId}"})
    public AjaxResult updateIpPhoneStatus(@RequestBody Map<String, Object> map, @PathVariable Long sipUserId) {
        LOGGER.debug("\u4fee\u6539IP\u8bdd\u673a\u72b6\u6001\u76d1\u6d4b\u72b6\u6001\uff0c\u53c2\u6570\uff1asipUserId=[{}], map=[{}]", (Object)sipUserId, (Object)GSON.toJson(map));
        if (ObjectUtils.isEmpty((Object)sipUserId)) {
            LOGGER.error("\u4fee\u6539IP\u8bdd\u673a\u72b6\u6001\u76d1\u6d4b\u72b6\u6001\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5931\u8d25");
            return AjaxResult.error();
        }
        SipUser sipUser = (SipUser)this.iSipUserService.getById((Serializable)sipUserId);
        if (ObjectUtils.isEmpty((Object)sipUser)) {
            LOGGER.error("\u4fee\u6539IP\u8bdd\u673a\u72b6\u6001\u76d1\u6d4b\u72b6\u6001\uff0c\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u5931\u8d25\uff1asipUserId=[{}]", (Object)sipUserId);
            return AjaxResult.error();
        }
        String allowSubscribe = map.get("activate").toString();
        if (ObjectUtils.isEmpty((Object)allowSubscribe)) {
            LOGGER.error("\u4fee\u6539IP\u8bdd\u673a\u72b6\u6001\u76d1\u6d4b\u72b6\u6001\uff0c\u72b6\u6001\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            return AjaxResult.error();
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.set((Object)"allow_subscribe", (Object)allowSubscribe);
        String sipUserNumber = sipUser.getNumber();
        if (ObjectUtils.isEmpty((Object)sipUserNumber)) {
            LOGGER.error("\u4fee\u6539IP\u8bdd\u673a\u72b6\u6001\u76d1\u6d4b\u72b6\u6001\uff0c\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u5931\u8d25\uff1asipUserNumber=[{}]", (Object)sipUserNumber);
            return AjaxResult.error();
        }
        wrapper.eq((Object)"id", (Object)sipUserNumber);
        return AjaxResult.success((Object)this.iEndpointsService.update((Wrapper)wrapper));
    }

    @ApiOperation(value="\u67e5\u8be2SIP\u7528\u6237\u7ec8\u7aef\u4fe1\u606f")
    @GetMapping(value={"/getSipEndPoints/{sipUserId}"})
    public AjaxResult<Endpoints> getSipEndPoints(@PathVariable(value="sipUserId") Long sipUserId) {
        if (ObjectUtils.isEmpty((Object)sipUserId)) {
            LOGGER.error("\u67e5\u8be2IP\u8bdd\u673a\u72b6\u6001\u76d1\u6d4b\u72b6\u6001\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5931\u8d25");
            return AjaxResult.error();
        }
        SipUser sipUser = (SipUser)this.iSipUserService.getById((Serializable)sipUserId);
        if (ObjectUtils.isEmpty((Object)sipUser)) {
            LOGGER.error("\u67e5\u8be2IIP\u8bdd\u673a\u72b6\u6001\u76d1\u6d4b\u72b6\u6001\uff0c\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u5931\u8d25\uff1asipUserId=[{}]", (Object)sipUserId);
            return AjaxResult.error();
        }
        return AjaxResult.success((Object)this.iEndpointsService.queryById(sipUser.getDeviceId()));
    }
}

