/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.userMng;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.annotation.RepeatSubmit;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.RedisKeyEnum;
import com.uscale.common.enums.SipUserBusinessEnum;
import com.uscale.common.exception.CustomException;
import com.uscale.common.exception.file.ConfFileException;
import com.uscale.common.utils.DateUtils;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.SecurityUtils;
import com.uscale.common.utils.ip.IpTool;
import com.uscale.common.utils.poi.ExcelUtils;
import com.uscale.system.dao.PsContactsDao;
import com.uscale.system.entity.Acltable;
import com.uscale.system.entity.Endpoints;
import com.uscale.system.entity.GsHuntGroupMember;
import com.uscale.system.entity.GsPagingGroup;
import com.uscale.system.entity.GsPagingGroupInitiators;
import com.uscale.system.entity.GsPagingGroupMember;
import com.uscale.system.entity.License;
import com.uscale.system.entity.PsContacts;
import com.uscale.system.entity.SipUser;
import com.uscale.system.entity.TmCallSource;
import com.uscale.system.entity.UmOutgoingBusyCallback;
import com.uscale.system.entity.UmSipUserOutgoingCallRestriction;
import com.uscale.system.entity.UmSipUserRinging;
import com.uscale.system.entity.UmSipUserSecretary;
import com.uscale.system.enums.GsPagingGroupIntraOfficeInitiatorsEnum;
import com.uscale.system.model.UpdateSipUserRinging;
import com.uscale.system.model.sip.BatchAuthModify;
import com.uscale.system.model.sip.CreateSip;
import com.uscale.system.model.sip.ModifySip;
import com.uscale.system.model.sip.QuerySip;
import com.uscale.system.service.AcltableService;
import com.uscale.system.service.GsPagingGroupInitiatorsService;
import com.uscale.system.service.GsPagingGroupMemberService;
import com.uscale.system.service.GsPagingGroupService;
import com.uscale.system.service.ICommonDictService;
import com.uscale.system.service.IEndpointsService;
import com.uscale.system.service.IGsHuntGroupMemberService;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.service.ITmCallSourceService;
import com.uscale.system.service.IUmSipUserAudioPagingInitiatorsService;
import com.uscale.system.service.IUmSipUserAudioPagingMemberService;
import com.uscale.system.service.IUmSipUserOutgoingCallRestrictionService;
import com.uscale.system.service.IUmSipUserRingingService;
import com.uscale.system.service.IUmSipUserSecretaryService;
import com.uscale.system.service.UmClockConfigService;
import com.uscale.system.tool.LicenseUtils;
import com.uscale.system.tool.UserBusinessUtils;
import com.uscale.system.vo.ImportResultVO;
import com.uscale.system.vo.SipVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

/*
 * Exception performing whole class analysis ignored.
 */
@Api(tags={"Sip\u7528\u6237\u64cd\u4f5c\u53ca\u4e1a\u52a1\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/userMng/sip"})
public class SipUserController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SipUserController.class);
    private static final Gson GSON = new Gson();
    private final ISipUserService iSipUserService;
    private final IUmSipUserRingingService iUmSipUserRingingService;
    private final IGsHuntGroupMemberService gsHuntGroupMemberService;
    private final IUmSipUserSecretaryService umSipUserSecretaryService;
    private final IUmSipUserAudioPagingMemberService iUmSipUserAudioPagingMemberService;
    private final IUmSipUserAudioPagingInitiatorsService iUmSipUserAudioPagingInitiatorsService;
    private final IUmSipUserOutgoingCallRestrictionService iUmSipUserOutgoingCallRestrictionService;
    private final ICommonDictService commonDictService;
    private final PsContactsDao contactsDao;
    private final JedisPool jedisPool;
    private final GsPagingGroupInitiatorsService gsPagingGroupInitiatorsService;
    private final GsPagingGroupMemberService gsPagingGroupMemberService;
    private final GsPagingGroupService gsPagingGroupService;
    private final AcltableService acltableService;
    private final ITmCallSourceService tmCallSourceService;
    @Autowired
    private IEndpointsService iEndpointsService;
    private final UmClockConfigService clockTaskService;

    @Autowired
    public SipUserController(ISipUserService iSipUserService, IUmSipUserRingingService iUmSipUserRingingService, IGsHuntGroupMemberService gsHuntGroupMemberService, IUmSipUserSecretaryService umSipUserSecretaryService, IUmSipUserAudioPagingMemberService iUmSipUserAudioPagingMemberService, IUmSipUserAudioPagingInitiatorsService iUmSipUserAudioPagingInitiatorsService, IUmSipUserOutgoingCallRestrictionService iUmSipUserOutgoingCallRestrictionService, PsContactsDao contactsDao, JedisPool jedisPool, GsPagingGroupInitiatorsService gsPagingGroupInitiatorsService, GsPagingGroupMemberService gsPagingGroupMemberService, GsPagingGroupService gsPagingGroupService, ICommonDictService commonDictService, AcltableService acltableService, ITmCallSourceService tmCallSourceService, UmClockConfigService clockTaskService) {
        this.iSipUserService = iSipUserService;
        this.iUmSipUserRingingService = iUmSipUserRingingService;
        this.gsHuntGroupMemberService = gsHuntGroupMemberService;
        this.umSipUserSecretaryService = umSipUserSecretaryService;
        this.iUmSipUserAudioPagingMemberService = iUmSipUserAudioPagingMemberService;
        this.iUmSipUserAudioPagingInitiatorsService = iUmSipUserAudioPagingInitiatorsService;
        this.iUmSipUserOutgoingCallRestrictionService = iUmSipUserOutgoingCallRestrictionService;
        this.contactsDao = contactsDao;
        this.jedisPool = jedisPool;
        this.commonDictService = commonDictService;
        this.gsPagingGroupInitiatorsService = gsPagingGroupInitiatorsService;
        this.gsPagingGroupMemberService = gsPagingGroupMemberService;
        this.gsPagingGroupService = gsPagingGroupService;
        this.acltableService = acltableService;
        this.tmCallSourceService = tmCallSourceService;
        this.clockTaskService = clockTaskService;
    }

    @ApiOperation(value="\u67e5\u8be2SIP\u7528\u6237\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") QuerySip querySip, @ApiParam(value="\u9875\u6761\u6570") Integer pageNum, @ApiParam(value="\u9875\u6570") Integer pageSize) {
        LOGGER.debug("SIP\u7528\u6237\u5217\u8868\u5206\u9875\u67e5\u8be2\uff0cpageNum=[{}], pageSize=[{}], querySip=[{}]", new Object[]{pageNum, pageSize, GSON.toJson((Object)querySip)});
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!ObjectUtils.isEmpty((Object)querySip.getStartNum())) {
            wrapper.nested(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.ge(SipUser::getNumber, (Object)querySip.getStartNum())).or()).ge(SipUser::getReplaceOldNumber, (Object)querySip.getStartNum());
            });
        }
        if (!ObjectUtils.isEmpty((Object)querySip.getEndNum())) {
            wrapper.nested(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.le(SipUser::getNumber, (Object)querySip.getEndNum())).or()).le(SipUser::getReplaceOldNumber, (Object)querySip.getEndNum());
            });
        }
        if (!ObjectUtils.isEmpty((Object)querySip.getCallSourceNo())) {
            wrapper.eq(SipUser::getCallSourceNo, (Object)querySip.getCallSourceNo());
        }
        if (!ObjectUtils.isEmpty((Object)querySip.getDeviceType())) {
            wrapper.eq(SipUser::getDeviceType, (Object)querySip.getDeviceType());
        }
        wrapper.eq(SipUser::getType, (Object)"SIP");
        if (querySip.getUserStatus() != null) {
            ArrayList<String> deviceIds = new ArrayList<String>();
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.select(1);
                String key = RedisKeyEnum.EXTENSION_STATE.getKey() + "*";
                Set keys = jedis.keys(key);
                if (CollectionUtils.isNotEmpty((Collection)keys)) {
                    for (String k : keys) {
                        String status = jedis.get(k);
                        if (!StringUtils.equals((CharSequence)status, (CharSequence)String.valueOf(querySip.getUserStatus()))) continue;
                        deviceIds.add(k.split("::")[1]);
                    }
                }
            }
            if (CollectionUtils.isEmpty(deviceIds)) {
                return this.getDataTable(new Page((long)pageNum.intValue(), (long)pageSize.intValue()));
            }
            wrapper.in(SipUser::getDeviceId, deviceIds);
        }
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        TableDataInfo result = this.getDataTable((Page)this.iSipUserService.page((IPage)page, (Wrapper)wrapper));
        result.getRows().forEach(item -> {
            Endpoints endpoints = (Endpoints)this.iEndpointsService.getById((Serializable)((Object)item.getDeviceId()));
            this.iSipUserService.setCallerName(endpoints, item);
        });
        this.getStatusFromRdb(result);
        return result;
    }

    private void getStatusFromRdb(TableDataInfo<SipUser> result) {
        if (result == null || result.getRows().size() == 0) {
            return;
        }
        List rows = result.getRows();
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            rows.forEach(sipUser -> {
                String key = RedisKeyEnum.EXTENSION_STATE.getKey() + sipUser.getDeviceId();
                String status = jedis.get(key);
                if (status != null) {
                    sipUser.setUserStatus(status);
                    PsContacts contacts = this.contactsDao.getByEndpoint(sipUser.getDeviceId());
                    if (contacts != null) {
                        sipUser.setIp(contacts.getViaAddr());
                        String userAgent = contacts.getUserAgent();
                        sipUser.setRegisteredTerminalType(com.uscale.common.utils.StringUtils.isBlank((CharSequence)userAgent) ? userAgent : userAgent.split(" ")[0]);
                    }
                }
            });
        }
    }

    @ApiOperation(value="\u547c\u53eb\u6e90\u4e0b\u62c9\u5b57\u5178")
    @GetMapping(value={"/init"})
    public AjaxResult<Map<String, Object>> init() {
        return AjaxResult.success((Object)this.iSipUserService.init());
    }

    @ApiOperation(value="\u83b7\u53d6SIP\u7528\u6237\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult<ModifySip> getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.iSipUserService.getSipUser(id));
    }

    @ApiOperation(value="\u65b0\u589eSIP\u7528\u6237")
    @RepeatSubmit
    @Log(title="SIP\u7528\u6237", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody CreateSip createSip) throws ConfFileException {
        LOGGER.debug("\u65b0\u589eSIP\u7528\u6237\uff0c\u83b7\u53d6\u5230\u53c2\u6570\uff1acreateSip=[{}]", (Object)GSON.toJson((Object)createSip));
        int count = this.iSipUserService.getUserCount();
        int userCount = createSip.getUserCount();
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            LicenseUtils licenseUtils = LicenseUtils.getInstance();
            License license = licenseUtils.getLicense(jedis, true);
            if (ObjectUtils.isEmpty((Object)license)) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SipUserController.max.user", (Object[])new Object[0]));
                return ajaxResult;
            }
            if (userCount + count > Integer.parseInt(license.getLsrUserNum())) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SipUserController.max.user", (Object[])new Object[0]));
                return ajaxResult;
            }
        }
        return this.iSipUserService.createSipUser(createSip);
    }

    @ApiOperation(value="\u4fee\u6539SIP\u7528\u6237")
    @RepeatSubmit
    @Log(title="SIP\u7528\u6237", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ModifySip modifySip) {
        if (!ObjectUtils.isEmpty((Object)modifySip.getSelfServiceLoginPassword())) {
            modifySip.setSelfServiceLoginPassword(SecurityUtils.encryptPassword((String)modifySip.getSelfServiceLoginPassword()));
        }
        return this.iSipUserService.update(modifySip);
    }

    @ApiOperation(value="\u5220\u9664SIP\u7528\u6237")
    @RepeatSubmit
    @Log(title="SIP\u7528\u6237", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable List<Long> ids) throws ConfFileException {
        return this.iSipUserService.delete(ids);
    }

    @ApiOperation(value="\u66f4\u65b0\u7b80\u5355\u4e1a\u52a1")
    @Log(title="SIP\u7528\u6237:\u7b80\u5355\u4e1a\u52a1", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/updateSimpleBusiness"})
    public AjaxResult updateSimpleBusiness(@RequestBody ModifySip modifySip) throws ConfFileException {
        return this.toAjax(this.iSipUserService.updateSimpleBusiness(modifySip));
    }

    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u7b80\u7b54\u4e1a\u52a1\u53ca\u547c\u51fa\u6743\u9650")
    @Log(title="SIP\u7528\u6237:\u7b80\u5355\u4e1a\u52a1\u53ca\u547c\u51fa\u6743\u9650", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/batchUpdateAuth"})
    public AjaxResult batchUpdateAuth(@RequestBody BatchAuthModify batchAuthModify) throws ConfFileException {
        return this.toAjax(this.iSipUserService.batchUpdateAuth(batchAuthModify));
    }

    @ApiOperation(value="\u641c\u7d22\u4ee3\u7b54\u7fa4\u7ec4")
    @GetMapping(value={"/searchCoGroupNumber/{groupId}"})
    public AjaxResult searchCoGroupNumber(@PathVariable Long groupId) {
        return AjaxResult.success((Object)this.iSipUserService.searchCoGroupNumber(groupId));
    }

    @ApiOperation(value="\u67e5\u8be2SIP\u540c\u7ec4\u4ee3\u7b54\u7ec4\u53f7")
    @GetMapping(value={"/getCoGroupNumber/{sipId}"})
    public AjaxResult getCoGroupNumber(@PathVariable Long sipId) {
        return AjaxResult.success((Object)this.iSipUserService.getCoGroupNumber(sipId));
    }

    @ApiOperation(value="\u4fee\u6539\u4ee3\u7b54\u7fa4\u7ec4\u53f7")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u540c\u7ec4\u4ee3\u7b54", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/updateCoGroupNumber"})
    public AjaxResult updateCoGroupNumber(@RequestBody ModifySip modifySip) {
        return this.toAjax(this.iSipUserService.updateCoGroupNumber(modifySip).intValue());
    }

    @ApiOperation(value="\u5173\u95ed\u540c\u7ec4\u4ee3\u7b54\u4e1a\u52a1")
    @RepeatSubmit
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u540c\u7ec4\u4ee3\u7b54", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/closeCoGroupNumber/{id}"})
    public AjaxResult closeCoGroupNumber(@PathVariable Long id) throws ConfFileException {
        return this.toAjax(this.iSipUserService.closeCoGroupNumber(id).intValue());
    }

    @ApiOperation(value="\u6821\u9a8c\u95f9\u949f\u6743\u9650\uff08\u662f\u5426\u5f00\u542f\u4e1a\u52a1\uff09")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u95f9\u949f", businessType=BusinessType.OTHER)
    @GetMapping(value={"/checkBusinessConflictOfClock/{sipId}"})
    public AjaxResult<?> initClock(@PathVariable Long sipId) {
        return this.toAjax(this.clockTaskService.checkBusinessConflictOfClock(sipId));
    }

    @ApiOperation(value="\u83b7\u53d6\u95f9\u949f\u914d\u7f6e\u4fe1\u606f")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u95f9\u949f", businessType=BusinessType.OTHER)
    @GetMapping(value={"/getClockDetails/{deviceId}"})
    public AjaxResult<?> getClockDetails(@PathVariable String deviceId) {
        return AjaxResult.success((Object)this.clockTaskService.getClockDetails(deviceId));
    }

    @ApiOperation(value="\u7f16\u8f91\u95f9\u949f\u914d\u7f6e")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u95f9\u949f", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/updateClock"})
    public AjaxResult<?> updateClock(@RequestBody ModifySip modifySip) {
        return this.toAjax(this.clockTaskService.updateClock(modifySip));
    }

    @ApiOperation(value="\u5173\u95ed\u95f9\u949f\uff08\u5220\u9664\u5df2\u914d\u7f6e\u6570\u636e\uff09")
    @RepeatSubmit
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u95f9\u949f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/closeClock/{id}"})
    public AjaxResult<?> closeClock(@PathVariable Long id) {
        return this.toAjax(this.clockTaskService.closeClock(id));
    }

    @ApiOperation(value="\u83b7\u53d6SIP\u632f\u94c3\u914d\u7f6e")
    @GetMapping(value={"/ringing/getConfig/{deviceId}"})
    public AjaxResult<UmSipUserRinging> getRingingConfig(@PathVariable String deviceId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(UmSipUserRinging::getDeviceId, (Object)deviceId)).last("limit 1");
        return AjaxResult.success((Object)this.iUmSipUserRingingService.getOne((Wrapper)wrapper));
    }

    @ApiOperation(value="SIP\u632f\u94c3\u7f16\u8f91")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u632f\u94c3", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/ringing/updateConfig"})
    public AjaxResult ringingUpdateConfig(@RequestBody UpdateSipUserRinging config) {
        if (ObjectUtils.isEmpty((Object)config)) {
            return this.toAjax(0);
        }
        LOGGER.debug("SIP\u632f\u94c3\u7f16\u8f91\uff0cconfig=[{}]", (Object)GSON.toJson((Object)config));
        if (ObjectUtils.isEmpty((Object)config.getSelfService()) || !config.getSelfService().booleanValue()) {
            SipUser sipUser = new SipUser();
            sipUser.setSimpleBusiness(config.getSimpleBusiness());
            sipUser.setId(config.getSipUserId());
            this.iSipUserService.updateById((Object)sipUser);
        }
        return this.toAjax(this.iUmSipUserRingingService.saveOrUpdate((Object)config));
    }

    @ApiOperation(value="SIP\u632f\u94c3\u5173\u95ed")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u632f\u94c3", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/ringing/close/{id}"})
    public AjaxResult ringingClose(@PathVariable Long id) {
        if (ObjectUtils.isEmpty((Object)id)) {
            return this.toAjax(0);
        }
        return this.toAjax(this.iUmSipUserRingingService.removeById((Serializable)id));
    }

    @ApiOperation(value="\u83b7\u53d6SIP\u51fa\u5c40\u547c\u53eb\u9650\u5236\u914d\u7f6e")
    @GetMapping(value={"/outgoingCallRestriction/getConfig/{deviceId}"})
    public AjaxResult<UmSipUserOutgoingCallRestriction> getOutgoingCallRestrictionConfig(@PathVariable String deviceId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(UmSipUserOutgoingCallRestriction::getDeviceId, (Object)deviceId)).last("limit 1");
        return AjaxResult.success((Object)this.iUmSipUserOutgoingCallRestrictionService.getOne((Wrapper)wrapper));
    }

    @ApiOperation(value="SIP\u51fa\u5c40\u547c\u53eb\u9650\u5236\u7f16\u8f91")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u51fa\u5c40\u547c\u53eb\u9650\u5236", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/outgoingCallRestriction/updateConfig"})
    public AjaxResult outgoingCallRestrictionUpdateConfig(@RequestBody UmSipUserOutgoingCallRestriction config) {
        if (ObjectUtils.isEmpty((Object)config)) {
            return this.toAjax(0);
        }
        LOGGER.debug("SIP\u51fa\u5c40\u547c\u53eb\u9650\u5236\u7f16\u8f91\uff0cconfig=[{}]", (Object)GSON.toJson((Object)config));
        return this.toAjax(this.iUmSipUserOutgoingCallRestrictionService.saveOrUpdate((Object)config));
    }

    @ApiOperation(value="\u67e5\u8be2SIP\u5bfb\u547c\u7ec4-\u7ec4\u5185\u6210\u5458\u5217\u8868")
    @GetMapping(value={"/audioPaging/member/list"})
    public TableDataInfo<GsPagingGroupMember> audioPagingMemberList(Integer pageNum, Integer pageSize, String memberNumber) {
        LOGGER.debug("\u67e5\u8be2SIP\u5bfb\u547c\u7ec4-\u7ec4\u5185\u6210\u5458\u5217\u8868\uff0cpageNum=[{}], pageSize=[{}]", (Object)pageNum, (Object)pageSize);
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(GsPagingGroupMember::getMemberNumber, (Object)memberNumber);
        return this.getDataTable((Page)this.gsPagingGroupMemberService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u5bfb\u547c\u7ec4-\u7ec4\u5185\u6210\u5458\u7f16\u8f91")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u5bfb\u547c\u5e7f\u64ad", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/audioPaging/member/edit"})
    public AjaxResult audioPagingMemberEdit(@RequestBody GsPagingGroupMember member) {
        if (ObjectUtils.isEmpty((Object)member)) {
            return this.toAjax(0);
        }
        Integer groupId = member.getGroupId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(GsPagingGroup::getGroupId, (Object)groupId);
        if (this.gsPagingGroupService.getOne((Wrapper)wrapper) == null) {
            throw new RuntimeException("\u5bfb\u547c\u7ec4\u3010" + groupId + "\u3011\u4e0d\u5b58\u5728");
        }
        LOGGER.debug("SIP\u5bfb\u547c\u7ec4-\u7ec4\u5185\u6210\u5458\u7f16\u8f91\uff0cmember=[{}]", (Object)GSON.toJson((Object)member));
        return this.toAjax(this.gsPagingGroupMemberService.saveOrUpdate((Object)member));
    }

    @ApiOperation(value="\u5bfb\u547c\u7ec4-\u7ec4\u5185\u6210\u5458\u5220\u9664")
    @Log(title="\u5bfb\u547c\u7ec4", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/audioPaging/member/delete/{ids}"})
    public AjaxResult audioPagingMemberDelete(@PathVariable Long[] ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return this.toAjax(0);
        }
        LOGGER.debug("SIP\u5bfb\u547c\u7ec4-\u7ec4\u5185\u6210\u5458\u5220\u9664\uff0cids=[{}]", (Object)GSON.toJson((Object)ids));
        return this.toAjax(this.gsPagingGroupMemberService.removeByIds(Arrays.asList((Object[])ids.clone())));
    }

    @ApiOperation(value="\u5bfb\u547c\u7ec4-\u53d1\u8d77\u65b9\u6210\u5458\u5217\u8868")
    @GetMapping(value={"/audioPaging/initiators/list"})
    public TableDataInfo<GsPagingGroupInitiators> audioPagingInitiatorsList(Integer pageNum, Integer pageSize, String memberNumber) {
        LOGGER.debug("\u67e5\u8be2SIP\u5bfb\u547c\u7ec4-\u53d1\u8d77\u65b9\u6210\u5458\u5217\u8868\uff0cpageNum=[{}], pageSize=[{}]", (Object)pageNum, (Object)pageSize);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(GsPagingGroupInitiators::getMemberNumber, (Object)memberNumber);
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.gsPagingGroupInitiatorsService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="SIP\u5bfb\u547c\u7ec4-\u53d1\u8d77\u65b9\u6210\u5458\u7f16\u8f91")
    @Log(title="\u5bfb\u547c\u7ec4", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/audioPaging/initiators/edit"})
    public AjaxResult audioPagingInitiatorsEdit(@RequestBody GsPagingGroupInitiators initiators) {
        if (ObjectUtils.isEmpty((Object)initiators)) {
            return this.toAjax(0);
        }
        Integer groupId = initiators.getGroupId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(GsPagingGroup::getGroupId, (Object)groupId);
        GsPagingGroup pagingGroup = (GsPagingGroup)this.gsPagingGroupService.getOne((Wrapper)wrapper);
        if (pagingGroup == null) {
            throw new RuntimeException("\u5bfb\u547c\u7ec4\u3010" + groupId + "\u3011\u4e0d\u5b58\u5728");
        }
        if (pagingGroup.getIntraOfficeInitiators() != GsPagingGroupIntraOfficeInitiatorsEnum.INTRA_OFFICE_INITIATORS_SPECIFIED_USERS) {
            throw new RuntimeException("\u5bfb\u547c\u7ec4\u3010" + groupId + "\u3011\u5c40\u5185\u53d1\u8d77\u7c7b\u578b\u65b9\u975e\u6307\u5b9a\u7528\u6237");
        }
        LOGGER.debug("SIP\u5bfb\u547c\u7ec4-\u53d1\u8d77\u65b9\u6210\u5458\u7f16\u8f91\uff0cinitiators=[{}]", (Object)GSON.toJson((Object)initiators));
        return this.toAjax(this.gsPagingGroupInitiatorsService.saveOrUpdate((Object)initiators));
    }

    @ApiOperation(value="SIP\u5bfb\u547c\u7ec4-\u53d1\u8d77\u65b9\u6210\u5458\u5220\u9664")
    @Log(title="\u5bfb\u547c\u7ec4", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/audioPaging/initiators/delete/{ids}"})
    public AjaxResult audioPagingInitiatorsDelete(@PathVariable Long[] ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return this.toAjax(0);
        }
        LOGGER.debug("SIP\u5bfb\u547c\u7ec4-\u53d1\u8d77\u65b9\u6210\u5458\u5220\u9664\uff0cids=[{}]", (Object)GSON.toJson((Object)ids));
        return this.toAjax(this.gsPagingGroupInitiatorsService.removeByIds(Arrays.asList((Object[])ids.clone())));
    }

    @ApiOperation(value="\u67e5\u8be2SIP\u5bfb\u7ebf\u7ec4\u5217\u8868")
    @GetMapping(value={"/huntGroup/list"})
    public TableDataInfo<GsHuntGroupMember> huntGroupList(Integer pageNum, Integer pageSize, String memberDeviceId) {
        LOGGER.debug("\u67e5\u8be2SIP\u5bfb\u7ebf\u7ec4\u5217\u8868\uff0cpageNum=[{}], pageSize=[{}]", (Object)pageNum, (Object)pageSize);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"member_device_id", (Object)memberDeviceId);
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.gsHuntGroupMemberService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="SIP\u5bfb\u7ebf\u7ec4\u7f16\u8f91")
    @Log(title="\u5bfb\u7ebf\u7ec4", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/huntGroup/edit"})
    public AjaxResult huntGroupEdit(@RequestBody GsHuntGroupMember group) {
        if (ObjectUtils.isEmpty((Object)group)) {
            return this.toAjax(0);
        }
        LOGGER.debug("SIP\u5bfb\u7ebf\u7ec4\u7f16\u8f91\uff0cgroup=[{}]", (Object)GSON.toJson((Object)group));
        return this.toAjax(this.gsHuntGroupMemberService.saveOrUpdate((Object)group));
    }

    @ApiOperation(value="SIP\u5bfb\u7ebf\u7ec4\u5220\u9664")
    @Log(title="\u5bfb\u7ebf\u7ec4", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/huntGroup/delete/{ids}"})
    public AjaxResult huntGroupDelete(@PathVariable Long[] ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return this.toAjax(0);
        }
        LOGGER.debug("SIP\u5bfb\u7ebf\u7ec4\u5220\u9664\uff0cids=[{}]", (Object)GSON.toJson((Object)ids));
        return this.toAjax(this.gsHuntGroupMemberService.removeByIds(Arrays.asList((Object[])ids.clone())));
    }

    @ApiOperation(value="\u67e5\u8be2SIP\u7ecf\u7406\u79d8\u4e66\u5217\u8868")
    @GetMapping(value={"/secretary/list"})
    public AjaxResult secretaryList(String deviceId, Long sipId) {
        LOGGER.debug("\u67e5\u8be2SIP\u7ecf\u7406\u79d8\u4e66\u5217\u8868\uff0csipNumber=[{}]", (Object)deviceId);
        List list = this.umSipUserSecretaryService.getSecretariesByDeviceId(deviceId);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.select(new SFunction[]{SipUser::getMuteCall, SipUser::getAutomaticAnswer, SipUser::getShareLineMode, SipUser::getPrivateLineNumber, SipUser::getPeerPrivateLineNumber}).eq(SipUser::getId, (Object)sipId)).last("limit 1");
        SipUser sipUser = (SipUser)this.iSipUserService.getOne((Wrapper)queryWrapper);
        HashMap res = new HashMap(16);
        res.put("tableData", list);
        res.put("formData", sipUser);
        return AjaxResult.success(res);
    }

    @ApiOperation(value="SIP\u7ecf\u7406\u79d8\u4e66\u7f16\u8f91")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u7ecf\u7406\u79d8\u4e66", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/secretary/edit"})
    public AjaxResult secretaryEdit(@RequestBody Map<String, Object> params) {
        if (ObjectUtils.isEmpty(params)) {
            return this.toAjax(false);
        }
        LOGGER.debug("SIP\u7ecf\u7406\u79d8\u4e66\u7f16\u8f91\uff0cparams=[{}]", (Object)GSON.toJson(params));
        return this.iSipUserService.secretaryEdit(params);
    }

    @ApiOperation(value="SIP\u7ecf\u7406\u79d8\u4e66\u5220\u9664")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u7ecf\u7406\u79d8\u4e66", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/secretary/delete/{deviceId}/{ids}"})
    public AjaxResult secretaryDelete(@PathVariable String deviceId, @PathVariable Long[] ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return this.toAjax(0);
        }
        LOGGER.debug("SIP\u7ecf\u7406\u79d8\u4e66\u5220\u9664\uff0cids=[{}]", (Object)GSON.toJson((Object)ids));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UmSipUserSecretary::getDeviceId, (Object)deviceId);
        int cnt = this.umSipUserSecretaryService.count((Wrapper)wrapper);
        if (cnt == ids.length) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(SipUser::getMuteCall, null)).set(SipUser::getAutomaticAnswer, null)).set(SipUser::getShareLineMode, null)).set(SipUser::getPrivateLineNumber, null)).set(SipUser::getPeerPrivateLineNumber, null)).eq(SipUser::getDeviceId, (Object)deviceId);
            this.iSipUserService.update((Object)new SipUser(), (Wrapper)updateWrapper);
            SipUser sipUser = this.iSipUserService.getSipUserByDeviceId(deviceId);
            UserBusinessUtils.delComplexBusiness((String)SipUserBusinessEnum.COMPLEX_SECRETARY.getCode(), (SipUser)sipUser);
            UpdateWrapper sipUserWrapper = new UpdateWrapper();
            ((UpdateWrapper)sipUserWrapper.set((Object)"complex_business", (Object)sipUser.getComplexBusiness())).eq((Object)"id", (Object)sipUser.getId());
            this.iSipUserService.update((Wrapper)sipUserWrapper);
        }
        return this.toAjax(this.umSipUserSecretaryService.removeByIds(Arrays.asList((Object[])ids.clone())));
    }

    @ApiOperation(value="\u66f4\u65b0\u547c\u51fa\u6743\u9650")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u547c\u51fa\u6743\u9650", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/updateCallOutAuth"})
    public AjaxResult updateCallOutAuth(@RequestBody ModifySip modifySip) {
        return this.toAjax(this.iSipUserService.updateCallOutAuth(modifySip.getId(), modifySip.getCallOutAuth()));
    }

    @ApiOperation(value="\u66f4\u65b0\u524d\u8f6c\u547c\u51fa\u6743\u9650")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u524d\u8f6c\u547c\u51fa\u6743\u9650", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/updateForwardCallOutAuth"})
    public AjaxResult updateForwardCallOutAuth(@RequestBody ModifySip modifySip) {
        return this.toAjax(this.iSipUserService.updateForwardCallOutAuth(modifySip.getId(), modifySip.getForwardCallOutAuth()));
    }

    @ApiOperation(value="\u66f4\u65b0\u88ab\u53eb\u4ed8\u8d39\u6743\u9650")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u88ab\u53eb\u4ed8\u8d39\u6743\u9650", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/updateCollectCallRight"})
    public AjaxResult updateCollectCallRight(@RequestBody ModifySip modifySip) {
        return this.toAjax(this.iSipUserService.updateCollectCallRight(modifySip.getId(), modifySip.getCollectCallRight()));
    }

    @ApiOperation(value="\u8bed\u97f3\u4fe1\u7bb1\u5b57\u5178")
    @GetMapping(value={"/getVoiceMailDict"})
    public AjaxResult getVoiceMailDict() {
        HashMap<String, List> data = new HashMap<String, List>(16);
        List voiceMailDict = this.commonDictService.getVoiceMailDict();
        data.put("voiceMailDict", voiceMailDict);
        return AjaxResult.success(data);
    }

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801\uff1a\u6839\u636e\u7528\u6237ID\u548c\u65e7\u5bc6\u7801\u5339\u914d")
    @Log(title="\u81ea\u52a9\u670d\u52a1:\u7528\u6237\u5bc6\u7801\u4fee\u6539", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/resetSipPwd"})
    public AjaxResult resetSipPwd(@RequestBody Map<String, String> requestData) {
        Long userId = SecurityUtils.getLoginUser().getUser().getUserId();
        String oldPassword = requestData.get("oldPassword");
        String newPassword = requestData.get("newPassword");
        if (StringUtils.isBlank((CharSequence)oldPassword) || StringUtils.isBlank((CharSequence)newPassword)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserController.input.password", (Object[])new Object[0]));
        }
        SipUser sip = (SipUser)this.iSipUserService.getById((Serializable)userId);
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)sip)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserController.user.no", (Object[])new Object[0]));
        }
        if (!SecurityUtils.matchesPassword((String)oldPassword, (String)sip.getSelfServiceLoginPassword())) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserController.password.error", (Object[])new Object[0]));
        }
        SipUser user = new SipUser();
        user.setId(userId);
        user.setSelfServiceLoginPassword(SecurityUtils.encryptPassword((String)newPassword));
        return this.toAjax(this.iSipUserService.updatePwd(user));
    }

    @ApiOperation(value="\u5bfc\u5165\u7528\u6237\u914d\u7f6e")
    @PostMapping(value={"/importExcel"})
    public AjaxResult<ImportResultVO> importExcel(@ApiParam(value="\u6587\u4ef6") @RequestParam(value="file") MultipartFile file) throws Exception {
        License license;
        String fileName = file.getOriginalFilename();
        if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)fileName) || !com.uscale.common.utils.StringUtils.endsWith((CharSequence)fileName, (CharSequence)".xlsx") && !com.uscale.common.utils.StringUtils.endsWith((CharSequence)fileName, (CharSequence)".xls")) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserController.file.error", (Object[])new Object[0]));
        }
        List sips = EasyExcel.read((InputStream)file.getInputStream(), SipVo.class, (ReadListener)new /* Unavailable Anonymous Inner Class!! */).sheet().doReadSync();
        if (CollectionUtils.isEmpty((Collection)sips)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserController.nodata", (Object[])new Object[0]));
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            LicenseUtils licenseUtils = LicenseUtils.getInstance();
            license = licenseUtils.getLicense(jedis, true);
        }
        if (ObjectUtils.isEmpty((Object)license)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserController.max.user", (Object[])new Object[0]));
        }
        int count = this.iSipUserService.getUserCount();
        int size = sips.size();
        if (size + count > Integer.parseInt(license.getLsrUserNum())) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserController.max.user", (Object[])new Object[0]));
        }
        ImportResultVO importResultVO = this.iSipUserService.importExcelSipNew(sips);
        return AjaxResult.success((Object)importResultVO);
    }

    private void checkSipVo(List<SipVo> sips) {
        HashSet<String> shortNumbers = new HashSet<String>();
        HashSet<String> LongNumbers = new HashSet<String>();
        HashSet<String> deviceIds = new HashSet<String>();
        for (SipVo sip : sips) {
            if (SipUserController.checkNumber((String)sip.getNumber(), (int)1, (int)16)) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip1", (Object[])new Object[0]));
            }
            if (CollectionUtils.isNotEmpty(shortNumbers) && shortNumbers.contains(sip.getNumber())) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip2", (Object[])new Object[0]));
            }
            if (SipUserController.checkNumber((String)sip.getLongNumber(), (int)0, (int)31)) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip3", (Object[])new Object[0]));
            }
            if (CollectionUtils.isNotEmpty(LongNumbers) && com.uscale.common.utils.StringUtils.isNotEmpty((String)sip.getLongNumber()) && LongNumbers.contains(sip.getLongNumber())) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip4", (Object[])new Object[0]));
            }
            if (SipUserController.checkNumber((String)sip.getDeviceId(), (int)1, (int)31)) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip5", (Object[])new Object[0]));
            }
            if (CollectionUtils.isNotEmpty(deviceIds) && deviceIds.contains(sip.getDeviceId())) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip6", (Object[])new Object[0]));
            }
            if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)sip.getDeviceType()) || !com.uscale.common.utils.StringUtils.equalsAny((CharSequence)sip.getDeviceType(), (CharSequence[])new CharSequence[]{"0", "1"})) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip7", (Object[])new Object[0]));
            }
            if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)sip.getAuthenticationMode()) || !com.uscale.common.utils.StringUtils.equalsAny((CharSequence)sip.getAuthenticationMode(), (CharSequence[])new CharSequence[]{"ip", "userpass", "ip_password", "ip_pool"})) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip8", (Object[])new Object[0]));
            }
            if (com.uscale.common.utils.StringUtils.equals((CharSequence)sip.getAuthenticationMode(), (CharSequence)"ip") || com.uscale.common.utils.StringUtils.equals((CharSequence)sip.getAuthenticationMode(), (CharSequence)"ip_password")) {
                if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)sip.getIp())) {
                    throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip9", (Object[])new Object[0]));
                }
                if (!IpTool.ipCheck((String)sip.getIp())) {
                    throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip10", (Object[])new Object[0]));
                }
            }
            if ((com.uscale.common.utils.StringUtils.equals((CharSequence)sip.getAuthenticationMode(), (CharSequence)"userpass") || com.uscale.common.utils.StringUtils.equals((CharSequence)sip.getAuthenticationMode(), (CharSequence)"ip_password")) && com.uscale.common.utils.StringUtils.isBlank((CharSequence)sip.getPassword())) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip11", (Object[])new Object[0]));
            }
            if (com.uscale.common.utils.StringUtils.equals((CharSequence)sip.getAuthenticationMode(), (CharSequence)"ip_pool")) {
                if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)sip.getAddressPoolType()) || !com.uscale.common.utils.StringUtils.equalsAny((CharSequence)sip.getAddressPoolType(), (CharSequence[])new CharSequence[]{"all", "single"})) {
                    throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip12", (Object[])new Object[0]));
                }
                if (com.uscale.common.utils.StringUtils.equals((CharSequence)sip.getAddressPoolType(), (CharSequence)"single") && com.uscale.common.utils.StringUtils.isBlank((CharSequence)sip.getAddressPoolIndex())) {
                    throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip13", (Object[])new Object[0]));
                }
            }
            if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)sip.getUserRightLevel()) || !com.uscale.common.utils.StringUtils.equalsAny((CharSequence)sip.getUserRightLevel(), (CharSequence[])new CharSequence[]{"0", "1", "2", "3"})) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip14", (Object[])new Object[0]));
            }
            if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)sip.getServicePassword()) || sip.getServicePassword().length() != 6 || !com.uscale.common.utils.StringUtils.isNumeric((CharSequence)sip.getServicePassword())) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip15", (Object[])new Object[0]));
            }
            if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)sip.getSelfServiceLoginPassword())) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip16", (Object[])new Object[0]));
            }
            if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)sip.getCallSourceNo())) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip17", (Object[])new Object[0]));
            }
            if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)sip.getDistinctiveRingingTone()) || !com.uscale.common.utils.StringUtils.equalsAny((CharSequence)sip.getDistinctiveRingingTone(), (CharSequence[])new CharSequence[]{"0", "1"})) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip18", (Object[])new Object[0]));
            }
            if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)sip.getMediaStreamEncryption()) || !com.uscale.common.utils.StringUtils.equalsAny((CharSequence)sip.getMediaStreamEncryption(), (CharSequence[])new CharSequence[]{"MEDIA_STREAM_ENCRYPTION_OFF", "MEDIA_STREAM_ENCRYPTION_OPTIONAL", "MEDIA_STREAM_ENCRYPTION_FORCE"})) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip19", (Object[])new Object[0]));
            }
            if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)sip.getTransport()) || !com.uscale.common.utils.StringUtils.equalsAny((CharSequence)sip.getTransport(), (CharSequence[])new CharSequence[]{"transport-udp", "transport-tcp", "transport-tls"})) {
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip20", (Object[])new Object[0]));
            }
            shortNumbers.add(sip.getNumber());
            if (com.uscale.common.utils.StringUtils.isNotEmpty((String)sip.getLongNumber())) {
                LongNumbers.add(sip.getLongNumber());
            }
            deviceIds.add(sip.getDeviceId());
        }
        for (SipVo short_number : sips) {
            for (SipVo long_number : sips) {
                if (!com.uscale.common.utils.StringUtils.isNotEmpty((String)long_number.getLongNumber()) || com.uscale.common.utils.StringUtils.equals((CharSequence)short_number.getNumber(), (CharSequence)long_number.getNumber()) || !com.uscale.common.utils.StringUtils.equals((CharSequence)short_number.getNumber(), (CharSequence)long_number.getLongNumber())) continue;
                throw this.throwException(short_number.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip21", (Object[])new Object[]{short_number.getNumber(), long_number.getLongNumber()}));
            }
        }
    }

    public void checkIpIndex(List<SipVo> sips) {
        List ip_pools;
        if (CollectionUtils.isNotEmpty(sips) && CollectionUtils.isNotEmpty(ip_pools = sips.stream().filter(item -> com.uscale.common.utils.StringUtils.equals((CharSequence)item.getAuthenticationMode(), (CharSequence)"ip_pool") && com.uscale.common.utils.StringUtils.equals((CharSequence)item.getAddressPoolType(), (CharSequence)"single")).collect(Collectors.toList()))) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(Acltable::getSense, (Object)"permit");
            wrapper.ne(Acltable::getName, (Object)"all");
            List acltables = this.acltableService.list((Wrapper)wrapper);
            if (CollectionUtils.isEmpty((Collection)acltables)) {
                throw this.throwException("***", MessageUtils.message((String)"SipUserController.checkSipVo.tip22", (Object[])new Object[0]));
            }
            HashSet<String> ipindexs = new HashSet<String>();
            for (Acltable acltable : acltables) {
                ipindexs.add(acltable.getName());
            }
            for (SipVo sip : ip_pools) {
                if (ipindexs.contains(sip.getAddressPoolIndex())) continue;
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip23", (Object[])new Object[]{sip.getAddressPoolIndex()}));
            }
        }
    }

    public void checkCallSourceNo(List<SipVo> sips) {
        if (CollectionUtils.isNotEmpty(sips)) {
            List nos = this.tmCallSourceService.list();
            if (CollectionUtils.isEmpty((Collection)nos)) {
                throw this.throwException("***", MessageUtils.message((String)"SipUserController.checkSipVo.tip24", (Object[])new Object[0]));
            }
            HashSet<String> sourceNos = new HashSet<String>();
            for (TmCallSource s : nos) {
                sourceNos.add(s.getCallSourceNo());
            }
            for (SipVo sip : sips) {
                if (sourceNos.contains(sip.getCallSourceNo())) continue;
                throw this.throwException(sip.getLine(), MessageUtils.message((String)"SipUserController.checkSipVo.tip25", (Object[])new Object[]{sip.getCallSourceNo()}));
            }
        }
    }

    public CustomException throwException(Integer row, String message) {
        return new CustomException(MessageUtils.message((String)"SipUserController.checkSipVo.tip26", (Object[])new Object[]{row}) + message);
    }

    public CustomException throwException(String row, String message) {
        return new CustomException(MessageUtils.message((String)"SipUserController.checkSipVo.tip26", (Object[])new Object[]{row}) + message);
    }

    public static boolean checkNumber(String value, int minLength, int maxLength) {
        if (minLength > 0) {
            if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)value) || com.uscale.common.utils.StringUtils.length((CharSequence)value) < minLength) {
                return true;
            }
        } else if (com.uscale.common.utils.StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        if (maxLength > 0 && com.uscale.common.utils.StringUtils.length((CharSequence)value) > maxLength) {
            return true;
        }
        return !com.uscale.common.utils.StringUtils.isNumeric((CharSequence)value);
    }

    @ApiOperation(value="\u5bfc\u51fa\u6a21\u677f")
    @GetMapping(value={"/exportSipMode"})
    public void exportSipMode(HttpServletResponse response) throws IOException {
        String language = MessageUtils.getLocal().getLanguage();
        String tplFileName = System.currentTimeMillis() + "sipData_mode_" + language + ".xlsx";
        String tplSheet = "sipData_mode";
        ArrayList sips = new ArrayList();
        ExcelUtils.writeExcel2Stream((HttpServletResponse)response, SipVo.class, sips, (String)tplFileName, (String)tplSheet);
    }

    @ApiOperation(value="\u5bfc\u51fasip\u6570\u636e")
    @GetMapping(value={"/exportSipData"})
    public void exportSipData(HttpServletResponse response) throws IOException {
        List sips = this.iSipUserService.getSipData();
        if (CollectionUtils.isEmpty((Collection)sips)) {
            throw new CustomException(MessageUtils.message((String)"SipUserController.nodata.export", (Object[])new Object[0]));
        }
        String language = MessageUtils.getLocal().getLanguage();
        String dateStr = DateUtils.parseDateToStr((String)"yyyy-MM-dd", (Date)new Date());
        String tplFileName = System.currentTimeMillis() + "sipData_" + language + "_" + dateStr + ".xlsx";
        String tplSheet = "sipData_" + dateStr;
        ExcelUtils.writeExcel2Stream((HttpServletResponse)response, SipVo.class, (List)sips, (String)tplFileName, (String)tplSheet);
    }

    @ApiOperation(value="\u6e05\u7a7aSIP\u7528\u6237")
    @Log(title="SIP\u7528\u6237", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/clearSip"})
    public AjaxResult clearSip() throws ConfFileException {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SipUser::getType, (Object)"SIP");
        List sips = this.iSipUserService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)sips)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserController.nodata.delete", (Object[])new Object[0]));
        }
        List ids = sips.stream().map(SipUser::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserController.nodata.delete", (Object[])new Object[0]));
        }
        return this.iSipUserService.delete(ids);
    }

    @ApiOperation(value="\u51fa\u5c40\u9047\u5fd9\u56de\u53eb\u914d\u7f6e")
    @Log(title="\u9047\u5fd9\u56de\u53eb\u914d\u7f6e", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit/outgoingBusyCallback"})
    public AjaxResult editOutgoingBusyCallback(@RequestBody UmOutgoingBusyCallback outgoingBusyCallback) {
        return this.toAjax(this.iSipUserService.editOutgoingBusyCallback(outgoingBusyCallback));
    }

    @ApiOperation(value="\u83b7\u53d6\u51fa\u5c40\u9047\u5fd9\u56de\u53eb\u914d\u7f6e")
    @GetMapping(value={"/get/outgoingBusyCallback/{number}"})
    public AjaxResult getOutgoingBusyCallback(@PathVariable String number) {
        return AjaxResult.success((Object)this.iSipUserService.getOutgoingBusyCallback(number));
    }
}

