/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.userMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.annotation.RepeatSubmit;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.SipUserBusinessEnum;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.SipUser;
import com.uscale.system.handler.SipUserBusinessConflictResponsibilityChain;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.tool.UserBusinessUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79fb\u673a\u6539\u53f7"})
@RestController
@RequestMapping(value={"/userMng/sip"})
public class SipUserChangeNumberController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SipUserChangeNumberController.class);
    private static final Gson GSON = new Gson();
    private static final Pattern PATTERN = Pattern.compile("^\\d{1,16}$");
    private final ISipUserService iSipUserService;
    private final SipUserBusinessConflictResponsibilityChain sipUserBusinessConflictResponsibilityChain;

    @Autowired
    public SipUserChangeNumberController(ISipUserService iSipUserService, SipUserBusinessConflictResponsibilityChain sipUserBusinessConflictResponsibilityChain) {
        this.iSipUserService = iSipUserService;
        this.sipUserBusinessConflictResponsibilityChain = sipUserBusinessConflictResponsibilityChain;
    }

    @ApiOperation(value="\u67e5\u8be2SIP\u7528\u6237\u5217\u8868")
    @GetMapping(value={"/getChangeNumberConfig/{sipUserId}"})
    public AjaxResult<SipUser> getChangeNumberConfig(@PathVariable(value="sipUserId") Long sipUserId) {
        if (ObjectUtils.isEmpty((Object)sipUserId)) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237\u79fb\u673a\u6539\u53f7\u914d\u7f6e\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5931\u8d25");
            return AjaxResult.error();
        }
        SipUser sipUser = (SipUser)this.iSipUserService.getById((Serializable)sipUserId);
        if (ObjectUtils.isEmpty((Object)sipUser)) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237\u79fb\u673a\u6539\u53f7\u914d\u7f6e\uff0c\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u5931\u8d25\uff1asipUserId=[{}]", (Object)sipUserId);
            return AjaxResult.error();
        }
        return AjaxResult.success((Object)sipUser);
    }

    @ApiOperation(value="\u4fee\u6539SIP\u7528\u6237")
    @RepeatSubmit
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u79fb\u673a\u6539\u53f7", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/saveOrUpdateChangeNumberConfig"})
    public AjaxResult saveOrUpdateChangeNumberConfig(@RequestBody SipUser sipUser) {
        if (ObjectUtils.isEmpty((Object)sipUser) || ObjectUtils.isEmpty((Object)sipUser.getId())) {
            LOGGER.error("\u4fdd\u5b58\u7528\u6237\u79fb\u673a\u6539\u53f7\u914d\u7f6e\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5931\u8d25\uff1asipUser=[{}]", (Object)GSON.toJson((Object)sipUser));
            return AjaxResult.error();
        }
        SipUser origin = (SipUser)this.iSipUserService.getById((Serializable)sipUser.getId());
        if (ObjectUtils.isEmpty((Object)origin)) {
            LOGGER.error("\u4fdd\u5b58\u7528\u6237\u79fb\u673a\u6539\u53f7\u914d\u7f6e\uff0c\u6839\u636eID\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u5931\u8d25\uff1asipUser=[{}]", (Object)GSON.toJson((Object)sipUser));
            return AjaxResult.error();
        }
        UserBusinessUtils.addComplexBusiness((String)SipUserBusinessEnum.COMPLEX_CHANGE_NUMBER.getCode(), (SipUser)sipUser);
        if (!this.sipUserBusinessConflictResponsibilityChain.handle(sipUser)) {
            LOGGER.error("\u4fdd\u5b58\u7528\u6237\u79fb\u673a\u6539\u53f7\u914d\u7f6e\uff0c\u7528\u6237\u4e1a\u52a1\u51b2\u7a81\uff0c\u5931\u8d25\uff1asipUser=[{}]", (Object)GSON.toJson((Object)sipUser));
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserChangeNumberController.user.business.conflict.tip1", (Object[])new Object[0]));
        }
        String changeNumber = sipUser.getChangeNumberNewNumber();
        if (!PATTERN.matcher(changeNumber).matches()) {
            LOGGER.error("\u4fdd\u5b58\u7528\u6237\u79fb\u673a\u6539\u53f7\u914d\u7f6e\uff0c\u53f7\u7801\u4e0d\u662f\u6570\u5b57\uff0c\u5931\u8d25\uff1asipUser=[{}]", (Object)GSON.toJson((Object)sipUser));
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserChangeNumberController.user.business.conflict.tip2", (Object[])new Object[0]));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"number", (Object)Long.parseLong(changeNumber));
        int cnt = this.iSipUserService.count((Wrapper)queryWrapper);
        if (cnt == 0) {
            LOGGER.error("\u4fdd\u5b58\u7528\u6237\u79fb\u673a\u6539\u53f7\u914d\u7f6e\uff0c\u79fb\u673a\u6539\u53f7\u540e\u7684\u53f7\u7801\u4e0d\u5b58\u5728\uff0c\u5931\u8d25\uff1asipUser=[{}]", (Object)GSON.toJson((Object)sipUser));
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserChangeNumberController.number.tip1", (Object[])new Object[0]));
        }
        sipUser.setComplexBusiness(origin.getComplexBusiness());
        UserBusinessUtils.addComplexBusiness((String)SipUserBusinessEnum.COMPLEX_CHANGE_NUMBER.getCode(), (SipUser)sipUser);
        UpdateWrapper wrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)wrapper.set((Object)"change_number_new_number", (Object)sipUser.getChangeNumberNewNumber())).set((Object)"change_number_auto_call", (Object)sipUser.getChangeNumberAutoCall())).set((Object)"complex_business", (Object)sipUser.getComplexBusiness())).eq((Object)"id", (Object)sipUser.getId());
        return this.toAjax(this.iSipUserService.update((Wrapper)wrapper));
    }

    @ApiOperation(value="\u5220\u9664SIP\u7528\u6237")
    @RepeatSubmit
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u79fb\u673a\u6539\u53f7", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/closeChangeNumberConfig/{sipUserId}"})
    public AjaxResult closeChangeNumberConfig(@PathVariable Long sipUserId) {
        if (ObjectUtils.isEmpty((Object)sipUserId)) {
            LOGGER.error("\u5173\u95ed\u7528\u6237\u79fb\u673a\u6539\u53f7\u4e1a\u52a1\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5931\u8d25");
            return AjaxResult.error();
        }
        SipUser origin = (SipUser)this.iSipUserService.getById((Serializable)sipUserId);
        if (ObjectUtils.isEmpty((Object)origin)) {
            LOGGER.error("\u5173\u95ed\u7528\u6237\u79fb\u673a\u6539\u53f7\u4e1a\u52a1\uff0c\u6839\u636eID\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u5931\u8d25\uff1asipUserId=[{}]", (Object)sipUserId);
            return AjaxResult.error();
        }
        UserBusinessUtils.delComplexBusiness((String)SipUserBusinessEnum.COMPLEX_CHANGE_NUMBER.getCode(), (SipUser)origin);
        UpdateWrapper wrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)wrapper.set((Object)"change_number_new_number", null)).set((Object)"change_number_auto_call", null)).set((Object)"complex_business", (Object)origin.getComplexBusiness())).eq((Object)"id", (Object)origin.getId());
        return this.toAjax(this.iSipUserService.update((Wrapper)wrapper));
    }
}

