/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.userMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.SipUserBusinessEnum;
import com.uscale.system.entity.SipUser;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.tool.UserBusinessUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u547c\u51fa\u9650\u5236"})
@RestController
@RequestMapping(value={"/userMng/sip"})
public class SipUserCallOutRestrictionController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SipUserCallOutRestrictionController.class);
    private static final Gson GSON = new Gson();
    private final ISipUserService iSipUserService;
    private static final String RESTRICT_SWITCH = "restrictSwitch";

    @Autowired
    public SipUserCallOutRestrictionController(ISipUserService iSipUserService) {
        this.iSipUserService = iSipUserService;
    }

    @ApiOperation(value="\u67e5\u8be2\u547c\u51fa\u9650\u5236\u7c7b\u578b")
    @GetMapping(value={"/getCallRestrictionType/{sipUserId}"})
    public AjaxResult<SipUser> getCallRestrictionType(@PathVariable(value="sipUserId") Long sipUserId) {
        if (ObjectUtils.isEmpty((Object)sipUserId)) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237\u547c\u51fa\u9650\u5236\u914d\u7f6e\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5931\u8d25");
            return AjaxResult.error();
        }
        SipUser sipUser = (SipUser)this.iSipUserService.getById((Serializable)sipUserId);
        if (ObjectUtils.isEmpty((Object)sipUser)) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237\u547c\u51fa\u9650\u5236\u914d\u7f6e\uff0c\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u5931\u8d25\uff1asipUserId=[{}]", (Object)sipUserId);
            return AjaxResult.error();
        }
        return AjaxResult.success((Object)sipUser);
    }

    @ApiOperation(value="\u4fee\u6539\u547c\u51fa\u9650\u5236")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u547c\u51fa\u9650\u5236", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/saveOrUpdateCallRestrictionType/{sipUserId}"})
    public AjaxResult saveOrUpdateCallRestrictionType(@RequestBody Map<String, Object> map, @PathVariable Long sipUserId) {
        LOGGER.debug("\u4fee\u6539\u547c\u51fa\u9650\u5236\uff0c\u53c2\u6570\uff1asipUserId=[{}], map=[{}]", (Object)sipUserId, (Object)GSON.toJson(map));
        if (ObjectUtils.isEmpty((Object)sipUserId)) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237\u547c\u51fa\u9650\u5236\u914d\u7f6e\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5931\u8d25");
            return AjaxResult.error();
        }
        SipUser sipUser = (SipUser)this.iSipUserService.getById((Serializable)sipUserId);
        if (ObjectUtils.isEmpty((Object)sipUser)) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237\u547c\u51fa\u9650\u5236\u914d\u7f6e\uff0c\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u5931\u8d25\uff1asipUserId=[{}]", (Object)sipUserId);
            return AjaxResult.error();
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        if (((Boolean)map.get(RESTRICT_SWITCH)).booleanValue()) {
            wrapper.set((Object)"call_out_restriction_type", (Object)map.get("callRestrictionType").toString());
            UserBusinessUtils.addComplexBusiness((String)SipUserBusinessEnum.COMPLEX_CALL_OUT_RESTRICTION.getCode(), (SipUser)sipUser);
        } else {
            wrapper.set((Object)"call_out_restriction_type", null);
            UserBusinessUtils.delComplexBusiness((String)SipUserBusinessEnum.COMPLEX_CALL_OUT_RESTRICTION.getCode(), (SipUser)sipUser);
        }
        wrapper.set((Object)"complex_business", (Object)sipUser.getComplexBusiness());
        wrapper.eq((Object)"id", (Object)sipUserId);
        return AjaxResult.success((Object)this.iSipUserService.saveOrUpdate((Object)new SipUser(), (Wrapper)wrapper));
    }
}

