/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.userMng;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.Hotline;
import com.uscale.system.service.HotlineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u70ed\u7ebf"})
@RestController
@RequestMapping(value={"/userMng/hotline"})
public class HotlineController
extends BaseController {
    @Autowired
    HotlineService hotlineService;

    @ApiOperation(value="\u83b7\u53d6\u70ed\u7ebf\u4fe1\u606f")
    @GetMapping(value={"/getHotlineInfo/{sipnumber}"})
    public AjaxResult<Hotline> getHotlineInfo(@PathVariable(value="sipnumber") String sipnumber) {
        if (StringUtils.isBlank((CharSequence)sipnumber)) {
            return AjaxResult.error((String)MessageUtils.message((String)"HotlineController.sip.number.error", (Object[])new Object[0]));
        }
        return AjaxResult.success((Object)this.hotlineService.getHotlineByNumber(sipnumber));
    }

    @ApiOperation(value="\u5173\u95ed\u70ed\u7ebf")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u70ed\u7ebf", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/closeHotline/{sipnumber}"})
    public AjaxResult closeHotline(@PathVariable(value="sipnumber") String sipnumber) {
        if (StringUtils.isBlank((CharSequence)sipnumber)) {
            return AjaxResult.error((String)MessageUtils.message((String)"HotlineController.sip.number.error", (Object[])new Object[0]));
        }
        this.hotlineService.deleteHotlineByNumber(sipnumber);
        return AjaxResult.success((String)MessageUtils.message((String)"HotlineController.business.closed.successfully", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u5f00\u542f\u70ed\u7ebf\u4e1a\u52a1")
    @Log(title="\u4e1a\u52a1\u914d\u7f6e:\u70ed\u7ebf", businessType=BusinessType.INSERT)
    @PostMapping(value={"/openHotline"})
    @Transactional(rollbackFor={Exception.class})
    public AjaxResult openHotline(@RequestBody Hotline hotline) {
        this.hotlineService.deleteHotlineByNumber(hotline.getNumber());
        this.hotlineService.saveHotlineByNumber(hotline);
        return AjaxResult.success((String)MessageUtils.message((String)"HotlineController.hotline.configuration.succeeded", (Object[])new Object[0]));
    }
}

