/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.trunkMng.trunkConfig;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.system.entity.ss7.TmConfigSS7Local;
import com.uscale.system.entity.ss7.TmConfigSS7Point;
import com.uscale.system.service.TmConfigSS7Service;
import com.uscale.system.vo.TmConfigSS7ExpertVO;
import com.uscale.system.vo.TmConfigSS7VO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"SS7\u4e2d\u7ee7\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/trunkConfig/ss7Config"})
public class TmConfigSS7Controller {
    @Resource
    private TmConfigSS7Service service;

    @GetMapping(value={"/all"})
    @ApiOperation(value="\u56fe\u6570\u636e")
    public AjaxResult<Map<String, Object>> all() {
        return AjaxResult.success((Object)this.service.all());
    }

    @DeleteMapping(value={"/all"})
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:SS7:\u5220\u9664\u6240\u6709", businessType=BusinessType.DELETE)
    @ApiOperation(value="\u5220\u9664\u6240\u6709")
    public AjaxResult deleteAll() {
        this.service.deleteAll();
        return AjaxResult.operateSuccess();
    }

    @GetMapping(value={"/localDict"})
    @ApiOperation(value="\u672c\u5c40\u4e0b\u62c9\u5b57\u5178")
    public AjaxResult<List<Map<String, String>>> localDict() {
        return AjaxResult.success((Object)this.service.allLocalName());
    }

    @GetMapping(value={"/pointDict"})
    @ApiOperation(value="\u5bf9\u5c40\u4e0b\u62c9\u5b57\u5178")
    public AjaxResult<List<Map<String, String>>> pointDict() {
        return AjaxResult.success((Object)this.service.allPointName());
    }

    @GetMapping(value={"/local/{index}"})
    @ApiOperation(value="\u672c\u5c40\u4fe1\u606f")
    public AjaxResult<TmConfigSS7Local> getLocal(@PathVariable String index) {
        return AjaxResult.success((Object)this.service.getLocal(index));
    }

    @PutMapping(value={"/local"})
    @ApiOperation(value="\u4fdd\u5b58\u672c\u5c40\u4fe1\u606f")
    public AjaxResult saveLocal(@RequestBody TmConfigSS7Local local) {
        this.service.saveLocal(local);
        return AjaxResult.success();
    }

    @DeleteMapping(value={"/local/{index}"})
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:SS7:\u5220\u9664\u672c\u5c40\u4fe1\u606f", businessType=BusinessType.DELETE)
    @ApiOperation(value="\u5220\u9664\u672c\u5c40\u4fe1\u606f")
    public AjaxResult deleteLocal(@PathVariable String index) {
        this.service.deleteLocal(index, false);
        return AjaxResult.success();
    }

    @GetMapping(value={"/point/{index}"})
    @ApiOperation(value="\u5bf9\u5c40\u4fe1\u606f")
    public AjaxResult<TmConfigSS7Point> getPoint(@PathVariable String index) {
        return AjaxResult.success((Object)this.service.getPoint(index));
    }

    @PutMapping(value={"/point"})
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:SS7:\u4fdd\u5b58\u5bf9\u5c40\u4fe1\u606f", businessType=BusinessType.INSERT)
    @ApiOperation(value="\u4fdd\u5b58\u5bf9\u5c40\u4fe1\u606f")
    public AjaxResult savePoint(@RequestBody TmConfigSS7Point local) {
        this.service.savePoint(local);
        return AjaxResult.success();
    }

    @DeleteMapping(value={"/point/{index}"})
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:SS7:\u5220\u9664\u5bf9\u5c40\u4fe1\u606f", businessType=BusinessType.DELETE)
    @ApiOperation(value="\u5220\u9664\u5bf9\u5c40\u4fe1\u606f")
    public AjaxResult deletePoint(@PathVariable String index) {
        this.service.deletePoint(index);
        return AjaxResult.success();
    }

    @GetMapping(value={"/trunk/{pointIndex}"})
    @ApiOperation(value="\u4e2d\u7ee7\u914d\u7f6e\u5217\u8868")
    public AjaxResult<TmConfigSS7VO> list(@PathVariable String pointIndex) {
        return AjaxResult.success((Object)this.service.list(pointIndex));
    }

    @PutMapping(value={"/trunk"})
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:SS7:\u4fdd\u5b58\u4e2d\u7ee7\u914d\u7f6e", businessType=BusinessType.INSERT)
    @ApiOperation(value="\u4fdd\u5b58\u4e2d\u7ee7\u914d\u7f6e")
    public AjaxResult saveTrunk(@RequestBody TmConfigSS7VO ss7VO) {
        this.service.saveTrunk(ss7VO);
        return AjaxResult.success();
    }

    @DeleteMapping(value={"/trunk"})
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:SS7:\u5220\u9664E1\u4e2d\u7ee7\u914d\u7f6e", businessType=BusinessType.DELETE)
    @ApiOperation(value="\u5220\u9664E1\u4e2d\u7ee7\u914d\u7f6e")
    public AjaxResult deleteTrunk(@RequestBody List<Integer> ids) {
        this.service.deleteTrunk(ids);
        return AjaxResult.success();
    }

    @DeleteMapping(value={"/mtp"})
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:SS7:\u5220\u9664MTP\u94fe\u8def\u914d\u7f6e", businessType=BusinessType.DELETE)
    @ApiOperation(value="\u5220\u9664MTP\u94fe\u8def\u914d\u7f6e")
    public AjaxResult deleteMtp(@RequestBody List<Integer> ids) {
        this.service.deleteMtp(ids);
        return AjaxResult.success();
    }

    @GetMapping(value={"/expert"})
    @ApiOperation(value="\u9ad8\u7ea7\u914d\u7f6e")
    public AjaxResult<TmConfigSS7ExpertVO> expert(String officeRouteId, String signallingType) {
        return AjaxResult.success((Object)this.service.expert(officeRouteId, signallingType));
    }

    @PutMapping(value={"/expert"})
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:SS7:\u4fdd\u5b58\u9ad8\u7ea7\u914d\u7f6e", businessType=BusinessType.INSERT)
    @ApiOperation(value="\u4fdd\u5b58\u9ad8\u7ea7\u914d\u7f6e")
    public AjaxResult saveExpert(@RequestBody TmConfigSS7ExpertVO expertVO) {
        this.service.saveExpert(expertVO);
        return AjaxResult.operateSuccess();
    }
}

