/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.trunkMng.trunkConfig;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.system.entity.r2.TmConfigR2Local;
import com.uscale.system.entity.r2.TmConfigR2LocalCustomLineIssue;
import com.uscale.system.entity.r2.TmConfigR2LocalCustomLineReport;
import com.uscale.system.entity.r2.TmConfigR2LocalCustomRegisterIssue;
import com.uscale.system.entity.r2.TmConfigR2LocalCustomRegisterReport;
import com.uscale.system.service.TmConfigR2Service;
import com.uscale.system.vo.TmConfigR2PointVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"R2\u4e2d\u7ee7\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/trunkConfig/r2Config"})
public class TmConfigR2Controller
extends BaseController {
    @Resource
    private TmConfigR2Service service;

    @GetMapping(value={"/all"})
    @ApiOperation(value="\u56fe\u6570\u636e")
    public AjaxResult<Map<String, Object>> all() {
        return AjaxResult.success((Object)this.service.all());
    }

    @DeleteMapping(value={"/all"})
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:R2:\u5220\u9664\u6240\u6709", businessType=BusinessType.DELETE)
    @ApiOperation(value="\u5220\u9664\u6240\u6709")
    public AjaxResult deleteAll() {
        this.service.deleteAll();
        return AjaxResult.success();
    }

    @GetMapping(value={"/localDict"})
    @ApiOperation(value="\u672c\u5c40\u4e0b\u62c9\u5b57\u5178")
    public AjaxResult<List<Map<String, String>>> localDict() {
        return AjaxResult.success((Object)this.service.allLocalName());
    }

    @GetMapping(value={"/local/{name}"})
    @ApiOperation(value="\u672c\u5c40\u4fe1\u606f")
    public AjaxResult<TmConfigR2Local> getLocal(@PathVariable String name) {
        return AjaxResult.success((Object)this.service.getByName(name));
    }

    @PutMapping(value={"/local"})
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:R2:\u4fdd\u5b58\u672c\u5c40\u4fe1\u606f", businessType=BusinessType.INSERT)
    @ApiOperation(value="\u4fdd\u5b58\u672c\u5c40\u4fe1\u606f")
    public AjaxResult saveLocal(@RequestBody TmConfigR2Local local) {
        this.service.saveLocal(local);
        return AjaxResult.success();
    }

    @DeleteMapping(value={"/local/{name}"})
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:R2:\u5220\u9664\u672c\u5c40\u4fe1\u606f", businessType=BusinessType.DELETE)
    @ApiOperation(value="\u5220\u9664\u672c\u5c40\u4fe1\u606f")
    public AjaxResult deleteLocal(@PathVariable String name) {
        this.service.deleteConfigR2LocalByName(name);
        return AjaxResult.success();
    }

    @GetMapping(value={"/point/{officeRouteId}"})
    @ApiOperation(value="\u5bf9\u5c40\u4fe1\u606f")
    public AjaxResult<TmConfigR2PointVO> getPoint(@PathVariable String officeRouteId) {
        return AjaxResult.success((Object)this.service.pointConfig(officeRouteId));
    }

    @PutMapping(value={"/point"})
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:R2:\u4fdd\u5b58\u5bf9\u5c40\u4fe1\u606f", businessType=BusinessType.INSERT)
    @ApiOperation(value="\u4fdd\u5b58\u5bf9\u5c40\u4fe1\u606f")
    public AjaxResult savePoint(@RequestBody TmConfigR2PointVO pointVO) {
        this.service.saveTmConfigR2Point(pointVO);
        return AjaxResult.success();
    }

    @DeleteMapping(value={"/point/{officeRouteId}"})
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:R2:\u5220\u9664\u5bf9\u5c40\u4fe1\u606f", businessType=BusinessType.DELETE)
    @ApiOperation(value="\u5220\u9664\u5bf9\u5c40\u4fe1\u606f")
    public AjaxResult deletePoint(@PathVariable String officeRouteId) {
        this.service.deleteTmConfigR2Point(officeRouteId);
        return AjaxResult.success();
    }

    @DeleteMapping(value={"/point"})
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:R2:\u5220\u9664\u5bf9\u5c40\u4fe1\u606f", businessType=BusinessType.DELETE)
    @ApiOperation(value="\u5220\u9664\u5bf9\u5c40\u4fe1\u606f")
    public AjaxResult deletePoint(@RequestBody List<Integer> ids) {
        this.service.deleteTmConfigR2Point(ids);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u8bb0\u53d1\u5668\u4fe1\u4ee4\u4e0a\u62a5\u5217\u8868")
    @GetMapping(value={"/customRegisterReport/{localName}"})
    public AjaxResult<List<TmConfigR2LocalCustomRegisterReport>> customRegisterReportList(@PathVariable String localName) {
        return AjaxResult.success((Object)this.service.getCustomRegisterReportByName(localName));
    }

    @ApiOperation(value="\u4fdd\u5b58\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u8bb0\u53d1\u5668\u4fe1\u4ee4\u4e0a\u62a5\u4fe1\u606f")
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:R2:\u4fdd\u5b58\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u8bb0\u53d1\u5668\u4fe1\u4ee4\u4e0a\u62a5\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PutMapping(value={"/customRegisterReport"})
    public AjaxResult saveCustomRegisterReport(@RequestBody List<TmConfigR2LocalCustomRegisterReport> registerReportList) {
        this.service.saveCustomRegisterReport(registerReportList);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u5220\u9664\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u8bb0\u53d1\u5668\u4fe1\u4ee4\u4e0a\u62a5\u4fe1\u606f")
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:R2:\u5220\u9664\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u8bb0\u53d1\u5668\u4fe1\u4ee4\u4e0a\u62a5\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/customRegisterReport"})
    public AjaxResult deleteCustomRegisterReport(@RequestBody List<Integer> ids) {
        this.service.deleteCustomRegisterReport(ids);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u8bb0\u53d1\u5668\u4fe1\u4ee4\u4e0b\u53d1\u5217\u8868")
    @GetMapping(value={"/customRegisterIssue/{localName}"})
    public AjaxResult<List<TmConfigR2LocalCustomRegisterIssue>> customRegisterIssueList(@PathVariable String localName) {
        return AjaxResult.success((Object)this.service.getCustomRegisterIssueByName(localName));
    }

    @ApiOperation(value="\u4fdd\u5b58\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u8bb0\u53d1\u5668\u4fe1\u4ee4\u4e0b\u53d1\u4fe1\u606f")
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:R2:\u4fdd\u5b58\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u8bb0\u53d1\u5668\u4fe1\u4ee4\u4e0b\u53d1\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PutMapping(value={"/customRegisterIssue"})
    public AjaxResult saveCustomRegisterIssue(@RequestBody List<TmConfigR2LocalCustomRegisterIssue> registerIssueList) {
        this.service.saveCustomRegisterIssue(registerIssueList);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u5220\u9664\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u8bb0\u53d1\u5668\u4fe1\u4ee4\u4e0b\u53d1\u4fe1\u606f")
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:R2:\u5220\u9664\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u8bb0\u53d1\u5668\u4fe1\u4ee4\u4e0b\u53d1\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/customRegisterIssue"})
    public AjaxResult deleteCustomRegisterIssue(@RequestBody List<Integer> ids) {
        this.service.deleteCustomRegisterIssue(ids);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u7ebf\u8def\u4fe1\u4ee4\u4e0a\u4f20\u5217\u8868")
    @GetMapping(value={"/customLineReport/{localName}"})
    public AjaxResult<List<TmConfigR2LocalCustomLineReport>> customLineReportList(@PathVariable String localName) {
        return AjaxResult.success((Object)this.service.getCustomLineReportByName(localName));
    }

    @ApiOperation(value="\u4fdd\u5b58\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u7ebf\u8def\u4fe1\u4ee4\u4e0a\u4f20\u4fe1\u606f")
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:R2:\u4fdd\u5b58\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u7ebf\u8def\u4fe1\u4ee4\u4e0a\u4f20\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PutMapping(value={"/customLineReport"})
    public AjaxResult saveCustomLineReport(@RequestBody List<TmConfigR2LocalCustomLineReport> lineReportList) {
        this.service.saveCustomLineReport(lineReportList);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u5220\u9664\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u7ebf\u8def\u4fe1\u4ee4\u4e0a\u4f20\u4fe1\u606f")
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:R2:\u5220\u9664\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u7ebf\u8def\u4fe1\u4ee4\u4e0a\u4f20\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/customLineReport"})
    public AjaxResult deleteCustomLineReport(@RequestBody List<Integer> ids) {
        this.service.deleteCustomLineReport(ids);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u7ebf\u8def\u4fe1\u4ee4\u4e0b\u53d1\u5217\u8868")
    @GetMapping(value={"/customLineIssue/{localName}"})
    public AjaxResult<List<TmConfigR2LocalCustomLineIssue>> customLineIssueList(@PathVariable String localName) {
        return AjaxResult.success((Object)this.service.getCustomLineIssueByName(localName));
    }

    @ApiOperation(value="\u4fdd\u5b58\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u7ebf\u8def\u4fe1\u4ee4\u4e0b\u53d1\u4fe1\u606f")
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:R2:\u4fdd\u5b58\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u7ebf\u8def\u4fe1\u4ee4\u4e0b\u53d1\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PutMapping(value={"/customLineIssue"})
    public AjaxResult saveLineIssueReport(@RequestBody List<TmConfigR2LocalCustomLineIssue> lineIssueList) {
        this.service.saveCustomLineIssue(lineIssueList);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u5220\u9664\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u7ebf\u8def\u4fe1\u4ee4\u4e0b\u53d1\u4fe1\u606f")
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:R2:\u5220\u9664\u672c\u5c40\u81ea\u5b9a\u4e49\u968f\u8def\u7ebf\u8def\u4fe1\u4ee4\u4e0b\u53d1\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/customLineIssue"})
    public AjaxResult deleteCustomLineIssue(@RequestBody List<Integer> ids) {
        this.service.deleteCustomLineIssue(ids);
        return AjaxResult.success();
    }
}

