/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.trunkMng.trunkConfig;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.system.entity.TmConfigPraQsig;
import com.uscale.system.service.TmConfigPraQsigService;
import com.uscale.system.vo.TmConfigPraQsigVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PRA\u3001QSIG\u4e2d\u7ee7\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/trunkConfig/praQsigConfig"})
public class TmConfigPraQsigController
extends BaseController {
    private final TmConfigPraQsigService configPraQsigService;

    @Autowired
    public TmConfigPraQsigController(TmConfigPraQsigService configPraQsigService) {
        this.configPraQsigService = configPraQsigService;
    }

    @ApiOperation(value="PRA\u3001QSIG\u4e2d\u7ee7\u914d\u7f6e\u5217\u8868")
    @PostMapping(value={"/list/{type}/{officeRouteId}"})
    public AjaxResult<TmConfigPraQsigVo> list(@PathVariable String type, @PathVariable String officeRouteId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TmConfigPraQsig::getType, (Object)type);
        wrapper.eq(TmConfigPraQsig::getOfficeRouteId, (Object)officeRouteId);
        List list = this.configPraQsigService.list((Wrapper)wrapper);
        TmConfigPraQsigVo qsigVo = new TmConfigPraQsigVo(list, this.configPraQsigService.getExpert(officeRouteId, "inTrunk"), this.configPraQsigService.getExpert(officeRouteId, "outTrunk"), this.configPraQsigService.getExpert(officeRouteId, "bothTrunk"));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            TmConfigPraQsig tmConfigPraQsig = (TmConfigPraQsig)list.get(0);
            qsigVo.setMaxRestrictedCalls(tmConfigPraQsig.getMaxRestrictedCalls());
            qsigVo.setMaxOutRestrictedCalls(tmConfigPraQsig.getMaxOutRestrictedCalls());
            qsigVo.setEarlyMedia(tmConfigPraQsig.getEarlyMedia());
            qsigVo.setPlayFakeBell(tmConfigPraQsig.getPlayFakeBell());
        }
        return AjaxResult.success((Object)qsigVo);
    }

    @ApiOperation(value="PRA\u3001QSIG\u4e2d\u7ee7\u914d\u7f6e\u56fe\u6570\u636e")
    @GetMapping(value={"/praQsigList/{type}"})
    public AjaxResult<Map<String, Object>> praQsigList(@PathVariable String type) {
        return AjaxResult.success((Object)this.configPraQsigService.praQsigList(type));
    }

    @ApiOperation(value="PRA\u3001QSIG\u4e2d\u7ee7\u914d\u7f6e\u4fdd\u5b58")
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:PRA\u3001QSIG", businessType=BusinessType.INSERT)
    @PutMapping
    public AjaxResult save(@RequestBody TmConfigPraQsigVo vo) {
        return AjaxResult.success((Object)this.configPraQsigService.save(vo));
    }

    @ApiOperation(value="PRA\u3001QSIG\u4e2d\u7ee7\u914d\u7f6e\u5220\u9664")
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:PRA\u3001QSIG", businessType=BusinessType.DELETE)
    @DeleteMapping
    public AjaxResult delete(@RequestBody List<Long> ids) {
        return AjaxResult.success((Object)this.configPraQsigService.delete(ids));
    }

    @ApiOperation(value="\u6839\u636e\u5c40\u5411\u53f7\u5220\u9664PRA\u3001QSIG\u4e2d\u7ee7\u914d\u7f6e")
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:PRA\u3001QSIG", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/deleteByOfficeRouteId/{officeRouteId}"})
    public AjaxResult deleteByOfficeRouteId(@PathVariable String officeRouteId) {
        return AjaxResult.success((Object)this.configPraQsigService.deleteByOfficeRouteId(officeRouteId));
    }
}

