/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.trunkMng.trunkConfig;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.system.entity.TmConfigSip;
import com.uscale.system.service.ITmConfigSipService;
import com.uscale.system.vo.DirectMediaVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"SIP\u4e2d\u7ee7\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/trunkConfig/sipConfig"})
public class SipConfigController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SipConfigController.class);
    private final ITmConfigSipService iTmConfigSipService;

    @Autowired
    public SipConfigController(ITmConfigSipService iTmConfigSipService) {
        this.iTmConfigSipService = iTmConfigSipService;
    }

    @ApiOperation(value="\u67e5\u8be2SIP\u914d\u7f6e\u5217\u8868")
    @GetMapping(value={"/list"})
    public AjaxResult<Map<String, Object>> list(Integer pageNum, Integer pageSize) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return AjaxResult.success((Object)this.iTmConfigSipService.queryByPage(page));
    }

    @ApiOperation(value="\u83b7\u53d6SIP\u914d\u7f6e\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult<Map<String, Object>> getInfo(@PathVariable(value="id") Integer id) {
        TmConfigSip configSip = (TmConfigSip)this.iTmConfigSipService.getById((Serializable)id);
        Map res = this.iTmConfigSipService.init(configSip.getOfficeRouteId());
        res.put("sipConfig", configSip);
        LOGGER.debug("\u83b7\u53d6SIP\u914d\u7f6e\u4fe1\u606f\uff1a[{}]", (Object)res);
        return AjaxResult.success((Object)res);
    }

    @ApiOperation(value="\u5c40\u5411\u4e0b\u62c9\u5b57\u5178")
    @GetMapping(value={"/init"})
    public AjaxResult<Map<String, Object>> init() {
        return AjaxResult.success((Object)this.iTmConfigSipService.init(null));
    }

    @ApiOperation(value="\u5c40\u5411\u4e0b\u62c9\u5b57\u5178\u5305\u62ec\u81ea\u8eab")
    @GetMapping(value={"/initContainSelf"})
    public AjaxResult<Map<String, Object>> initContainSelf(@RequestParam(required=false) String officeRouteId) {
        return AjaxResult.success((Object)this.iTmConfigSipService.init(officeRouteId));
    }

    @ApiOperation(value="\u65b0\u589eSIP\u914d\u7f6e")
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:SIP", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TmConfigSip tmConfigSip) {
        return this.toAjax(this.iTmConfigSipService.save(tmConfigSip));
    }

    @ApiOperation(value="\u4fee\u6539SIP\u914d\u7f6e")
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:SIP", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TmConfigSip tmConfigSip) {
        return this.toAjax(this.iTmConfigSipService.updateById(tmConfigSip));
    }

    @ApiOperation(value="\u5220\u9664SIP\u914d\u7f6e")
    @Log(title="\u4e2d\u7ee7\u914d\u7f6e:SIP", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable List<Long> ids) {
        return this.toAjax(this.iTmConfigSipService.removeByIds(ids));
    }

    @ApiOperation(value="\u4e2d\u7ee7\u7528\u6237\u7ec4\u57df\u540d\u4e0b\u62c9\u5b57\u5178")
    @GetMapping(value={"/peerDomains"})
    public AjaxResult getTrunkPeerDomains(String mode) {
        return AjaxResult.success((Object)this.iTmConfigSipService.getTrunkPeerDomains(mode));
    }

    @ApiOperation(value="Sip Trunk DirectMedia")
    @GetMapping(value={"/directMedia"})
    public AjaxResult<DirectMediaVo> directMedia() {
        return AjaxResult.success((Object)this.iTmConfigSipService.directMedia());
    }
}

