/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.trunkMng.routeConfig;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.TmTimeSegment;
import com.uscale.system.service.ITmOfficeRouteService;
import com.uscale.system.service.ITmTimeSegmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e2d\u7ee7-\u65f6\u95f4\u6bb5\u7d22\u5f15"})
@RestController
@RequestMapping(value={"/trunkMng/segment"})
public class TmTimeSegmentController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmTimeSegmentController.class);
    private static final Gson GSON = new Gson();
    private final ITmTimeSegmentService ITimeSegmentService;
    private final ITmOfficeRouteService officeRouteService;

    @Autowired
    public TmTimeSegmentController(ITmTimeSegmentService ITimeSegmentService, ITmOfficeRouteService officeRouteService) {
        this.ITimeSegmentService = ITimeSegmentService;
        this.officeRouteService = officeRouteService;
    }

    @ApiOperation(value="\u67e5\u8be2\u65f6\u95f4\u6bb5\u7d22\u5f15\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo<TmTimeSegment> list(@ApiParam(value="\u8d77\u59cb\u7d22\u5f15") String startIndex, @ApiParam(value="\u7ed3\u675f\u7d22\u5f15") String endIndex, @ApiParam(value="\u65f6\u95f4\u6bb5\u7c7b\u578b") String timeSegmentType, @ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u9875\u6761\u6570") Integer pageSize) {
        QueryWrapper wrapper = new QueryWrapper();
        if (!ObjectUtils.isEmpty((Object)startIndex)) {
            wrapper.ge((Object)"time_segment_index", (Object)startIndex);
        }
        if (!ObjectUtils.isEmpty((Object)endIndex)) {
            wrapper.le((Object)"time_segment_index", (Object)endIndex);
        }
        if (!ObjectUtils.isEmpty((Object)timeSegmentType)) {
            wrapper.eq((Object)"time_segment_type", (Object)timeSegmentType);
        }
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.ITimeSegmentService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u83b7\u53d6\u65f6\u95f4\u6bb5\u7d22\u5f15\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult<TmTimeSegment> getInfo(@ApiParam(value="\u65f6\u95f4\u6bb5\u7d22\u5f15ID") @PathVariable(value="id") Integer id) {
        return AjaxResult.success((Object)this.ITimeSegmentService.getById((Serializable)id));
    }

    @ApiOperation(value="\u65b0\u589e\u65f6\u95f4\u6bb5\u7d22\u5f15")
    @Log(title="\u65f6\u95f4\u6bb5\u7d22\u5f15", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@ApiParam(value="\u5f85\u6dfb\u52a0\u6570\u636e") @RequestBody TmTimeSegment timeSegment) {
        return this.toAjax(this.ITimeSegmentService.save((Object)timeSegment));
    }

    @ApiOperation(value="\u4fee\u6539\u65f6\u95f4\u6bb5\u7d22\u5f15")
    @Log(title="\u65f6\u95f4\u6bb5\u7d22\u5f15", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@ApiParam(value="\u5f85\u4fee\u6539\u6570\u636e") @RequestBody TmTimeSegment timeSegment) {
        return this.toAjax(this.ITimeSegmentService.updateById((Object)timeSegment));
    }

    @ApiOperation(value="\u5220\u9664\u65f6\u95f4\u6bb5\u7d22\u5f15")
    @Log(title="\u65f6\u95f4\u6bb5\u7d22\u5f15", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@ApiParam(value="\u5f85\u5220\u9664\u6570\u636eID") @PathVariable Integer[] ids) {
        List tmTimeSegments = this.ITimeSegmentService.listByIds(Arrays.asList((Object[])ids.clone()));
        if (CollectionUtils.isEmpty((Collection)tmTimeSegments)) {
            return this.toAjax(true);
        }
        ArrayList indexs = new ArrayList();
        tmTimeSegments.forEach(item -> indexs.add(String.valueOf(item.getTimeSegmentIndex())));
        List tmOfficeRoutes = this.officeRouteService.getTmOfficeRouteByTimeIndex(indexs);
        if (CollectionUtils.isNotEmpty((Collection)tmOfficeRoutes)) {
            return AjaxResult.error((String)MessageUtils.message((String)"TmTimeSegmentController.TimeIndex.tip1", (Object[])new Object[0]));
        }
        return this.toAjax(this.ITimeSegmentService.removeByIds(Arrays.asList((Object[])ids.clone())));
    }
}

