/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.trunkMng.routeConfig;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.TmOfficeRouteSelectionCode;
import com.uscale.system.model.officeRoute.QueryOfficeRouteSelecttionCode;
import com.uscale.system.service.ITmFailureProcessingIndexService;
import com.uscale.system.service.ITmOfficeRouteSelectionCodeService;
import com.uscale.system.service.ITmOfficeRouteService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c40\u5411\u9009\u62e9\u7801"})
@RestController
@RequestMapping(value={"/trunkMng/code"})
public class TmOfficeRouteSelectionCodeController
extends BaseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final Gson GSON = new Gson();
    private final ITmOfficeRouteSelectionCodeService officeRouteSelectionCodeService;
    private final ITmOfficeRouteService officeRouteService;
    private final ITmFailureProcessingIndexService failureProcessingIndexService;

    @Autowired
    public TmOfficeRouteSelectionCodeController(ITmOfficeRouteSelectionCodeService officeRouteSelectionCodeService, ITmOfficeRouteService officeRouteService, ITmFailureProcessingIndexService failureProcessingIndexService) {
        this.officeRouteSelectionCodeService = officeRouteSelectionCodeService;
        this.officeRouteService = officeRouteService;
        this.failureProcessingIndexService = failureProcessingIndexService;
    }

    @ApiOperation(value="\u67e5\u8be2\u5c40\u5411\u9009\u62e9\u7801\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo<TmOfficeRouteSelectionCode> list(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") QueryOfficeRouteSelecttionCode queryParams, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") Integer pageNum, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") Integer pageSize) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!ObjectUtils.isEmpty((Object)queryParams.getStartOfficeRouteSelectionCode())) {
            wrapper.ge(TmOfficeRouteSelectionCode::getOfficeRouteSelectionCode, (Object)queryParams.getStartOfficeRouteSelectionCode());
        }
        if (!ObjectUtils.isEmpty((Object)queryParams.getEndOfficeRouteSelectionCode())) {
            wrapper.le(TmOfficeRouteSelectionCode::getOfficeRouteSelectionCode, (Object)queryParams.getEndOfficeRouteSelectionCode());
        }
        if (!ObjectUtils.isEmpty((Object)queryParams.getTwoStageDialingTone())) {
            wrapper.eq(TmOfficeRouteSelectionCode::getTwoStageDialingTone, (Object)queryParams.getTwoStageDialingTone());
        }
        if (!ObjectUtils.isEmpty((Object)queryParams.getPolicy())) {
            wrapper.eq(TmOfficeRouteSelectionCode::getPolicy, (Object)queryParams.getPolicy());
        }
        wrapper.orderByAsc(TmOfficeRouteSelectionCode::getOfficeRouteSelectionCode);
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.officeRouteSelectionCodeService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u83b7\u53d6\u5c40\u5411\u9009\u62e9\u7801\u5b57\u5178")
    @GetMapping(value={"/init"})
    public AjaxResult<Map<String, Object>> init() {
        return AjaxResult.success((Object)this.officeRouteSelectionCodeService.init());
    }

    @ApiOperation(value="\u83b7\u53d6\u5c40\u5411\u9009\u62e9\u7801\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult<TmOfficeRouteSelectionCode> getInfo(@ApiParam(value="\u5c40\u5411\u9009\u62e9\u7801ID") @PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.officeRouteSelectionCodeService.getById((Serializable)id));
    }

    @ApiOperation(value="\u65b0\u589e\u5c40\u5411\u9009\u62e9\u7801")
    @Log(title="\u5c40\u5411\u9009\u62e9\u7801", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") @RequestBody TmOfficeRouteSelectionCode officeRouteSelectionCode) {
        this.LOGGER.debug("\u65b0\u589e\u65b0\u589e\u5c40\u5411\u9009\u62e9\u7801\uff0c\u83b7\u53d6\u5230\u53c2\u6570\uff1aofficeRouteSelectionCode=[{}]", (Object)GSON.toJson((Object)officeRouteSelectionCode));
        return this.toAjax(this.officeRouteSelectionCodeService.save((Object)officeRouteSelectionCode));
    }

    @ApiOperation(value="\u4fee\u6539\u5c40\u5411\u9009\u62e9\u7801")
    @Log(title="\u5c40\u5411\u9009\u62e9\u7801", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/update"})
    public AjaxResult edit(@ApiParam(value="\u5f85\u4fee\u6539\u6570\u636e") @RequestBody TmOfficeRouteSelectionCode officeRouteSelectionCode) {
        return this.toAjax(this.officeRouteSelectionCodeService.saveOrUpdate((Object)officeRouteSelectionCode));
    }

    @ApiOperation(value="\u5220\u9664\u5c40\u5411\u9009\u62e9\u7801")
    @Log(title="\u5c40\u5411\u9009\u62e9\u7801", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@ApiParam(value="\u5f85\u5220\u9664\u6570\u636eID") @PathVariable List<Long> ids) {
        List tmOfficeRouteSelectionCodes = this.officeRouteSelectionCodeService.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)tmOfficeRouteSelectionCodes)) {
            return this.toAjax(true);
        }
        ArrayList codes = new ArrayList();
        tmOfficeRouteSelectionCodes.forEach(item -> codes.add(String.valueOf(item.getOfficeRouteSelectionCode())));
        List tmOfficeRoutes = this.officeRouteService.getTmOfficeRouteByCode(codes);
        if (CollectionUtils.isNotEmpty((Collection)tmOfficeRoutes)) {
            return AjaxResult.error((String)MessageUtils.message((String)"TmOfficeRouteSelectionCodeController.SelectionCode.tip1", (Object[])new Object[0]));
        }
        List tmFailureProcessingIndexs = this.failureProcessingIndexService.getTmFailureProcessingIndexByCode(codes);
        if (CollectionUtils.isNotEmpty((Collection)tmFailureProcessingIndexs)) {
            return AjaxResult.error((String)MessageUtils.message((String)"TmOfficeRouteSelectionCodeController.SelectionCode.tip2", (Object[])new Object[0]));
        }
        return this.toAjax(this.officeRouteSelectionCodeService.removeByIds(ids));
    }
}

