/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.trunkMng.routeConfig;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.ReroutingConfiguration;
import com.uscale.system.entity.TmConfigSip;
import com.uscale.system.entity.TmOfficeRoute;
import com.uscale.system.model.OfficeRouteModel;
import com.uscale.system.service.ICommonDictService;
import com.uscale.system.service.ITmCalleePrefixConfigurationService;
import com.uscale.system.service.ITmCallerCalledPrefixRoutingConfService;
import com.uscale.system.service.ITmConfigSipService;
import com.uscale.system.service.ITmOfficeRouteService;
import com.uscale.system.service.ReroutingConfigurationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c40\u5411"})
@RestController
@RequestMapping(value={"/trunkMng/route"})
public class TmOfficeRouteController
extends BaseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final ICommonDictService commonDictService;
    private final ITmOfficeRouteService officeRouteService;
    private final ReroutingConfigurationService reroutingConfigurationService;
    private final ITmConfigSipService tmConfigSipService;
    private final ITmCallerCalledPrefixRoutingConfService tmCallerCalledPredixRoutingConfService;
    private final ITmCalleePrefixConfigurationService tmCalleePrefixConfigurationService;

    @Autowired
    public TmOfficeRouteController(ICommonDictService commonDictService, ITmOfficeRouteService officeRouteService, ReroutingConfigurationService reroutingConfigurationService, ITmConfigSipService tmConfigSipService, ITmCallerCalledPrefixRoutingConfService tmCallerCalledPredixRoutingConfService, ITmCalleePrefixConfigurationService tmCalleePrefixConfigurationService) {
        this.commonDictService = commonDictService;
        this.officeRouteService = officeRouteService;
        this.reroutingConfigurationService = reroutingConfigurationService;
        this.tmConfigSipService = tmConfigSipService;
        this.tmCallerCalledPredixRoutingConfService = tmCallerCalledPredixRoutingConfService;
        this.tmCalleePrefixConfigurationService = tmCalleePrefixConfigurationService;
    }

    @ApiOperation(value="\u67e5\u8be2\u5c40\u5411\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo<OfficeRouteModel> list(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") OfficeRouteModel officeRouteModel, @ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u9875\u6761\u6570") Integer pageSize) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable(this.officeRouteService.queryByPage(page, officeRouteModel));
    }

    @ApiOperation(value="\u83b7\u53d6\u5c40\u5411\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult<OfficeRouteModel> getInfo(@ApiParam(value="\u5c40\u5411ID") @PathVariable(value="id") Integer id) {
        this.LOGGER.debug("\u83b7\u53d6\u5c40\u5411\u8be6\u7ec6\u4fe1\u606f\uff0cid=[{}]", (Object)id);
        return AjaxResult.success((Object)this.officeRouteService.getOfficeRouteById(id));
    }

    @ApiOperation(value="\u83b7\u53d6\u5c40\u5411\u5b57\u5178")
    @GetMapping(value={"/init"})
    public AjaxResult<OfficeRouteModel> init() {
        OfficeRouteModel officeRouteModel = new OfficeRouteModel();
        officeRouteModel.setOfficeRouteSelectionCodeDict(this.commonDictService.getOfficeRouteSelectionCodeDict());
        officeRouteModel.setTimeSegmentDict(this.commonDictService.getTimeSegmentDict());
        return AjaxResult.success((Object)officeRouteModel);
    }

    @ApiOperation(value="\u65b0\u589e\u5c40\u5411")
    @Log(title="\u5c40\u5411", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") @RequestBody TmOfficeRoute officeRoute) {
        boolean save = this.officeRouteService.save((Object)officeRoute);
        if (save) {
            ReroutingConfiguration reroutingConfiguration = new ReroutingConfiguration();
            reroutingConfiguration.setOfficeRouteSelectionCode(Integer.valueOf(Integer.parseInt(officeRoute.getOfficeRouteSelectionCode())));
            reroutingConfiguration.setCallsourceno(Integer.valueOf(0));
            reroutingConfiguration.setRouteno(officeRoute.getOfficeRouteId());
            reroutingConfiguration.setOfficeRouteid(officeRoute.getOfficeRouteId());
            return this.toAjax(this.reroutingConfigurationService.save((Object)reroutingConfiguration));
        }
        return this.toAjax(save);
    }

    @ApiOperation(value="\u4fee\u6539\u5c40\u5411")
    @Log(title="\u5c40\u5411", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/update"})
    public AjaxResult edit(@ApiParam(value="\u5f85\u4fee\u6539\u6570\u636e") @RequestBody TmOfficeRoute officeRoute) {
        return this.toAjax(this.officeRouteService.updateById((Object)officeRoute));
    }

    @ApiOperation(value="\u5220\u9664\u5c40\u5411")
    @Log(title="\u5c40\u5411", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@ApiParam(value="\u5f85\u5220\u9664\u6570\u636eID") @PathVariable List<Long> ids) {
        if (ids != null && ids.size() > 0) {
            List tmOfficeRoutes = this.officeRouteService.listByIds(ids);
            ArrayList<String> officeRouteIds = new ArrayList<String>();
            ArrayList<String> officeRouteSelectionCodes = new ArrayList<String>();
            for (TmOfficeRoute tm : tmOfficeRoutes) {
                officeRouteIds.add(String.valueOf(tm.getOfficeRouteId()));
                officeRouteSelectionCodes.add(tm.getOfficeRouteSelectionCode());
            }
            List tmCallerCalledPrefixRoutingConfs = this.tmCallerCalledPredixRoutingConfService.getTmCallerCalledPrefixRoutingConfByCode(officeRouteSelectionCodes);
            if (CollectionUtils.isNotEmpty((Collection)tmCallerCalledPrefixRoutingConfs)) {
                return AjaxResult.error((String)MessageUtils.message((String)"TmOfficeRouteController.TmOfficeRoute.tip1", (Object[])new Object[0]));
            }
            List tmCalleePrefixConfigurationByCodes = this.tmCalleePrefixConfigurationService.getTmCalleePrefixConfigurationByCode(officeRouteSelectionCodes);
            if (CollectionUtils.isNotEmpty((Collection)tmCalleePrefixConfigurationByCodes)) {
                return AjaxResult.error((String)MessageUtils.message((String)"TmOfficeRouteController.TmOfficeRoute.tip2", (Object[])new Object[0]));
            }
            LambdaQueryWrapper tmConfigSipWrapper = new LambdaQueryWrapper();
            tmConfigSipWrapper.in(TmConfigSip::getOfficeRouteId, officeRouteIds);
            int count = this.tmConfigSipService.count((Wrapper)tmConfigSipWrapper);
            if (count > 0) {
                return AjaxResult.error((String)MessageUtils.message((String)"TmOfficeRouteController.TmOfficeRoute.tip3", (Object[])new Object[0]));
            }
            boolean remove = this.officeRouteService.removeByIds(ids);
            if (remove) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.in(ReroutingConfiguration::getOfficeRouteid, officeRouteIds);
                wrapper.in(ReroutingConfiguration::getOfficeRouteSelectionCode, officeRouteSelectionCodes);
                return this.toAjax(this.reroutingConfigurationService.remove((Wrapper)wrapper));
            }
            return this.toAjax(remove);
        }
        return this.toAjax(true);
    }
}

