/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.trunkMng.routeConfig;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.TmNumberChangeIndex;
import com.uscale.system.model.officeRoute.QueryNumberChangeIndex;
import com.uscale.system.service.BearerTrunkConfigurationService;
import com.uscale.system.service.ITmCalleePrefixConfigurationService;
import com.uscale.system.service.ITmCallerCalledPrefixRoutingConfService;
import com.uscale.system.service.ITmCallerPrefixConfigurationService;
import com.uscale.system.service.ITmFailureProcessingIndexService;
import com.uscale.system.service.ITmGroupConfigService;
import com.uscale.system.service.ITmNumberChangeIndexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53f7\u7801\u53d8\u6362\u7d22\u5f15"})
@RestController
@RequestMapping(value={"/trunkMng/numberChangeIndex"})
public class TmNumberChangeIndexController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmNumberChangeIndexController.class);
    private static final Gson GSON = new Gson();
    private final ITmNumberChangeIndexService numberChangeIndexService;
    private final ITmCallerPrefixConfigurationService tmCallerPrefixConfigurationService;
    private final ITmCallerCalledPrefixRoutingConfService tmCallerCalledPredixRoutingConfService;
    private final ITmCalleePrefixConfigurationService calleePrefixConfigurationService;
    private final ITmGroupConfigService tmGroupConfigService;
    private final BearerTrunkConfigurationService bearerTrunkConfigurationService;
    private final ITmFailureProcessingIndexService failureProcessingIndexService;

    @Autowired
    public TmNumberChangeIndexController(ITmNumberChangeIndexService numberChangeIndexService, ITmCallerPrefixConfigurationService tmCallerPrefixConfigurationService, ITmCallerCalledPrefixRoutingConfService tmCallerCalledPredixRoutingConfService, ITmCalleePrefixConfigurationService calleePrefixConfigurationService, ITmGroupConfigService tmGroupConfigService, BearerTrunkConfigurationService bearerTrunkConfigurationService, ITmFailureProcessingIndexService failureProcessingIndexService) {
        this.numberChangeIndexService = numberChangeIndexService;
        this.tmCallerPrefixConfigurationService = tmCallerPrefixConfigurationService;
        this.tmCallerCalledPredixRoutingConfService = tmCallerCalledPredixRoutingConfService;
        this.calleePrefixConfigurationService = calleePrefixConfigurationService;
        this.tmGroupConfigService = tmGroupConfigService;
        this.bearerTrunkConfigurationService = bearerTrunkConfigurationService;
        this.failureProcessingIndexService = failureProcessingIndexService;
    }

    @ApiOperation(value="\u67e5\u8be2\u53f7\u7801\u53d8\u6362\u7d22\u5f15\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo<TmNumberChangeIndex> list(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") QueryNumberChangeIndex queryNumberChangeIndex, @ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u9875\u6761\u6570") Integer pageSize) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!ObjectUtils.isEmpty((Object)queryNumberChangeIndex.getStartNumberChangeIndex())) {
            wrapper.ge(TmNumberChangeIndex::getNumberChangeIndex, (Object)queryNumberChangeIndex.getStartNumberChangeIndex());
        }
        if (!ObjectUtils.isEmpty((Object)queryNumberChangeIndex.getEndNumberChangeIndex())) {
            wrapper.le(TmNumberChangeIndex::getNumberChangeIndex, (Object)queryNumberChangeIndex.getEndNumberChangeIndex());
        }
        if (!ObjectUtils.isEmpty((Object)queryNumberChangeIndex.getChangeType())) {
            wrapper.eq(TmNumberChangeIndex::getChangeType, (Object)queryNumberChangeIndex.getChangeType());
        }
        wrapper.orderByAsc(TmNumberChangeIndex::getNumberChangeIndex);
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.numberChangeIndexService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u83b7\u53d6\u53f7\u7801\u53d8\u6362\u7d22\u5f15\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult<TmNumberChangeIndex> getInfo(@ApiParam(value="\u53f7\u7801\u53d8\u6362\u7d22\u5f15ID") @PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.numberChangeIndexService.getById((Serializable)id));
    }

    @ApiOperation(value="\u65b0\u589e\u53f7\u7801\u53d8\u6362\u7d22\u5f15")
    @Log(title="\u53f7\u7801\u53d8\u6362\u7d22\u5f15", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") @RequestBody TmNumberChangeIndex numberChangeIndex) {
        return this.toAjax(this.numberChangeIndexService.save((Object)numberChangeIndex));
    }

    @ApiOperation(value="\u4fee\u6539\u53f7\u7801\u53d8\u6362\u7d22\u5f15")
    @Log(title="\u53f7\u7801\u53d8\u6362\u7d22\u5f15", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/update"})
    public AjaxResult edit(@ApiParam(value="\u5f85\u4fee\u6539\u6570\u636e") @RequestBody TmNumberChangeIndex numberChangeIndex) {
        return this.toAjax(this.numberChangeIndexService.updateById((Object)numberChangeIndex));
    }

    @ApiOperation(value="\u5220\u9664\u53f7\u7801\u53d8\u6362\u7d22\u5f15")
    @Log(title="\u53f7\u7801\u53d8\u6362\u7d22\u5f15", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@ApiParam(value="\u5f85\u5220\u9664\u6570\u636eID") @PathVariable List<Long> ids) {
        List tmNumberChangeIndices = this.numberChangeIndexService.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)tmNumberChangeIndices)) {
            return this.toAjax(true);
        }
        ArrayList indexs = new ArrayList();
        tmNumberChangeIndices.forEach(item -> indexs.add(String.valueOf(item.getNumberChangeIndex())));
        List tmCallerPrefixConfigurations = this.tmCallerPrefixConfigurationService.getTmCallerPrefixConfigurationByNumberChangeIndex(indexs);
        if (CollectionUtils.isNotEmpty((Collection)tmCallerPrefixConfigurations)) {
            return AjaxResult.error((String)MessageUtils.message((String)"TmNumberChangeIndexController.number.index.tip1", (Object[])new Object[0]));
        }
        List tmCallerCalledPrefixRoutingConfs = this.tmCallerCalledPredixRoutingConfService.getTmCallerCalledPrefixRoutingConfByNumberChangeIndex(indexs);
        if (CollectionUtils.isNotEmpty((Collection)tmCallerCalledPrefixRoutingConfs)) {
            return AjaxResult.error((String)MessageUtils.message((String)"TmNumberChangeIndexController.number.index.tip2", (Object[])new Object[0]));
        }
        List tmCalleePrefixConfigurations = this.calleePrefixConfigurationService.getTmCalleePrefixConfigurationByNumberChangeIndex(indexs);
        if (CollectionUtils.isNotEmpty((Collection)tmCalleePrefixConfigurations)) {
            return AjaxResult.error((String)MessageUtils.message((String)"TmNumberChangeIndexController.number.index.tip3", (Object[])new Object[0]));
        }
        List tmGroupConfigs = this.tmGroupConfigService.getTmGroupConfigByNumberChangeIndex(indexs);
        if (CollectionUtils.isNotEmpty((Collection)tmGroupConfigs)) {
            return AjaxResult.error((String)MessageUtils.message((String)"TmNumberChangeIndexController.number.index.tip4", (Object[])new Object[0]));
        }
        List bearerTrunkConfigurations = this.bearerTrunkConfigurationService.getBearerTrunkConfigurationByNumberChangeIndex(indexs);
        if (CollectionUtils.isNotEmpty((Collection)bearerTrunkConfigurations)) {
            return AjaxResult.error((String)MessageUtils.message((String)"TmNumberChangeIndexController.number.index.tip5", (Object[])new Object[0]));
        }
        List tmFailureProcessingIndexs = this.failureProcessingIndexService.getTmFailureProcessingIndexByNumberChangeIndex(indexs);
        if (CollectionUtils.isNotEmpty((Collection)tmFailureProcessingIndexs)) {
            return AjaxResult.error((String)MessageUtils.message((String)"TmNumberChangeIndexController.number.index.tip6", (Object[])new Object[0]));
        }
        return this.toAjax(this.numberChangeIndexService.removeByIds(ids));
    }
}

