/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.trunkMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.TmCallSource;
import com.uscale.system.model.QueryTmCallSource;
import com.uscale.system.model.trunkMng.trunkGroupConfig.QueryTmGroupConfig;
import com.uscale.system.service.BearerTrunkConfigurationService;
import com.uscale.system.service.IGsEmergencyCallService;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.service.ITmCallSourceService;
import com.uscale.system.service.ITmCallerPrefixConfigurationService;
import com.uscale.system.service.ITmGroupConfigService;
import com.uscale.system.service.ReroutingConfigurationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u547c\u53eb\u6e90"})
@RestController
@RequestMapping(value={"/trunkMng/callSource"})
public class TmCallSourceController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmCallSourceController.class);
    private static final Gson GSON = new Gson();
    private final ITmCallSourceService tmCallSourceService;
    private final ISipUserService iSipUserService;
    private final IGsEmergencyCallService gsEmergencyCallService;
    private final ITmCallerPrefixConfigurationService tmCallerPrefixConfigurationService;
    private final ITmGroupConfigService tmGroupConfigService;
    private final ReroutingConfigurationService reroutingConfigurationService;
    private final BearerTrunkConfigurationService bearerTrunkConfigurationService;

    @Autowired
    public TmCallSourceController(ITmCallSourceService tmCallSourceService, ISipUserService iSipUserService, IGsEmergencyCallService gsEmergencyCallService, ITmCallerPrefixConfigurationService tmCallerPrefixConfigurationService, ITmGroupConfigService tmGroupConfigService, ReroutingConfigurationService reroutingConfigurationService, BearerTrunkConfigurationService bearerTrunkConfigurationService) {
        this.tmCallSourceService = tmCallSourceService;
        this.iSipUserService = iSipUserService;
        this.gsEmergencyCallService = gsEmergencyCallService;
        this.tmCallerPrefixConfigurationService = tmCallerPrefixConfigurationService;
        this.tmGroupConfigService = tmGroupConfigService;
        this.reroutingConfigurationService = reroutingConfigurationService;
        this.bearerTrunkConfigurationService = bearerTrunkConfigurationService;
    }

    @ApiOperation(value="\u67e5\u8be2\u547c\u53eb\u6e90\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo<TmCallSource> list(QueryTmCallSource tmCallSource, Integer pageNum, Integer pageSize) {
        QueryWrapper wrapper = new QueryWrapper();
        if (tmCallSource.getCallSourceNo() != null && !"".equals(tmCallSource.getCallSourceNo())) {
            wrapper.ge((Object)"call_source_no", (Object)new Integer(tmCallSource.getCallSourceNo()));
        }
        if (tmCallSource.getEndCallSourceNo() != null && !"".equals(tmCallSource.getEndCallSourceNo())) {
            wrapper.le((Object)"call_source_no", (Object)new Integer(tmCallSource.getEndCallSourceNo()));
        }
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.tmCallSourceService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u83b7\u53d6\u547c\u53eb\u6e90\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult<TmCallSource> getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.tmCallSourceService.getById((Serializable)id));
    }

    @ApiOperation(value="\u65b0\u589e\u547c\u53eb\u6e90")
    @Log(title="\u547c\u53eb\u6e90", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TmCallSource tmCallSource) {
        return this.toAjax(this.tmCallSourceService.save((Object)tmCallSource));
    }

    @ApiOperation(value="\u4fee\u6539\u547c\u53eb\u6e90")
    @Log(title="\u547c\u53eb\u6e90", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TmCallSource tmCallSource) {
        return this.toAjax(this.tmCallSourceService.updateById((Object)tmCallSource));
    }

    @ApiOperation(value="\u5220\u9664\u547c\u53eb\u6e90")
    @Log(title="\u547c\u53eb\u6e90", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        List reroutingConfigurations;
        List tmCallSources = this.tmCallSourceService.listByIds(Arrays.asList(ids));
        if (CollectionUtils.isEmpty((Collection)tmCallSources)) {
            return this.toAjax(true);
        }
        ArrayList nos = new ArrayList();
        tmCallSources.forEach(item -> nos.add(item.getCallSourceNo()));
        List sipUsers = this.iSipUserService.getSipUserByCallSourceNo(nos);
        if (CollectionUtils.isNotEmpty((Collection)sipUsers)) {
            return AjaxResult.error((String)MessageUtils.message((String)"TmCallSourceController.CallSource.tip1", (Object[])new Object[0]));
        }
        List gsEmergencyCalls = this.gsEmergencyCallService.getGsEmergencyCallByCallSourceNo(nos);
        if (CollectionUtils.isNotEmpty((Collection)gsEmergencyCalls)) {
            return AjaxResult.error((String)MessageUtils.message((String)"TmCallSourceController.CallSource.tip2", (Object[])new Object[0]));
        }
        List tmCallerPrefixConfigurations = this.tmCallerPrefixConfigurationService.getTmCallerPrefixConfigurationByCallSourceNo(nos);
        if (CollectionUtils.isNotEmpty((Collection)tmCallerPrefixConfigurations)) {
            return AjaxResult.error((String)MessageUtils.message((String)"TmCallSourceController.CallSource.tip3", (Object[])new Object[0]));
        }
        List queryTmGroupConfigs = this.tmGroupConfigService.queryTmGroupConfigs();
        if (CollectionUtils.isNotEmpty((Collection)queryTmGroupConfigs)) {
            for (QueryTmGroupConfig item2 : queryTmGroupConfigs) {
                if (!nos.contains(item2.getCallSourceNo())) continue;
                return AjaxResult.error((String)MessageUtils.message((String)"TmCallSourceController.CallSource.tip4", (Object[])new Object[0]));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(reroutingConfigurations = this.reroutingConfigurationService.getReroutingConfigurationByCallSourceNo(nos)))) {
            return AjaxResult.error((String)MessageUtils.message((String)"TmCallSourceController.CallSource.tip5", (Object[])new Object[0]));
        }
        List bearerTrunkConfigurations = this.bearerTrunkConfigurationService.getBearerTrunkConfigurationByCallSourceNo(nos);
        if (CollectionUtils.isNotEmpty((Collection)bearerTrunkConfigurations)) {
            return AjaxResult.error((String)MessageUtils.message((String)"TmCallSourceController.CallSource.tip6", (Object[])new Object[0]));
        }
        return this.toAjax(this.tmCallSourceService.removeByIds(Arrays.asList((Object[])ids.clone())));
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178")
    @GetMapping(value={"/init"})
    public AjaxResult init() {
        HashMap<String, List> result = new HashMap<String, List>(16);
        List rerouteCodeDict = this.tmCallSourceService.getRerouteCodeDict();
        result.put("rerouteCodeDict", rerouteCodeDict);
        return AjaxResult.success(result);
    }
}

