/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.trunkMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.ReroutingConfiguration;
import com.uscale.system.entity.TmOfficeRoute;
import com.uscale.system.model.reRouting.QueryReroutingConfiguration;
import com.uscale.system.service.ITmOfficeRouteService;
import com.uscale.system.service.ReroutingConfigurationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u91cd\u8def\u7531\u5206\u6790\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/trunkMng/reroutingConfiguration"})
public class ReroutingConfigurationController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReroutingConfigurationController.class);
    private static final Gson GSON = new Gson();
    private final ReroutingConfigurationService reroutingConfigurationService;
    private final ITmOfficeRouteService officeRouteService;

    @Autowired
    public ReroutingConfigurationController(ReroutingConfigurationService reroutingConfigurationService, ITmOfficeRouteService officeRouteService) {
        this.reroutingConfigurationService = reroutingConfigurationService;
        this.officeRouteService = officeRouteService;
    }

    @ApiOperation(value="\u67e5\u8be2\u91cd\u8def\u7531\u5206\u6790\u914d\u7f6e\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo<ReroutingConfiguration> list(QueryReroutingConfiguration queryReroutingConfiguration, Integer pageNum, Integer pageSize) {
        QueryWrapper wrapper = new QueryWrapper();
        if (!ObjectUtils.isEmpty((Object)queryReroutingConfiguration.getStartOfficeRouteSelectionCode())) {
            wrapper.ge((Object)"office_route_selection_code", (Object)queryReroutingConfiguration.getStartOfficeRouteSelectionCode());
        }
        if (!ObjectUtils.isEmpty((Object)queryReroutingConfiguration.getEndOfficeRouteSelectionCode())) {
            wrapper.le((Object)"office_route_selection_code", (Object)queryReroutingConfiguration.getEndOfficeRouteSelectionCode());
        }
        if (!ObjectUtils.isEmpty((Object)queryReroutingConfiguration.getStartRouteNo())) {
            wrapper.ge((Object)"routeNo", (Object)queryReroutingConfiguration.getStartRouteNo());
        }
        if (!ObjectUtils.isEmpty((Object)queryReroutingConfiguration.getEndRouteNo())) {
            wrapper.le((Object)"routeNo", (Object)queryReroutingConfiguration.getEndRouteNo());
        }
        if (!ObjectUtils.isEmpty((Object)queryReroutingConfiguration.getStartCallsourceNo())) {
            wrapper.ge((Object)"callSourceNo", (Object)queryReroutingConfiguration.getStartCallsourceNo());
        }
        if (!ObjectUtils.isEmpty((Object)queryReroutingConfiguration.getEndCallsourceNo())) {
            wrapper.le((Object)"callSourceNo", (Object)queryReroutingConfiguration.getEndCallsourceNo());
        }
        wrapper.orderByAsc((Object)"office_route_selection_code");
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.reroutingConfigurationService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u83b7\u53d6\u91cd\u8def\u7531\u5206\u6790\u914d\u7f6e\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult<ReroutingConfiguration> getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.reroutingConfigurationService.getById((Serializable)id));
    }

    @ApiOperation(value="\u83b7\u53d6\u5c40\u5411\u9009\u62e9\u7801\u5b57\u5178")
    @GetMapping(value={"/init"})
    public AjaxResult<Map<String, Object>> init() {
        return AjaxResult.success((Object)this.reroutingConfigurationService.init());
    }

    @ApiOperation(value="\u65b0\u589e\u91cd\u8def\u7531\u5206\u6790\u914d\u7f6e")
    @Log(title="\u91cd\u8def\u7531\u5206\u6790\u914d\u7f6e", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ReroutingConfiguration reroutingConfiguration) {
        if (reroutingConfiguration.getCallsourceno() == 0) {
            throw new RuntimeException(MessageUtils.message((String)"ReroutingConfigurationController.call.source0", (Object[])new Object[0]));
        }
        Integer officeRouteSelectionCode = reroutingConfiguration.getOfficeRouteSelectionCode();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TmOfficeRoute::getOfficeRouteSelectionCode, (Object)officeRouteSelectionCode);
        List tmOfficeRoutes = this.officeRouteService.list((Wrapper)wrapper);
        ArrayList list = new ArrayList();
        tmOfficeRoutes.forEach(tmOfficeRoute -> {
            ReroutingConfiguration configuration = new ReroutingConfiguration();
            BeanUtils.copyProperties((Object)reroutingConfiguration, (Object)configuration);
            configuration.setOfficeRouteid(tmOfficeRoute.getOfficeRouteId());
            list.add(configuration);
        });
        return this.toAjax(this.reroutingConfigurationService.saveBatch(list));
    }

    @ApiOperation(value="\u4fee\u6539\u91cd\u8def\u7531\u5206\u6790\u914d\u7f6e")
    @Log(title="\u91cd\u8def\u7531\u5206\u6790\u914d\u7f6e", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ReroutingConfiguration reroutingConfiguration) {
        return this.toAjax(this.reroutingConfigurationService.updateById((Object)reroutingConfiguration));
    }

    @ApiOperation(value="\u5220\u9664\u91cd\u8def\u7531\u5206\u6790\u914d\u7f6e")
    @Log(title="\u91cd\u8def\u7531\u5206\u6790\u914d\u7f6e", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        List<Object> list = Arrays.asList((Object[])ids.clone());
        List configurations = this.reroutingConfigurationService.listByIds(list);
        for (ReroutingConfiguration configuration : configurations) {
            Integer callsourceno = configuration.getCallsourceno();
            if (callsourceno != 0) continue;
            return AjaxResult.error((String)MessageUtils.message((String)"ReroutingConfigurationController.call.source", (Object[])new Object[0]));
        }
        return this.toAjax(this.reroutingConfigurationService.removeByIds(list));
    }
}

