/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng.deviceMng;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.service.ClusterInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8bbe\u5907\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/systemMng/deviceMng"})
public class SysSystemRebootController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysSystemRebootController.class);
    private final ClusterInfoService clusterInfoService;

    @Autowired
    public SysSystemRebootController(ClusterInfoService clusterInfoService) {
        this.clusterInfoService = clusterInfoService;
    }

    @ApiOperation(value="\u7cfb\u7edf\u91cd\u542f")
    @Log(title="\u8bbe\u5907\u7ba1\u7406:\u7cfb\u7edf\u91cd\u542f", businessType=BusinessType.OTHER)
    @PostMapping(value={"/reboot"})
    public AjaxResult reboot() {
        LOGGER.debug("\u7cfb\u7edf\u91cd\u542f...");
        int count = this.clusterInfoService.getClusterCount();
        if (count == 3) {
            return AjaxResult.error();
        }
        String[] cmds = new String[]{"sync", "sync", "reboot"};
        try {
            for (String cmd : cmds) {
                Process process = Runtime.getRuntime().exec(cmd);
            }
            LOGGER.debug("\u7cfb\u7edf\u6b63\u5728\u91cd\u542f");
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u7cfb\u7edf\u91cd\u542f\u5f02\u5e38 -> {}", (Throwable)e);
            return AjaxResult.error((String)MessageUtils.message((String)"system.reboot.exception", (Object[])new Object[0]));
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return AjaxResult.operateSuccess();
    }

    @ApiOperation(value="\u5224\u65ad1981\u7cfb\u7edf\u91cd\u542f")
    @GetMapping(value={"/isReboot"})
    public AjaxResult isReboot() {
        int count = this.clusterInfoService.getClusterCount();
        return AjaxResult.success((Object)(count == 3 ? 1 : 0));
    }
}

