/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.config.TydicConfig;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.file.FileUploadUtils;
import com.uscale.common.utils.file.MimeTypeUtils;
import com.uscale.framework.config.ServerConfig;
import com.uscale.system.entity.SmVuCustomizedBoardConfig;
import com.uscale.system.service.ISmVuCustomizedBoardConfigService;
import com.uscale.web.controller.systemMng.SmScriptManageController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u81ea\u5b9a\u4e49\u603b\u673a"})
@RestController
@RequestMapping(value={"/systemMng/smVuBoard"})
public class SmVuCustomizedBoardConfigController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmScriptManageController.class);
    private final ServerConfig serverConfig;
    private final ISmVuCustomizedBoardConfigService smVuCustomizedBoardConfigService;

    @Autowired
    public SmVuCustomizedBoardConfigController(ServerConfig serverConfig, ISmVuCustomizedBoardConfigService smVuCustomizedBoardConfigService) {
        this.serverConfig = serverConfig;
        this.smVuCustomizedBoardConfigService = smVuCustomizedBoardConfigService;
    }

    @ApiOperation(value="\u67e5\u8be2\u811a\u672c\u5217\u8868")
    @GetMapping(value={"/queryConfig"})
    public TableDataInfo queryScript(@ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u6761\u6570") Integer pageSize) {
        QueryWrapper wrapper = new QueryWrapper();
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.smVuCustomizedBoardConfigService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u5220\u9664\u811a\u672c")
    @Log(title="\u81ea\u5b9a\u4e49\u603b\u673a:\u5220\u9664\u811a\u672c", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult<Boolean> deleteScript(@ApiParam(value="ID") @PathVariable(value="ids") List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return AjaxResult.error();
        }
        return AjaxResult.success((Object)this.smVuCustomizedBoardConfigService.removeByIds(ids));
    }

    @ApiOperation(value="\u52a0\u8f7d\u811a\u672c")
    @Log(title="\u81ea\u5b9a\u4e49\u603b\u673a:\u52a0\u8f7d\u811a\u672c", businessType=BusinessType.INSERT)
    @PostMapping(value={"/loadScript"})
    @Transactional(rollbackFor={Exception.class})
    public AjaxResult<Object> loadScript(@ApiParam(value="\u6587\u4ef6") MultipartFile file, @ApiParam(value="\u662f\u5426\u5141\u8bb8\u8986\u76d6") @RequestParam(value="override") String override) throws Exception {
        try {
            String filePath = TydicConfig.getUploadPath();
            LOGGER.debug("\u81ea\u5b9a\u4e49\u603b\u673a\u811a\u672c\u4e0a\u4f20,fileName=[{}]", (Object)file.getOriginalFilename());
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"file_name", (Object)file.getOriginalFilename());
            SmVuCustomizedBoardConfig config = (SmVuCustomizedBoardConfig)this.smVuCustomizedBoardConfigService.getOne((Wrapper)wrapper);
            String notOverride = "no";
            if (!ObjectUtils.isEmpty((Object)config) && notOverride.equals(override)) {
                return AjaxResult.error((String)MessageUtils.message((String)"vu.customized.board.config.script.exist", (Object[])new Object[0]));
            }
            String fileName = FileUploadUtils.upload((String)filePath, (MultipartFile)file, (String[])MimeTypeUtils.CUSTOMIZE_BOARD);
            String url = this.serverConfig.getUrl() + fileName;
            if (ObjectUtils.isEmpty((Object)config)) {
                config = new SmVuCustomizedBoardConfig();
            }
            config.setFileName(file.getOriginalFilename());
            config.setFileSize(String.valueOf(file.getSize()));
            config.setEncodeName(fileName);
            config.setDownloadUrl(url);
            this.smVuCustomizedBoardConfigService.saveOrUpdate((Object)config);
            return AjaxResult.success();
        }
        catch (IOException e) {
            return AjaxResult.error((String)e.getMessage());
        }
    }
}

