/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.tool.CmdTool;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.JedisPool;

@Api(tags={"\u7248\u672c\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/systemMng/version"})
public class SmVersionController {
    private static final String PRODUCT_DIR = "/datacenter/product";
    private static final String PRODUCT_INFO = "product-info.conf";
    private static final String PRODUCT_INFO_PATH = "/datacenter/product" + File.separator + "product-info.conf";
    @Value(value="${asterisk.conf.device-info}")
    private String deviceInfo;
    @Value(value="${asterisk.conf.firmware-info}")
    private String firmwareInfo;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final JedisPool jedisPool;

    @Autowired
    public SmVersionController(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @ApiOperation(value="\u83b7\u53d6\u7248\u672c\u4fe1\u606f")
    @GetMapping
    public AjaxResult<Map<String, String>> getVersionInfo() {
        HashMap<String, String> versionInfo = new HashMap<String, String>(16);
        try {
            String[] confs;
            this.LOGGER.debug("\u83b7\u53d6 {} \u6587\u4ef6\u4fe1\u606f", (Object)this.deviceInfo);
            BufferedReader br = new BufferedReader(new FileReader(this.deviceInfo));
            String str = null;
            while ((str = br.readLine()) != null) {
                confs = str.split("=");
                if (confs.length != 2) continue;
                this.LOGGER.debug("\u83b7\u53d6device\u4fe1\u606f\uff0ckey=[{}], value=[{}]", (Object)confs[0], (Object)confs[1]);
                versionInfo.put(confs[0], confs[1].replaceAll("\"", ""));
            }
            this.LOGGER.debug("\u83b7\u53d6 {} \u6587\u4ef6\u4fe1\u606f", (Object)this.firmwareInfo);
            br = new BufferedReader(new FileReader(this.firmwareInfo));
            while ((str = br.readLine()) != null) {
                confs = str.split("=");
                if (confs.length != 2) continue;
                this.LOGGER.debug("\u83b7\u53d6firmware\u4fe1\u606f\uff0ckey=[{}], value=[{}]", (Object)confs[0], (Object)confs[1]);
                versionInfo.put(confs[0], confs[1].replaceAll("\"", ""));
            }
            String MODEL_NAME = CmdTool.execReadShell((String)("grep \"MODEL_NAME\" " + PRODUCT_INFO_PATH + " | awk -F'=' '{print $2}'"));
            versionInfo.put("USCALE_PLATFORM", MODEL_NAME);
        }
        catch (IOException e) {
            return AjaxResult.error((String)MessageUtils.message((String)"version.read.file.error", (Object[])new Object[0]));
        }
        return AjaxResult.success(versionInfo);
    }
}

