/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.exception.file.ConfFileException;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.file.FileUploadUtils;
import com.uscale.common.utils.file.FileUtils;
import com.uscale.system.entity.TmTrunkFile;
import com.uscale.system.service.TmTrunkFileService;
import com.uscale.system.vo.TmTrunkFileVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u4e2d\u7ee7\u8bc1\u4e66\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/systemMng/trunkFile"})
public class SmTmTrunkFileController
extends BaseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final TmTrunkFileService trunkFileService;
    private static final String TRUNK_FILE_PATH = System.getProperty("os.name").toLowerCase().contains("linux") ? "/uscale/etc/keys/PEERDOMAIN/" : "D:/uscale/etc/keys/PEERDOMAIN/";
    private static final String CA = "ca.pem";
    private static final String PEM = "pbx_client.pem";
    private static final String CRT = "pbx_server.crt";
    private static final String KEY = "pbx_server.key";
    @Value(value="${asterisk.licensePath}")
    private String licensePath;
    @Value(value="${asterisk.licensePathWin}")
    private String licensePathWin;

    @Autowired
    public SmTmTrunkFileController(TmTrunkFileService trunkFileService) {
        this.trunkFileService = trunkFileService;
    }

    @ApiOperation(value="\u8bc1\u4e66\u4fe1\u606f\u5217\u8868")
    @PostMapping(value={"/page/{page}/{size}"})
    public TableDataInfo page(@ApiParam(value="\u9875\u6570") @PathVariable Integer page, @ApiParam(value="\u6761\u6570") @PathVariable Integer size, @RequestBody TmTrunkFile trunkFile) {
        Page pageData = new Page((long)page.intValue(), (long)size.intValue());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        String peerDomain = trunkFile.getPeerDomain();
        if (StringUtils.isNotBlank((CharSequence)peerDomain)) {
            wrapper.like(TmTrunkFile::getPeerDomain, (Object)peerDomain);
        }
        return this.getDataTable((Page)this.trunkFileService.page((IPage)pageData, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u8bc1\u4e66\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult<TmTrunkFile> get(@ApiParam(value="id") @PathVariable Long id) {
        return AjaxResult.success((Object)this.trunkFileService.getById((Serializable)id));
    }

    @ApiOperation(value="\u590d\u5236\u672c\u5730\u8bc1\u4e66")
    @GetMapping(value={"/copy/{peerDomain}"})
    public AjaxResult<Object> copyLocalFile(@PathVariable String peerDomain) {
        String trunkFilePath = TRUNK_FILE_PATH.replace("PEERDOMAIN", peerDomain);
        InputStreamReader fr = null;
        OutputStreamWriter fw = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            String str;
            File file = new File(this.getFilePath().replace("keys/", "keys"));
            if (!file.exists()) {
                throw new RuntimeException("\u672c\u5730\u8bc1\u4e66\u4e0d\u5b58\u5728");
            }
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                throw new RuntimeException(MessageUtils.message((String)"trunk.file.local.certificate.absent", (Object[])new Object[0]));
            }
            org.apache.commons.io.FileUtils.copyDirectory((File)new File(this.getFilePath().replace("keys/", "keys")), (File)new File(TRUNK_FILE_PATH.replace("PEERDOMAIN/", peerDomain)));
            File pbxClientPmFile = new File(trunkFilePath + PEM);
            if (!pbxClientPmFile.exists()) {
                throw new RuntimeException(MessageUtils.message((String)"trunk.file.pbx.empty", (Object[])new Object[0]));
            }
            File pbxClientFile = new File(trunkFilePath + "pbx_client.key");
            if (!pbxClientFile.exists()) {
                pbxClientFile.createNewFile();
            }
            fr = new FileReader(pbxClientPmFile);
            fw = new FileWriter(pbxClientFile);
            br = new BufferedReader(fr);
            bw = new BufferedWriter(fw);
            boolean beginCopy = false;
            while ((str = br.readLine()) != null) {
                if ("-----BEGIN RSA PRIVATE KEY-----".equals(str)) {
                    beginCopy = true;
                }
                if (!beginCopy) continue;
                bw.write(str);
                bw.newLine();
            }
            bw.flush();
        }
        catch (IOException e) {
            this.LOGGER.error("\u590d\u5236\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(MessageUtils.message((String)"trunk.file.copy.fail", (Object[])new Object[0]));
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        TmTrunkFile trunkFile = new TmTrunkFile();
        trunkFile.setPeerDomain(peerDomain);
        this.trunkFileService.save((Object)trunkFile);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u4e0a\u4f20\u8bc1\u4e66")
    @Log(title="\u4e2d\u7ee7\u8bc1\u4e66\u4fe1\u606f(\u4e0a\u4f20)", businessType=BusinessType.IMPORT)
    @PostMapping(value={"upload"})
    public AjaxResult<Object> upload(TmTrunkFileVO trunkFileVO) {
        MultipartFile pemFile = trunkFileVO.getPemFile();
        MultipartFile clientPemFile = trunkFileVO.getClientPemFile();
        MultipartFile crtFile = trunkFileVO.getCrtFile();
        MultipartFile keyFile = trunkFileVO.getKeyFile();
        if (pemFile == null || clientPemFile == null || crtFile == null || keyFile == null) {
            return AjaxResult.error((String)MessageUtils.message((String)"trunk.file.incomplete", (Object[])new Object[0]));
        }
        String peerDomain = trunkFileVO.getPeerDomain();
        if (StringUtils.isBlank((CharSequence)peerDomain)) {
            throw new RuntimeException(MessageUtils.message((String)"trunk.file.peerdomain.empty", (Object[])new Object[0]));
        }
        String trunkFilePath = TRUNK_FILE_PATH.replace("PEERDOMAIN", peerDomain);
        InputStreamReader fr = null;
        OutputStreamWriter fw = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            String str;
            pemFile.transferTo(FileUploadUtils.getAbsoluteFile((String)trunkFilePath, (String)pemFile.getOriginalFilename()));
            clientPemFile.transferTo(FileUploadUtils.getAbsoluteFile((String)trunkFilePath, (String)clientPemFile.getOriginalFilename()));
            crtFile.transferTo(FileUploadUtils.getAbsoluteFile((String)trunkFilePath, (String)crtFile.getOriginalFilename()));
            keyFile.transferTo(FileUploadUtils.getAbsoluteFile((String)trunkFilePath, (String)keyFile.getOriginalFilename()));
            File file = new File(trunkFilePath + clientPemFile.getOriginalFilename());
            File pbxClientFile = new File(trunkFilePath + "pbx_client.key");
            fr = new FileReader(file);
            fw = new FileWriter(pbxClientFile);
            br = new BufferedReader(fr);
            bw = new BufferedWriter(fw);
            boolean beginCopy = false;
            while ((str = br.readLine()) != null) {
                if ("-----BEGIN RSA PRIVATE KEY-----".equals(str)) {
                    beginCopy = true;
                }
                if (!beginCopy) continue;
                bw.write(str);
                bw.newLine();
            }
            bw.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(MessageUtils.message((String)"upload.file.exception", (Object[])new Object[0]));
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        trunkFileVO.setCaListFile(pemFile.getOriginalFilename());
        trunkFileVO.setCertFile(crtFile.getOriginalFilename());
        trunkFileVO.setPrivKeyFile(keyFile.getOriginalFilename());
        TmTrunkFile trunkFile = new TmTrunkFile();
        BeanUtils.copyProperties((Object)trunkFileVO, (Object)trunkFile);
        Long id = trunkFile.getId();
        if (id == null) {
            this.trunkFileService.save((Object)trunkFile);
        } else {
            this.trunkFileService.updateById((Object)trunkFile);
        }
        return AjaxResult.success();
    }

    @ApiOperation(value="\u4e0b\u8f7d\u8bc1\u4e66")
    @GetMapping(value={"download/{peerDomain}/{name}"})
    public void download(@PathVariable String name, @PathVariable String peerDomain, HttpServletResponse response) {
        try {
            if (!com.uscale.common.utils.StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{CA, PEM, CRT, KEY})) {
                throw new RuntimeException(MessageUtils.message((String)"trunk.file.download.name.error", (Object[])new Object[0]));
            }
            String trunkFilePath = TRUNK_FILE_PATH.replace("PEERDOMAIN", peerDomain);
            response.setContentType("application/octet-stream; charset=UTF-8");
            FileUtils.writeBytes((String)(trunkFilePath + name), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            this.LOGGER.error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    @ApiOperation(value="\u5220\u9664\u8bc1\u4e66")
    @Log(title="\u4e2d\u7ee7\u8bc1\u4e66\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult<Object> remove(@PathVariable List<Long> ids) throws ConfFileException {
        this.trunkFileService.delete(ids);
        return AjaxResult.success();
    }

    public String getFilePath() {
        if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            return this.licensePath;
        }
        return this.licensePathWin;
    }

    @ApiOperation(value="\u83b7\u53d6\u8bc1\u4e66\u72b6\u6001")
    @GetMapping(value={"fileInfo/{peerDomain}"})
    public AjaxResult<Map<String, Boolean>> fileInfo(@PathVariable String peerDomain) {
        String trunkFilePath = TRUNK_FILE_PATH.replace("PEERDOMAIN", peerDomain);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (new File(trunkFilePath + CA).exists()) {
            map.put("pemFileList", true);
        }
        if (new File(trunkFilePath + PEM).exists()) {
            map.put("clientPemFileList", true);
        }
        if (new File(trunkFilePath + CRT).exists()) {
            map.put("crtFileList", true);
        }
        if (new File(trunkFilePath + KEY).exists()) {
            map.put("keyFileList", true);
        }
        return AjaxResult.success(map);
    }
}

