/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.service.ISmTimeConfigNtpServerService;
import com.uscale.system.service.SysConfigInfoService;
import com.uscale.system.tool.CmdTool;
import com.uscale.system.vo.NTPDateTimeVo;
import com.uscale.system.vo.NtpInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u65f6\u95f4\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/systemMng/timeConfig"})
public class SmTimeConfigController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmTimeConfigController.class);
    private static final Gson GSON = new Gson();
    private static final Pattern TIME_CONFIG_PATTERN = Pattern.compile("(?<localTime>(.+(?=\\+)))(?<timeZone>\\+\\d+)$");
    private static final String etc_chrony = "/etc/chrony.conf";
    private static final String chrony_start = "server";
    private static final String chrony_end = "iburst";
    private static final String stop_cli1 = "systemctl disable chronyd";
    private static final String stop_cli2 = "systemctl stop chronyd";
    private static final String stop_cli3 = "timedatectl set-ntp false";
    private static final String start_cli1 = "systemctl enable chronyd";
    private static final String start_cli2 = "systemctl restart chronyd";
    private static final String start_cli3 = "timedatectl set-ntp true";
    private static final String read_server = "awk '/^server (.*) iburst$/{print}' /etc/chrony.conf";
    private static final String read_allow = "awk '/^allow (.*)/{print}' /etc/chrony.conf";
    private final ISmTimeConfigNtpServerService smTimeConfigNtpServerService;
    private final SysConfigInfoService sysConfigInfoService;

    @Autowired
    public SmTimeConfigController(ISmTimeConfigNtpServerService smTimeConfigNtpServerService, SysConfigInfoService sysConfigInfoService) {
        this.smTimeConfigNtpServerService = smTimeConfigNtpServerService;
        this.sysConfigInfoService = sysConfigInfoService;
    }

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u65f6\u95f4")
    @GetMapping(value={"/querySystemDateTime"})
    public AjaxResult<NTPDateTimeVo> getDateTime() {
        return AjaxResult.success((Object)this.sysConfigInfoService.getDateTime());
    }

    @ApiOperation(value="\u8bbe\u7f6e\u7cfb\u7edf\u65f6\u95f4")
    @PostMapping(value={"/setSystemTime"})
    @Log(title="\u65f6\u95f4\u914d\u7f6e", businessType=BusinessType.UPDATE)
    public AjaxResult<Object> setDateTime(@RequestBody NTPDateTimeVo timeConfig) {
        return AjaxResult.success((Object)this.sysConfigInfoService.setDateTime(timeConfig));
    }

    public AjaxResult<Object> setSystemTime(@ApiIgnore @RequestBody Map<String, String> timeConfig) {
        String localTime = timeConfig.get("localTime");
        String timeZone = timeConfig.get("timeZone");
        LOGGER.debug("\u8bbe\u7f6e\u7cfb\u7edf\u65f6\u95f4\uff0c\u63a5\u6536\u5230\u53c2\u6570\u4e3a\uff1atimeConfig=[{}]", (Object)GSON.toJson(timeConfig));
        if (ObjectUtils.isEmpty((Object)localTime) || ObjectUtils.isEmpty((Object)timeZone)) {
            return AjaxResult.error((String)MessageUtils.message((String)"time.config.params.empty", (Object[])new Object[0]));
        }
        String set_timeZone = "timedatectl set-timezone " + timeZone;
        String set_localTime = "timedatectl set-time '" + localTime + "'";
        LOGGER.debug("\u8bbe\u7f6e\u65f6\u65f6\u533a\uff1a{}", (Object)set_timeZone);
        LOGGER.debug("\u8bbe\u7f6e\u65f6\u95f4\uff1a{}", (Object)set_localTime);
        String[] cmds = new String[]{stop_cli1, stop_cli2, stop_cli3, set_timeZone, set_localTime};
        try {
            CmdTool.execShell((String[])cmds);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u8bbe\u7f6e\u65f6\u95f4\u51fa\u9519\uff1a{}", (Throwable)e);
            return AjaxResult.error((String)MessageUtils.message((String)"time.config.set.error", (Object[])new Object[0]));
        }
        return AjaxResult.success();
    }

    @ApiOperation(value="\u67e5\u8be2NTP")
    @GetMapping(value={"/queryNtpConfig"})
    public AjaxResult<NtpInfoVo> getNtpInfo() {
        return AjaxResult.success((Object)this.sysConfigInfoService.getNtpInfo());
    }

    public AjaxResult<Map<String, String>> queryNtpConfig() {
        String ntp_status_active_sign = "Active: active";
        String ntp_status_cmd = "systemctl status chronyd";
        String ntp_status_active_content = CmdTool.execReadToLine((String)ntp_status_cmd, (String)ntp_status_active_sign);
        LOGGER.debug("\u68c0\u6d4b\u5f53\u524dNTP\u662f\u5426\u5f00\u542f\uff1a{}", (Object)ntp_status_active_content);
        String ntpTimeSyncCli = "off";
        if (StringUtils.isNotBlank((CharSequence)ntp_status_active_content)) {
            ntpTimeSyncCli = "on";
        }
        String sync_status_cmd = "chronyc ntpdata";
        String sync_status_sign = "Remote address";
        String syncStatus = MessageUtils.message((String)"time.config.sync.fail", (Object[])new Object[0]);
        String sync_status_content = CmdTool.execReadToLine((String)sync_status_cmd, (String)sync_status_sign);
        LOGGER.debug("\u68c0\u67e5\u5f53\u524d\u662f\u5426\u5df2\u540c\u6b65\uff1a{}", (Object)sync_status_content);
        if (StringUtils.isNotBlank((CharSequence)sync_status_content)) {
            syncStatus = MessageUtils.message((String)"time.config.sync.success", (Object[])new Object[0]);
        }
        List chronys = null;
        try {
            chronys = CmdTool.execReadToArrayShell((String)read_server);
            LOGGER.debug("\u65f6\u95f4\u670d\u52a1\u4fe1\u606f\uff1a{}", (Object)chronys.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.debug("\u8bfb\u53d6\u65f6\u95f4\u670d\u52a1\u4fe1\u606f\u9519\u8bef\uff1a{}", (Throwable)e);
        }
        String mainServerIpAddress = "";
        String mainServerPort = "";
        String bakServerIpAddress = "";
        String bakServerPort = "";
        if (chronys != null && chronys.size() > 0) {
            for (int i = 0; i < chronys.size(); ++i) {
                if (i == 0) {
                    String[] chronys1 = this.formatChronys((String)chronys.get(i));
                    mainServerIpAddress = chronys1[0];
                    mainServerPort = chronys1[1];
                    continue;
                }
                if (i != 1) break;
                String[] chronys2 = this.formatChronys((String)chronys.get(i));
                bakServerIpAddress = chronys2[0];
                bakServerPort = chronys2[1];
            }
        }
        String ntpTimeSync = "off";
        List allows = null;
        try {
            allows = CmdTool.execReadToArrayShell((String)read_allow);
            LOGGER.debug("\u670d\u52a1\u7aef\u5f00\u542f\u4fe1\u606f\uff1a{}", (Object)allows.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.debug("\u8bfb\u53d6\u670d\u52a1\u7aef\u5f00\u542f\u4fe1\u606f\u9519\u8bef\uff1a{}", (Throwable)e);
        }
        ntpTimeSync = allows != null && allows.size() > 0 ? "on" : "off";
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("ntpTimeSyncCli", ntpTimeSyncCli);
        map.put("ntpTimeSync", ntpTimeSync);
        map.put("syncStatus", syncStatus);
        map.put("mainServerIpAddress", mainServerIpAddress);
        map.put("mainServerPort", mainServerPort);
        map.put("bakServerIpAddress", bakServerIpAddress);
        map.put("bakServerPort", bakServerPort);
        return AjaxResult.success(map);
    }

    @PostMapping(value={"/setNtpConfig"})
    @Log(title="NTP\u914d\u7f6e", businessType=BusinessType.UPDATE)
    public AjaxResult<Object> setNtpConfig(@RequestBody NtpInfoVo config) {
        return this.toAjax(this.sysConfigInfoService.saveOrUpdateNtpInfo(config));
    }

    @ApiOperation(value="\u8bbe\u7f6eNTP")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ntpTimeSyncCli", value="NTP\u5ba2\u6237\u7aef", required=true, dataType="String"), @ApiImplicitParam(name="ntpTimeSync", value="NTP\u670d\u52a1\u7aef", required=true, dataType="String"), @ApiImplicitParam(name="mainServerIpAddress", value="\u4e3b\u670d\u52a1\u5668\u5730\u5740", required=true, dataType="String"), @ApiImplicitParam(name="mainServerPort", value="\u4e3b\u670d\u52a1\u5668\u7aef\u53e3", required=true, dataType="String"), @ApiImplicitParam(name="bakServerIpAddress", value="\u5907\u670d\u52a1\u5668\u5730\u5740", required=true, dataType="String"), @ApiImplicitParam(name="bakServerPort", value="\u5907\u670d\u52a1\u5668\u7aef\u53e3", required=true, dataType="String")})
    public AjaxResult<Object> setNtpConfig(@ApiIgnore @RequestBody Map<String, String> config) {
        String ntpTimeSyncCli = config.get("ntpTimeSyncCli");
        String ntpTimeSync = config.get("ntpTimeSync");
        String mainServerIpAddress = config.get("mainServerIpAddress");
        String mainServerPort = config.get("mainServerPort");
        String bakServerIpAddress = config.get("bakServerIpAddress");
        String bakServerPort = config.get("bakServerPort");
        if (StringUtils.isBlank((CharSequence)mainServerIpAddress)) {
            return AjaxResult.error((String)MessageUtils.message((String)"time.config.master.server.empty", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)mainServerPort)) {
            return AjaxResult.error((String)MessageUtils.message((String)"time.config.master.server.port.empty", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)bakServerIpAddress) && StringUtils.isBlank((CharSequence)bakServerPort)) {
            return AjaxResult.error((String)MessageUtils.message((String)"time.config.slave.server.port.empty", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)"on", (CharSequence)ntpTimeSyncCli)) {
            try {
                String master = "server " + mainServerIpAddress + " port " + mainServerPort + " " + chrony_end;
                String bak = "";
                if (StringUtils.isNotBlank((CharSequence)bakServerIpAddress)) {
                    bak = "server " + bakServerIpAddress + " port " + bakServerPort + " " + chrony_end;
                }
                boolean isNtpSer = false;
                isNtpSer = StringUtils.equals((CharSequence)"on", (CharSequence)ntpTimeSync);
                this.updateServerInfo(etc_chrony, master, bak, isNtpSer);
                this.openNtpCli();
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.error("\u5f00\u542fNTP\u670d\u52a1\u5668\u51fa\u9519\uff1a{}", (Throwable)e);
                return AjaxResult.error((String)MessageUtils.message((String)"time.config.start.ntp.error", (Object[])new Object[0]));
            }
        }
        try {
            this.closeNtpCli();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u5173\u95edNTP\u670d\u52a1\u5668\u51fa\u9519\uff1a{}", (Throwable)e);
            return AjaxResult.error((String)MessageUtils.message((String)"time.config.close.ntp.error", (Object[])new Object[0]));
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            LOGGER.error("\u7b49\u5f85\uff1a{}", (Throwable)e);
        }
        return AjaxResult.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServerInfo(String path, String master, String bak, boolean isNtpSer) throws IOException {
        StringBuffer result = new StringBuffer();
        File file = new File(path);
        if (file.exists()) {
            BufferedReader br = null;
            FileOutputStream outputStream = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String lin = null;
                while ((lin = br.readLine()) != null) {
                    if (lin.startsWith("allow ") || lin.startsWith("server ")) continue;
                    result.append(lin).append(System.lineSeparator());
                }
                if (StringUtils.isNotBlank((CharSequence)master)) {
                    result.append(master).append(System.lineSeparator());
                }
                if (StringUtils.isNotBlank((CharSequence)bak)) {
                    result.append(bak).append(System.lineSeparator());
                }
                if (isNtpSer) {
                    result.append("allow 0/0").append(System.lineSeparator());
                }
                br.close();
                br = null;
                outputStream = new FileOutputStream(file);
                outputStream.write(result.toString().getBytes());
                outputStream.close();
                outputStream = null;
            }
            finally {
                if (br != null) {
                    br.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
    }

    private String[] formatChronys(String chronys) {
        chronys = chronys.replace(System.getProperty("line.separator"), "").trim().substring(chronys.indexOf(chrony_start) + 6, chronys.lastIndexOf(chrony_end));
        String[] ports = chronys.split("port");
        String[] result = new String[2];
        if (ports != null && ports.length > 0) {
            if (ports.length > 1) {
                result[0] = ports[0].trim();
                result[1] = ports[1].trim();
            } else {
                result[0] = ports[0].trim();
                result[1] = "123";
            }
        } else {
            result[0] = "";
            result[1] = "123";
        }
        return result;
    }

    private void closeNtpCli() throws IOException {
        String[] cmds = new String[]{stop_cli1, stop_cli2, stop_cli3};
        CmdTool.execShell((String[])cmds);
        LOGGER.debug("\u5173\u95edNIP\u5ba2\u6237\u7aef");
    }

    private void openNtpCli() throws IOException {
        String[] cmds = new String[]{start_cli1, start_cli2, start_cli3};
        CmdTool.execShell((String[])cmds);
        LOGGER.debug("\u6253\u5f00NTP\u5ba2\u6237\u7aef");
    }
}

