/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.service.ClusterInfoService;
import com.uscale.system.tool.CmdTool;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u8f6f\u4ef6\u5347\u7ea7"})
@RestController
@RequestMapping(value={"/systemMng/softwareUpgrade"})
public class SmSoftwareUpgradeController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmSoftwareUpgradeController.class);
    private final String BACKUP_UPLOAD_PATH = "/datacenter/update/upload";
    private final ClusterInfoService clusterInfoService;

    public SmSoftwareUpgradeController(ClusterInfoService clusterInfoService) {
        this.clusterInfoService = clusterInfoService;
    }

    @ApiOperation(value="\u662f\u5426\u5237\u65b0")
    @GetMapping(value={"/refresh"})
    public AjaxResult refresh() {
        return AjaxResult.success();
    }

    @ApiOperation(value="\u5347\u7ea7")
    @GetMapping(value={"/upgrade"})
    public AjaxResult<Object> upgrade() {
        try {
            int count = this.clusterInfoService.getClusterCount();
            if (count == 3) {
                return AjaxResult.error((String)MessageUtils.message((String)"software.upgrade.two.fail", (Object[])new Object[0]));
            }
            File file = new File("/datacenter/update/upload");
            String upload_cmd1 = "echo \"/datacenter/update/upload/" + file.listFiles()[0].getName() + "\" > /datacenter/update/NEED_UPDATE";
            CmdTool.execShell((String)upload_cmd1);
            String upload_cmd2 = "uscale-update checkfile;echo $?";
            String state = CmdTool.execReadShell((String)upload_cmd2);
            LOGGER.info("====\u6267\u884c\u8fd4\u56de\u503c\uff1a" + state);
            if (!StringUtils.equals((CharSequence)"0", (CharSequence)state)) {
                return AjaxResult.error((String)MessageUtils.message((String)"software.upgrade.file.invalid", (Object[])new Object[0]));
            }
            new Thread(() -> {
                try {
                    Thread.sleep(3000L);
                    String upload_cmd3 = "sync; sync; sleep 2; reboot;";
                    CmdTool.execShell((String)upload_cmd3);
                }
                catch (Exception e) {
                    LOGGER.error("\u5347\u7ea7\u5931\u8d25:{}", (Object)e.getMessage());
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5347\u7ea7\u5f02\u5e38:{}", (Throwable)e);
            return AjaxResult.error((String)MessageUtils.message((String)"software.upgrade.error", (Object[])new Object[0]));
        }
        return AjaxResult.success((String)MessageUtils.message((String)"software.upgrade.reboot", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4e0a\u4f20")
    @Log(title="\u8f6f\u4ef6\u5347\u7ea7(\u4e0a\u4f20)", businessType=BusinessType.IMPORT)
    @PostMapping(value={"/uploadUpgrade"})
    public AjaxResult<HashMap<String, Object>> uploadUpgrade(@ApiParam(value="\u6587\u4ef6") @RequestParam(value="file") MultipartFile file, @ApiParam(value="fileName") @RequestParam(value="fileName") String fileName, @ApiParam(value="\u5f00\u59cb\u4f4d\u7f6e") @RequestParam(value="shardIndex") String shardIndex, @ApiParam(value="\u603b\u957f\u5ea6") @RequestParam(value="shardTotal") String shardTotal) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (file.isEmpty()) {
            result.put("status", "error");
            result.put("msg", MessageUtils.message((String)"software.upgrade.file.empty", (Object[])new Object[0]));
            return AjaxResult.success(result);
        }
        if (StringUtils.isBlank((CharSequence)fileName) || StringUtils.isBlank((CharSequence)shardIndex) || StringUtils.isBlank((CharSequence)shardTotal) || !fileName.endsWith(".bin")) {
            result.put("status", "error");
            result.put("msg", MessageUtils.message((String)"software.upgrade.file.error", (Object[])new Object[0]));
            return AjaxResult.success(result);
        }
        File uploadDir = new File("/datacenter/update/upload");
        try {
            if (Integer.parseInt(shardIndex) == 1) {
                FileUtils.deleteDirectory((File)uploadDir);
                uploadDir.mkdirs();
            }
            String uploadPath = "/datacenter/update/upload" + File.separator + shardIndex + "_" + fileName;
            File uploadFile = new File(uploadPath);
            this.upload(file.getInputStream(), uploadFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u4e0a\u4f20\u5931\u8d25:{}", (Throwable)e);
            try {
                FileUtils.deleteDirectory((File)uploadDir);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            result.put("status", "error");
            result.put("msg", MessageUtils.message((String)"software.upgrade.fail", (Object[])new Object[0]));
            return AjaxResult.success(result);
        }
        if (Integer.parseInt(shardIndex) < Integer.parseInt(shardTotal)) {
            result.put("status", "next");
            result.put("msg", MessageUtils.message((String)"software.upgrade.success.next", (Object[])new Object[0]));
            return AjaxResult.success(result);
        }
        if (Integer.parseInt(shardIndex) == Integer.parseInt(shardTotal)) {
            File[] files = null;
            try {
                files = this.merge("/datacenter/update/upload", fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.error("\u5408\u5e76\u6587\u4ef6\u5f02\u5e38:{}", (Throwable)e);
                result.put("status", "error");
                result.put("msg", MessageUtils.message((String)"software.upgrade.merge.fail", (Object[])new Object[0]));
                AjaxResult ajaxResult = AjaxResult.success(result);
                return ajaxResult;
            }
            finally {
                this.deleteFile(files);
            }
            result.put("status", "success");
            result.put("msg", MessageUtils.message((String)"upload.success", (Object[])new Object[0]));
            return AjaxResult.success(result);
        }
        return AjaxResult.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(InputStream fromFileStream, File toFile) throws IOException {
        InputStream fis = fromFileStream;
        try (FileOutputStream os = new FileOutputStream(toFile);){
            int length;
            byte[] b = new byte[1024];
            while ((length = fis.read(b)) > 0) {
                ((OutputStream)os).write(b, 0, length);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public File[] merge(String path, String fileName) throws IOException {
        File file = new File(path);
        File[] files = file.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        List<File> listFiles = Arrays.asList(files);
        listFiles.sort((Comparator<File>)new /* Unavailable Anonymous Inner Class!! */);
        File newFile = new File(path + File.separator + fileName);
        if (newFile.exists()) {
            newFile.delete();
        }
        try (FileOutputStream outputStream = new FileOutputStream(newFile, true);){
            byte[] b = new byte[1024];
            for (File f : listFiles) {
                FileInputStream fileInputStream = new FileInputStream(f);
                Throwable throwable = null;
                try {
                    int length;
                    while ((length = fileInputStream.read(b)) > 0) {
                        outputStream.write(b, 0, length);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileInputStream.close();
                }
            }
        }
        return files;
    }

    public void deleteFile(File[] files) {
        if (files != null) {
            for (File f : files) {
                f.delete();
            }
        }
    }
}

