/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.config.ConfigValue;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.SmSnmpManagementGroupConfiguration;
import com.uscale.system.entity.SmSnmpManagementManagerConfiguration;
import com.uscale.system.entity.SmSnmpManagementUsersConfiguration;
import com.uscale.system.service.SmSnmpManagementGroupConfigurationService;
import com.uscale.system.service.SmSnmpManagementManagerConfigurationService;
import com.uscale.system.service.SmSnmpManagementUsersConfigurationService;
import com.uscale.system.tool.CmdTool;
import com.uscale.system.tool.ProtUtil;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/systemMng/snmpManagement"})
public class SmSnmpManagementController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmSnmpManagementController.class);
    private final SmSnmpManagementGroupConfigurationService groupConfigurationService;
    private final SmSnmpManagementUsersConfigurationService usersConfigurationService;
    private final SmSnmpManagementManagerConfigurationService managerConfigurationService;

    @Autowired
    public SmSnmpManagementController(SmSnmpManagementGroupConfigurationService groupConfigurationService, SmSnmpManagementUsersConfigurationService usersConfigurationService, SmSnmpManagementManagerConfigurationService managerConfigurationService) {
        this.groupConfigurationService = groupConfigurationService;
        this.usersConfigurationService = usersConfigurationService;
        this.managerConfigurationService = managerConfigurationService;
    }

    @GetMapping(value={"/manager/list"})
    public TableDataInfo listManager(@ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u6761\u6570") Integer pageSize) {
        QueryWrapper wrapper = new QueryWrapper();
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        this.managerConfigurationService.page((IPage)page, (Wrapper)wrapper);
        return this.getDataTable(page);
    }

    @Log(title="SNMP\u7ba1\u7406\u5458\u914d\u7f6e", businessType=BusinessType.INSERT)
    @PostMapping(value={"/manager"})
    public AjaxResult<Object> addManager(@RequestBody SmSnmpManagementManagerConfiguration managerConfiguration) {
        managerConfiguration.setAuthorizationType("AuthByIP");
        if (this.managerConfigurationService.count() > 5) {
            return AjaxResult.error((String)MessageUtils.message((String)"snmp.table.record.full", (Object[])new Object[0]));
        }
        return this.toAjax(this.managerConfigurationService.save((Object)managerConfiguration));
    }

    @Log(title="SNMP\u7ba1\u7406\u5458\u914d\u7f6e", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/manager/{ids}"})
    public AjaxResult<Object> removeManager(@ApiParam(value="ID") @PathVariable Long[] ids) {
        return this.toAjax(this.managerConfigurationService.removeByIds(Arrays.asList((Object[])ids.clone())));
    }

    @GetMapping(value={"/group/list"})
    public TableDataInfo listGroup(@ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u6761\u6570") Integer pageSize) {
        QueryWrapper wrapper = new QueryWrapper();
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.groupConfigurationService.page((IPage)page, (Wrapper)wrapper));
    }

    @Log(title="SNMP\u7528\u6237\u7ec4\u914d\u7f6e", businessType=BusinessType.INSERT)
    @PostMapping(value={"/group"})
    public AjaxResult<Boolean> addGroup(@RequestBody SmSnmpManagementGroupConfiguration groupConfiguration) {
        if (this.groupConfigurationService.count() > 8) {
            return AjaxResult.error((String)MessageUtils.message((String)"snmp.table.record.full", (Object[])new Object[0]));
        }
        return AjaxResult.success((Object)this.groupConfigurationService.addGroup(groupConfiguration));
    }

    @Log(title="SNMP\u7528\u6237\u7ec4\u914d\u7f6e", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/group/{ids}"})
    public AjaxResult<Object> removeGroup(@ApiParam(value="ID") @PathVariable Long[] ids) {
        return this.toAjax(this.groupConfigurationService.removeGroup(Arrays.asList((Object[])ids.clone())).booleanValue());
    }

    @GetMapping(value={"/users/list"})
    public TableDataInfo listUsers(@ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u6761\u6570") Integer pageSize) {
        QueryWrapper wrapper = new QueryWrapper();
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.usersConfigurationService.page((IPage)page, (Wrapper)wrapper));
    }

    @GetMapping(value={"/users/{id}"})
    public AjaxResult<SmSnmpManagementUsersConfiguration> getUsers(@ApiParam(value="ID") @PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.usersConfigurationService.getById((Serializable)id));
    }

    @Log(title="SNMP\u7528\u6237\u914d\u7f6e", businessType=BusinessType.INSERT)
    @PostMapping(value={"/users"})
    public AjaxResult<Boolean> addUsers(@RequestBody SmSnmpManagementUsersConfiguration usersConfiguration) {
        if (this.usersConfigurationService.count() > 8) {
            return AjaxResult.error((String)MessageUtils.message((String)"snmp.table.record.full", (Object[])new Object[0]));
        }
        return AjaxResult.success((Object)this.usersConfigurationService.addOrUpdateUsers(usersConfiguration));
    }

    @Log(title="SNMP\u7528\u6237\u914d\u7f6e", businessType=BusinessType.INSERT)
    @PutMapping(value={"/users"})
    public AjaxResult<Boolean> updateUsers(@RequestBody SmSnmpManagementUsersConfiguration usersConfiguration) {
        return AjaxResult.success((Object)this.usersConfigurationService.addOrUpdateUsers(usersConfiguration));
    }

    @Log(title="SNMP\u7528\u6237\u914d\u7f6e", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/users/{ids}"})
    public AjaxResult<Object> removeUsers(@ApiParam(value="ID") @PathVariable Long[] ids) {
        return this.toAjax(this.usersConfigurationService.removeUsers(Arrays.asList((Object[])ids.clone())).booleanValue());
    }

    @PostMapping(value={"/snmpSwitchSettings/{type}"})
    public AjaxResult<Object> snmpSwitchSettings(@PathVariable(value="type") Integer type) {
        if (type == 1) {
            int port = Integer.parseInt(ConfigValue.get((String)"udp.port").toString());
            return AjaxResult.success((Object)ProtUtil.isUsed((int)port));
        }
        if (type == 2) {
            try {
                CmdTool.execReadShell((String)"systemctl start snmpd");
            }
            catch (IOException e) {
                LOGGER.error("\u5f00\u542fsnmp\u5931\u8d25");
                throw new RuntimeException(e);
            }
        }
        if (type == 3) {
            try {
                CmdTool.execReadShell((String)"systemctl stop snmpd");
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95edsnmp\u5931\u8d25");
                throw new RuntimeException(e);
            }
        }
        return AjaxResult.success();
    }
}

