/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.Protocol;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.SshUtil;
import com.uscale.common.utils.StringUtils;
import com.uscale.common.utils.file.FileUtils;
import com.uscale.common.utils.ip.IpUtils;
import com.uscale.system.dao.PsTransportsDao;
import com.uscale.system.dao.r2.TmConfigR2PointDao;
import com.uscale.system.dao.ss7.TmConfigSS7Dao;
import com.uscale.system.domain.vo.CmdResultVo;
import com.uscale.system.domain.vo.PingVo;
import com.uscale.system.entity.PsTransports;
import com.uscale.system.entity.SysDevice;
import com.uscale.system.entity.r2.TmConfigR2Point;
import com.uscale.system.entity.ss7.TmConfigSS7;
import com.uscale.system.model.PacketCapModel;
import com.uscale.system.service.ISysDeviceService;
import com.uscale.system.service.SmSignalingService;
import com.uscale.system.tool.CmdTool;
import com.uscale.system.vo.TreeVO;
import com.uscale.system.vo.UiadSyncDigitalChannels;
import com.uscale.system.vo.UiadSyncDigitalPayload;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u4fe1\u4ee4\u5206\u6790\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/systemMng/signaling"})
public class SmSignalingController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(SmSignalingController.class);
    private static final String FILTER = "/var/log/pcap/";
    private static int i = 1;
    private static final String SIP = "tcpdump -i eth#n #host port #p -n -s 0 -vvv -w /var/log/pcap/#path/#filename.pcap -Z root & { sleep #time; kill $! & }";
    private static final String SS7_R2 = "dahdi_pcap -p mtp2 -c #c -f /var/log/pcap/#path/#filename.pcap & { sleep #time; kill $! & }";
    private static final String PRA = "dahdi_pcap -p lapd -c #c -f /var/log/pcap/#path/#filename.pcap & { sleep #time; kill $! & }";
    private static final String MOUNT_SLOT = " | if [ ! -d /var/log/pcap ];then mkdir -p /var/log/pcap;fi | mount -t nfs 117.103.93.1:/var/log/pcap/slotX /var/log/pcap -o nolock -o loop";
    private static final String UMOUNT_SLOT = "umount -f /var/log/pcap";
    private final ISysDeviceService sysDeviceService;
    private final PsTransportsDao psTransportsDao;
    private final TmConfigR2PointDao tmConfigR2PointDao;
    private final TmConfigSS7Dao tmConfigSS7Dao;
    private final RedisTemplate<String, Object> redisTemplate;
    private final SmSignalingService smSignalingService;

    @Autowired
    @Lazy
    public SmSignalingController(ISysDeviceService sysDeviceService, PsTransportsDao psTransportsDao, TmConfigR2PointDao tmConfigR2PointDao, TmConfigSS7Dao tmConfigSS7Dao, RedisTemplate redisTemplate, SmSignalingService smSignalingService) {
        this.sysDeviceService = sysDeviceService;
        this.psTransportsDao = psTransportsDao;
        this.tmConfigR2PointDao = tmConfigR2PointDao;
        this.tmConfigSS7Dao = tmConfigSS7Dao;
        this.redisTemplate = redisTemplate;
        this.smSignalingService = smSignalingService;
    }

    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u5668\u76ee\u5f55\u6570\u636e")
    @GetMapping(value={"/listTreeFile"})
    public AjaxResult<List<TreeVO>> listTreeFile() {
        ArrayList list = new ArrayList();
        File file = new File(FILTER);
        if (!file.exists()) {
            return AjaxResult.success(list);
        }
        i = 1;
        List listFiles = Arrays.stream((Object[])Objects.requireNonNull(file.listFiles())).sorted(Comparator.comparing(File::getName)).collect(Collectors.toList());
        for (File listFile : listFiles) {
            this.addFile(listFile, list);
        }
        return AjaxResult.success(list);
    }

    private void listFiles(File file, TreeVO vo) {
        ArrayList children = new ArrayList();
        if (file.isDirectory()) {
            vo.setLabel(file.getName());
            vo.setUrl(file.getPath());
            vo.setIcon("folder");
            vo.setDisabled(Boolean.valueOf(true));
            List listFiles = Arrays.stream((Object[])Objects.requireNonNull(file.listFiles())).sorted(Comparator.comparing(File::getName)).collect(Collectors.toList());
            for (File smbFile : listFiles) {
                this.addFile(smbFile, children);
            }
        }
        vo.setChildren(children);
    }

    private void addFile(File file, List<TreeVO> children) {
        TreeVO vo = new TreeVO();
        vo.setId(i++ + "");
        vo.setLabel(file.getName());
        vo.setUrl(file.getPath());
        vo.setIcon("file");
        vo.setDisabled(Boolean.valueOf(false));
        children.add(vo);
        this.listFiles(file, vo);
    }

    @ApiOperation(value="\u6587\u4ef6\u4e0b\u8f7d")
    @GetMapping(value={"/fileDownload"})
    public void fileDownload(@ApiParam(value="\u6587\u4ef6\u540d") @RequestParam(name="file") String file, HttpServletResponse response) {
        try {
            String fileName = file.substring(file.lastIndexOf("/") + 1);
            response.setContentType("application/octet-stream");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            FileUtils.writeBytes((String)file, (OutputStream)response.getOutputStream());
            FileUtils.deleteFile((String)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @ApiOperation(value="\u6587\u4ef6\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="url", value="\u6587\u4ef6\u8def\u5f84", required=true, dataType="String")})
    @DeleteMapping(value={"/fileDelete"})
    public AjaxResult fileDelete(@ApiIgnore @RequestBody HashMap<String, String> params) {
        if (!params.containsKey("url")) {
            return AjaxResult.error();
        }
        String url = params.get("url");
        if (StringUtils.isBlank((CharSequence)url)) {
            return AjaxResult.error();
        }
        if (!StringUtils.startsWith((CharSequence)url, (CharSequence)FILTER)) {
            return AjaxResult.error();
        }
        File file = new File(url);
        if (!file.exists()) {
            return AjaxResult.error();
        }
        return AjaxResult.success((Object)FileUtils.deleteFile((String)url));
    }

    @ApiOperation(value="\u6293\u5305")
    @Log(title="\u4fe1\u4ee4\u5206\u6790\u7ba1\u7406(\u6293\u5305)", businessType=BusinessType.OTHER)
    @PostMapping(value={"/packetCapture"})
    public AjaxResult<?> packetCapture(@ApiParam(value="\u67e5\u8be2\u6570\u636e") @Validated @RequestBody PacketCapModel packetCapModel) {
        String device = "117.103.93";
        String path = "";
        String sip = SIP;
        String slot = "";
        String protocol = Protocol.SIP.getName();
        if (!packetCapModel.getDevice().contains(device)) {
            path = "scu";
        } else {
            List list;
            if (!Protocol.SIP.getCode().equals(packetCapModel.getProtocol())) {
                sip = Protocol.PRA.getCode().equals(packetCapModel.getProtocol()) ? PRA : SS7_R2;
            }
            char at = packetCapModel.getDevice().charAt(packetCapModel.getDevice().length() - 1);
            logger.debug("at==>{}", (Object)Character.valueOf(at));
            String mountSlot = UMOUNT_SLOT + MOUNT_SLOT.replace("X", Character.toString(at));
            StringJoiner sj = new StringJoiner(",");
            slot = Character.toString(at);
            if (Protocol.R2.getCode().equals(packetCapModel.getProtocol())) {
                list = this.tmConfigR2PointDao.selectList((Wrapper)new LambdaQueryWrapper().eq(TmConfigR2Point::getSlot, (Object)Character.toString(at)));
                list.forEach(l -> sj.add(this.getPortToBCHan(l.getPort())));
                protocol = Protocol.R2.getName();
            } else if (Protocol.SS7.getCode().equals(packetCapModel.getProtocol())) {
                list = this.tmConfigSS7Dao.selectList((Wrapper)new LambdaQueryWrapper().eq(TmConfigSS7::getSlot, (Object)Character.toString(at)));
                list.forEach(l -> sj.add(this.getPortToBCHan(l.getPort())));
                protocol = Protocol.SS7.getName();
            } else if (Protocol.PRA.getCode().equals(packetCapModel.getProtocol())) {
                SysDevice mtuDevice = this.sysDeviceService.getBySlot(Character.toString(at));
                if (ObjectUtils.isEmpty((Object)mtuDevice) || !StringUtils.equals((CharSequence)mtuDevice.getSlotType(), (CharSequence)"E1") || StringUtils.isBlank((CharSequence)mtuDevice.getSlotConfig())) {
                    return AjaxResult.error();
                }
                UiadSyncDigitalPayload e1SlotConfig = (UiadSyncDigitalPayload)JSONObject.parseObject((String)mtuDevice.getSlotConfig(), UiadSyncDigitalPayload.class);
                if (ObjectUtils.isEmpty((Object)e1SlotConfig)) {
                    return AjaxResult.error();
                }
                JSONObject e1DigitalChannels = e1SlotConfig.getDigital_channels();
                if (ObjectUtils.isEmpty((Object)e1DigitalChannels)) {
                    return AjaxResult.error();
                }
                HashSet<String> dchans = new HashSet<String>();
                for (int i = 1; i <= 4; ++i) {
                    UiadSyncDigitalChannels digitalChannels = (UiadSyncDigitalChannels)e1DigitalChannels.getObject(i + "", UiadSyncDigitalChannels.class);
                    if (!ObjectUtils.isNotEmpty((Object)digitalChannels) || !ObjectUtils.isNotEmpty((Object)digitalChannels.getDchan())) continue;
                    Integer dchanValue = (i - 1) * 31 + digitalChannels.getDchan();
                    dchans.add(dchanValue.toString());
                }
                if (CollectionUtils.isEmpty(dchans)) {
                    return AjaxResult.error();
                }
                dchans.forEach(l -> sj.add((CharSequence)l));
                protocol = Protocol.PRA.getName();
            }
            if (sj.length() == 0) {
                sj.add("16");
            }
            logger.debug("Dchan==>{}", (Object)sj.toString());
            sip = sip.replace("#c", sj.toString());
            SshUtil.execute((String)packetCapModel.getDevice(), (String)mountSlot);
            long expireTime = Long.parseLong(StringUtils.isEmpty((String)packetCapModel.getTime()) ? "60" : packetCapModel.getTime()) + 60L;
            this.redisTemplate.opsForValue().set((Object)(packetCapModel.getRecordId() + "_umount"), (Object)packetCapModel.getDevice(), expireTime, TimeUnit.SECONDS);
        }
        sip = sip.replace("#n", packetCapModel.getEth());
        String fileName = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        sip = sip.replace("#path", path).replace("#filename", fileName + "-" + (StringUtils.isNotBlank((CharSequence)path) ? path : slot) + "-" + protocol);
        sip = sip.replace("#time", StringUtils.isEmpty((String)packetCapModel.getTime()) ? "60" : packetCapModel.getTime());
        sip = !StringUtils.isEmpty((String)packetCapModel.getIp()) ? sip.replace("#host", "host " + packetCapModel.getIp() + " and ") : sip.replace("#host", "");
        List list = this.psTransportsDao.selectList((Wrapper)new QueryWrapper().select(new String[]{"DISTINCT substring_index(bind,':',-1) AS bind"}));
        StringJoiner stringJoiner = new StringJoiner(" or ");
        for (PsTransports psTransports : list) {
            stringJoiner.add(psTransports.getBind());
        }
        String port = "";
        if (list.size() > 0) {
            port = "'(".concat(stringJoiner.toString()).concat(")'");
            sip = sip.replace("#p", port);
        } else {
            sip = sip.replace(" port #p", port);
        }
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{packetCapModel.getRecordId(), sip})) {
            long expireTime = Long.parseLong(StringUtils.isEmpty((String)packetCapModel.getTime()) ? "60" : packetCapModel.getTime()) + 60L;
            String text = (StringUtils.equals((CharSequence)path, (CharSequence)"scu") ? "bash -c " : "ash -c ") + sip.substring(0, sip.indexOf(fileName) + fileName.length());
            this.redisTemplate.opsForValue().set((Object)packetCapModel.getRecordId(), (Object)text, expireTime, TimeUnit.SECONDS);
        }
        logger.debug("dahdi_pcap==>{}", (Object)sip);
        SshUtil.execute((String)packetCapModel.getDevice(), (String)sip);
        if (packetCapModel.getDevice().contains(device)) {
            SshUtil.execute((String)packetCapModel.getDevice(), (String)UMOUNT_SLOT);
        }
        logger.debug("IP:{} \u6293\u5305\u6267\u884c\u8bed\u53e5:{}", (Object)packetCapModel.getDevice(), (Object)sip);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u505c\u6b62\u6293\u5305")
    @Log(title="\u4fe1\u4ee4\u5206\u6790\u7ba1\u7406(\u6293\u5305)", businessType=BusinessType.OTHER)
    @GetMapping(value={"/stopPacketCapture/{recordId}"})
    public AjaxResult<?> stopPacketCapture(@PathVariable(value="recordId") String recordId) {
        if (StringUtils.isBlank((CharSequence)recordId) || !this.redisTemplate.hasKey((Object)recordId).booleanValue()) {
            return AjaxResult.error((String)MessageUtils.message((String)"signaling.record.not.exists", (Object[])new Object[0]));
        }
        String cmd = (String)this.redisTemplate.opsForValue().get((Object)recordId);
        if (StringUtils.isBlank((CharSequence)cmd)) {
            return AjaxResult.error((String)MessageUtils.message((String)"signaling.record.not.exists", (Object[])new Object[0]));
        }
        try {
            String slotKey = recordId + "_umount";
            if (this.redisTemplate.hasKey((Object)slotKey).booleanValue()) {
                String shellGrepPidCmd;
                String pid;
                String device = (String)this.redisTemplate.opsForValue().get((Object)slotKey);
                if (StringUtils.isNotBlank((CharSequence)device) && StringUtils.isNotBlank((CharSequence)(pid = SshUtil.execute((String)device, (String)(shellGrepPidCmd = CmdTool.grepWPidCmd((String)cmd)))))) {
                    String killCmd = CmdTool.kill((String)pid);
                    SshUtil.execute((String)device, (String)killCmd);
                    this.redisTemplate.delete((Object)recordId);
                    SshUtil.execute((String)device, (String)UMOUNT_SLOT);
                    this.redisTemplate.delete((Object)slotKey);
                }
            } else {
                String shellGrepPidCmd = CmdTool.grepELFPidCmd((String)cmd);
                String pid = CmdTool.execReadShell((String)shellGrepPidCmd);
                if (StringUtils.isBlank((CharSequence)pid)) {
                    return AjaxResult.error((String)MessageUtils.message((String)"signaling.record.not.exists", (Object[])new Object[0]));
                }
                if (StringUtils.isNotBlank((CharSequence)pid)) {
                    String killCmd = CmdTool.kill((String)pid);
                    CmdTool.execShell((String)killCmd);
                    this.redisTemplate.delete((Object)recordId);
                }
            }
        }
        catch (IOException e) {
            return AjaxResult.error((String)MessageUtils.message((String)"signaling.stop.packetcapture.fail", (Object[])new Object[0]));
        }
        return AjaxResult.success();
    }

    @GetMapping(value={"/listBoardInfo"})
    public TableDataInfo<SysDevice> listBoardInfo() {
        List list = this.sysDeviceService.getBoardInfo();
        list = list.stream().filter(sysDevice -> {
            LocalDateTime deviceTime = LocalDateTime.ofInstant(sysDevice.getUpDatetime().toInstant(), ZoneId.systemDefault());
            Duration duration = Duration.between(deviceTime, LocalDateTime.now());
            Long t = Math.abs(duration.getSeconds());
            return t - 30L <= 0L;
        }).sorted(Comparator.comparing(SysDevice::getDevice)).collect(Collectors.toList());
        SysDevice sd = new SysDevice();
        sd.setDevice("scu");
        if (IpUtils.getLocalIp4Address().isPresent()) {
            sd.setUpIpAddr(((Inet4Address)IpUtils.getLocalIp4Address().get()).getHostAddress());
        }
        list.add(0, sd);
        return this.getDataTable(list);
    }

    String getPortToBCHan(String port) {
        if ("1".equals(port)) {
            return "47";
        }
        if ("2".equals(port)) {
            return "78";
        }
        if ("3".equals(port)) {
            return "109";
        }
        return "16";
    }

    @ApiOperation(value="Ping")
    @PostMapping(value={"/ping"})
    public AjaxResult ping(@RequestBody PingVo vo) {
        CmdResultVo cmdResultVo = this.smSignalingService.ping(vo);
        return AjaxResult.success((Object)cmdResultVo);
    }
}

