/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.ProcessUtil;
import com.uscale.common.utils.StringUtils;
import com.uscale.common.utils.file.FileUploadUtils;
import com.uscale.common.utils.file.FileUtils;
import com.uscale.system.service.IEndpointsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u8bc1\u4e66\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/systemMng/serverLicense"})
public class SmServerLicenseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Value(value="${asterisk.licensePath}")
    private String licensePath;
    @Value(value="${asterisk.licensePathWin}")
    private String licensePathWin;
    private final IEndpointsService endpointsService;
    private static final String CA = "ca.pem";
    private static final String PEM = "pbx_client.pem";
    private static final String CRT = "pbx_server.crt";
    private static final String KEY = "pbx_server.key";
    private static final String RESTART_COMMAND = "systemctl restart uscale-ast";

    @Autowired
    public SmServerLicenseController(IEndpointsService endpointsService) {
        this.endpointsService = endpointsService;
    }

    @PostMapping
    public Boolean blackUrl() {
        return true;
    }

    @ApiOperation(value="\u81ea\u52a8\u751f\u6210\u8bc1\u4e66")
    @GetMapping(value={"autoGenerateLicense"})
    public AjaxResult<Object> autoGenerateLicense() {
        ProcessUtil processUtil = new ProcessUtil();
        processUtil.execute("/uscale/bin/uscale-cert --up_all >/dev/null 2>&1");
        this.LOGGER.info("\u547d\u4ee4\u6267\u884c\u7ed3\u679c - {}", (Object)processUtil.getOutputMessage());
        processUtil.execute(RESTART_COMMAND);
        this.LOGGER.info("\u547d\u4ee4\u6267\u884c\u7ed3\u679c - {}", (Object)processUtil.getOutputMessage());
        return AjaxResult.success();
    }

    @ApiOperation(value="\u4e0a\u4f20\u8bc1\u4e66")
    @Log(title="\u8bc1\u4e66\u7ba1\u7406", businessType=BusinessType.IMPORT)
    @PostMapping(value={"upload"})
    public AjaxResult<Object> uploadLicense(@ApiParam(value="CA\u6839\u8bc1\u4e66") MultipartFile pemFile, @ApiParam(value="\u5ba2\u6237\u7aef\u8bc1\u4e66") MultipartFile clientPemFile, @ApiParam(value="\u8bbe\u5907\u8bc1\u4e66") MultipartFile crtFile, @ApiParam(value="\u8bbe\u5907\u5bc6\u94a5") MultipartFile keyFile) {
        if (pemFile == null || clientPemFile == null || crtFile == null || keyFile == null) {
            return AjaxResult.error((String)MessageUtils.message((String)"upload.file.incomplete", (Object[])new Object[0]));
        }
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{this.licensePath, this.licensePathWin})) {
            return AjaxResult.error((String)MessageUtils.message((String)"upload.file.without.path", (Object[])new Object[0]));
        }
        String FilePath = this.getFilePath();
        try {
            pemFile.transferTo(FileUploadUtils.getAbsoluteFile((String)FilePath, (String)pemFile.getOriginalFilename()));
            clientPemFile.transferTo(FileUploadUtils.getAbsoluteFile((String)FilePath, (String)clientPemFile.getOriginalFilename()));
            crtFile.transferTo(FileUploadUtils.getAbsoluteFile((String)FilePath, (String)crtFile.getOriginalFilename()));
            keyFile.transferTo(FileUploadUtils.getAbsoluteFile((String)FilePath, (String)keyFile.getOriginalFilename()));
        }
        catch (IOException e) {
            this.LOGGER.error("\u4e0a\u4f20\u8bc1\u4e66\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            return AjaxResult.error((String)MessageUtils.message((String)"upload.file.exception", (Object[])new Object[0]));
        }
        ProcessUtil processUtil = new ProcessUtil();
        processUtil.execute(RESTART_COMMAND);
        this.LOGGER.info("\u547d\u4ee4\u6267\u884c\u7ed3\u679c - {}", (Object)processUtil.getOutputMessage());
        return AjaxResult.success();
    }

    @ApiOperation(value="\u4e0b\u8f7d\u8bc1\u4e66")
    @GetMapping(value={"download/{name}"})
    public void download(@ApiParam(value="\u8bc1\u4e66\u540d\u79f0") @PathVariable String name, HttpServletResponse response) {
        try {
            if (!StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{CA, PEM, CRT, KEY})) {
                throw new RuntimeException(MessageUtils.message((String)"download.filename.error", (Object[])new Object[0]));
            }
            response.setContentType("application/octet-stream; charset=UTF-8");
            FileUtils.writeBytes((String)(this.getFilePath() + name), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            this.LOGGER.error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    @ApiOperation(value="\u8bc1\u4e66\u4fe1\u606f")
    @GetMapping(value={"fileInfo"})
    public AjaxResult<Map<String, Boolean>> fileInfo() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        if (new File(this.getFilePath() + CA).exists()) {
            map.put("pemFileList", true);
        }
        if (new File(this.getFilePath() + PEM).exists()) {
            map.put("clientPemFileList", true);
        }
        if (new File(this.getFilePath() + CRT).exists()) {
            map.put("crtFileList", true);
        }
        if (new File(this.getFilePath() + KEY).exists()) {
            map.put("keyFileList", true);
        }
        return AjaxResult.success(map);
    }

    @ApiOperation(value="\u5f00\u542fTLS")
    @Log(title="\u8bc1\u4e66\u7ba1\u7406(\u5f00\u542fTLS)", businessType=BusinessType.OTHER)
    @GetMapping(value={"openTLS"})
    public AjaxResult<Object> openTLS() {
        this.endpointsService.openTLS();
        ProcessUtil processUtil = new ProcessUtil();
        processUtil.execute(RESTART_COMMAND);
        this.LOGGER.info("\u547d\u4ee4\u6267\u884c\u7ed3\u679c - {}", (Object)processUtil.getOutputMessage());
        return AjaxResult.success();
    }

    @ApiOperation(value="\u5173\u95edTLS")
    @Log(title="\u8bc1\u4e66\u7ba1\u7406(\u5173\u95edTLS)", businessType=BusinessType.OTHER)
    @GetMapping(value={"closeTLS"})
    public AjaxResult<Object> closeTLS() {
        this.endpointsService.closeTLS();
        ProcessUtil processUtil = new ProcessUtil();
        processUtil.execute(RESTART_COMMAND);
        this.LOGGER.info("\u547d\u4ee4\u6267\u884c\u7ed3\u679c - {}", (Object)processUtil.getOutputMessage());
        return AjaxResult.success();
    }

    @ApiOperation(value="\u83b7\u53d6TLS\u72b6\u6001")
    @GetMapping(value={"tlsStatus"})
    public AjaxResult<Boolean> tlsStatus() {
        return AjaxResult.success((Object)this.endpointsService.tlsStatus());
    }

    public String getFilePath() {
        if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            return this.licensePath;
        }
        return this.licensePathWin;
    }
}

