/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.uscale.common.config.TydicConfig;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.file.FileUploadUtils;
import com.uscale.common.utils.file.MimeTypeUtils;
import com.uscale.framework.config.ServerConfig;
import com.uscale.system.entity.SmScriptManage;
import com.uscale.system.service.ISmScriptManageService;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/systemMng/scriptMng"})
public class SmScriptManageController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmScriptManageController.class);
    private static final Gson GSON = new Gson();
    private static final Pattern PATTERN_FOR_OLD_PATH = Pattern.compile("^/profile\\S+(?<filePath>/\\d\\S+)");
    private final ServerConfig serverConfig;
    private final ISmScriptManageService smScriptManageService;

    @Autowired
    public SmScriptManageController(ServerConfig serverConfig, ISmScriptManageService smScriptManageService) {
        this.serverConfig = serverConfig;
        this.smScriptManageService = smScriptManageService;
    }

    @GetMapping(value={"/{scriptType}"})
    public AjaxResult getScriptDict(@PathVariable(value="scriptType") String scriptType) {
        LOGGER.debug("\u751f\u6210\u811a\u672c\u5b57\u5178\uff0c\u811a\u672c\u7c7b\u578b\uff1ascriptType=[{}]", (Object)scriptType);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"script_type", (Object)scriptType);
        List list = this.smScriptManageService.list((Wrapper)wrapper);
        ArrayList scriptDict = new ArrayList();
        list.forEach(item -> {
            HashMap<String, String> tmp = new HashMap<String, String>(2);
            tmp.put("dictValue", item.getId().toString());
            tmp.put("dictLabel", item.getFileName());
            scriptDict.add(tmp);
        });
        return AjaxResult.success(scriptDict);
    }

    @GetMapping(value={"/queryScript"})
    public TableDataInfo queryScript(Integer pageNum, Integer pageSize) {
        QueryWrapper wrapper = new QueryWrapper();
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.smScriptManageService.page((IPage)page, (Wrapper)wrapper));
    }

    @PostMapping(value={"/loadScript"})
    public AjaxResult loadScript(MultipartFile file, @RequestParam(value="override") String override, @RequestParam(value="scriptType") String scriptType) throws Exception {
        try {
            LOGGER.debug("\u52a0\u8f7d\u811a\u672c\uff0c\u83b7\u53d6\u5230\u7684\u53c2\u6570\u4e3a\uff1aoverride=[{}],scriptType=[{}]", (Object)override, (Object)scriptType);
            String filePath = TydicConfig.getUploadPath();
            LOGGER.debug("\u52a0\u8f7d\u811a\u672c\uff0c\u811a\u672c\u6587\u4ef6\u540d,fileName=[{}]", (Object)file.getOriginalFilename());
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"file_name", (Object)file.getOriginalFilename())).eq((Object)"script_type", (Object)scriptType)).last("limit 1");
            SmScriptManage oldData = (SmScriptManage)this.smScriptManageService.getOne((Wrapper)wrapper);
            String no = "no";
            if (!ObjectUtils.isEmpty((Object)oldData) && no.endsWith(override)) {
                return AjaxResult.error((String)MessageUtils.message((String)"script.file.exist", (Object[])new Object[0]));
            }
            String fileName = FileUploadUtils.upload((String)filePath, (MultipartFile)file, (String[])MimeTypeUtils.SCRIPT_TXT);
            String url = this.serverConfig.getUrl() + fileName;
            if (!ObjectUtils.isEmpty((Object)oldData)) {
                File old;
                Matcher matcher = PATTERN_FOR_OLD_PATH.matcher(oldData.getEncodeName());
                String oldFilePath = filePath;
                if (matcher.find()) {
                    oldFilePath = oldFilePath + matcher.group("filePath");
                }
                if ((old = new File(oldFilePath)).exists()) {
                    if (old.delete()) {
                        this.smScriptManageService.removeById((Serializable)oldData.getId());
                    } else {
                        return AjaxResult.error((String)MessageUtils.message((String)"script.old.file.remove.fail", (Object[])new Object[0]));
                    }
                }
            }
            SmScriptManage scriptManage = new SmScriptManage();
            scriptManage.setFileName(file.getOriginalFilename());
            scriptManage.setEncodeName(fileName);
            scriptManage.setScriptType(scriptType);
            scriptManage.setFileSize(String.valueOf(file.getSize()));
            scriptManage.setDownloadUrl(url);
            this.smScriptManageService.save((Object)scriptManage);
            return AjaxResult.success((Object)scriptManage);
        }
        catch (Exception e) {
            return AjaxResult.error((String)e.getMessage());
        }
    }
}

