/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.alibaba.fastjson.JSONObject;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.RedisKeyEnum;
import com.uscale.common.exception.CustomException;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.StringUtils;
import com.uscale.system.entity.License;
import com.uscale.system.enums.AlarmEnum;
import com.uscale.system.enums.LicenseEnum;
import com.uscale.system.service.AlarmManagementService;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.tool.LicenseUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Api(tags={"\u8bb8\u53ef\u8bc1\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/systemMng/license"})
public class SmLicenseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String USE_USERCOUNT = "useuserCount";
    private static final String USE_CHANNELCOUNT = "useChannelCount";
    private static final String USE_VOICECOUNT = "useVoiceCount";
    private static final String USE_MEETINGCOUNT = "useMeetingCount";
    private static final String USE_CONSOLECOUNT = "useConsoleCount";
    private static final String USE_CHANNEL_COUNT = "useChannelCount";
    private final ISipUserService iSipUserService;
    private final JedisPool jedisPool;
    private final AlarmManagementService alarmManagementService;

    @Autowired
    public SmLicenseController(JedisPool jedisPool, ISipUserService iSipUserService, AlarmManagementService alarmManagementService) {
        this.jedisPool = jedisPool;
        this.iSipUserService = iSipUserService;
        this.alarmManagementService = alarmManagementService;
    }

    @ApiOperation(value="\u83b7\u53d6\u8bb8\u53ef\u8bc1\u4fe1\u606f")
    @GetMapping
    public AjaxResult<Map<String, String>> getLicenseInfo() {
        Map licenseInfo = this.licenseInfo();
        return AjaxResult.success((Object)licenseInfo);
    }

    @ApiOperation(value="\u4e0a\u4f20\u8bc1\u4e66")
    @PostMapping(value={"/upload"})
    public AjaxResult<Object> upload(@ApiParam(value="\u8bc1\u4e66") @RequestParam(value="file") MultipartFile file) {
        LicenseUtils licenseUtils = LicenseUtils.getInstance();
        if (file.isEmpty()) {
            return AjaxResult.error((String)MessageUtils.message((String)"file.error", (Object[])new Object[0]));
        }
        File licenceFile = new File("/datacenter/license");
        if (!licenceFile.exists()) {
            licenceFile.mkdirs();
        }
        License license = null;
        try {
            license = licenseUtils.readLicenseFile(file.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)license)) {
            return AjaxResult.error((String)MessageUtils.message((String)"file.error", (Object[])new Object[0]));
        }
        String readExpirationDate = license.getExpiration();
        if (licenseUtils.isExpirationDate(readExpirationDate)) {
            return AjaxResult.error((String)MessageUtils.message((String)"file.error", (Object[])new Object[0]));
        }
        String DEVNAME = "";
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            DEVNAME = licenseUtils.getDevName(jedis);
        }
        String localSN = licenseUtils.getSN(DEVNAME);
        if (StringUtils.isBlank((CharSequence)localSN) || !StringUtils.equals((CharSequence)localSN, (CharSequence)license.getEsn())) {
            return AjaxResult.error((String)MessageUtils.message((String)"serial.number.error", (Object[])new Object[0]));
        }
        String data = licenseUtils.generateSignatureRule(license);
        boolean isVerified = licenseUtils.verifiedSignature(DEVNAME, data, license.getSign(), 12);
        if (!isVerified) {
            return AjaxResult.error((String)MessageUtils.message((String)"file.error", (Object[])new Object[0]));
        }
        File uploadLicenceFile = new File(LicenseUtils.UPLOAD_LICENSE_PATH);
        try {
            this.upload(file.getInputStream(), uploadLicenceFile);
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.select(1);
                jedis.set(RedisKeyEnum.LICENSE.getKey(), LicenseUtils.encoder((String)JSONObject.toJSONString((Object)license)));
                jedis.del(RedisKeyEnum.LICENSE_STATUS.getKey());
                jedis.del(RedisKeyEnum.LICENSE_STATUS_ALARM.getKey());
            }
            this.alarmManagementService.deleteAlarmManagementByAlamId(AlarmEnum.AlarmParameter.LICENSE_WHETHER_EXPIRE.getAlarmId());
        }
        catch (IOException e) {
            return AjaxResult.error((String)MessageUtils.message((String)"upload.fail", (Object[])new Object[0]));
        }
        return AjaxResult.success((String)MessageUtils.message((String)"upload.success", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u4e0b\u8f7d\u8bc1\u4e66")
    @GetMapping(value={"/download"})
    public void download(HttpServletResponse response) {
        File file = new File(LicenseUtils.UPLOAD_LICENSE_PATH);
        if (!file.exists()) {
            throw new CustomException(MessageUtils.messageRequestParam((String)"license.download.certificate.absent", (Object[])new Object[0]));
        }
        response.setContentType("application/octet-stream");
        response.addHeader("Content-Disposition", "attachment;filename=license\uff3fbak.dat");
        try (ServletOutputStream os = response.getOutputStream();){
            FileInputStream inputStream = new FileInputStream(file);
            byte[] b = new byte[((InputStream)inputStream).available()];
            if (((InputStream)inputStream).read(b) != -1) {
                os.write(b);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> licenseInfo() {
        HashMap<String, String> licenseInfo = new HashMap<String, String>(16);
        int count = this.iSipUserService.getUserCount();
        licenseInfo.put(USE_USERCOUNT, String.valueOf(count));
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            licenseInfo.put("useChannelCount", StringUtils.isNotBlank((CharSequence)jedis.get(RedisKeyEnum.USE_CHANNELCOUNT.getKey())) ? jedis.get(RedisKeyEnum.USE_CHANNELCOUNT.getKey()) : String.valueOf(0));
            licenseInfo.put(USE_MEETINGCOUNT, StringUtils.isNotBlank((CharSequence)jedis.get(RedisKeyEnum.USE_MEETINGCOUNT.getKey())) ? jedis.get(RedisKeyEnum.USE_MEETINGCOUNT.getKey()) : String.valueOf(0));
            licenseInfo.put(USE_VOICECOUNT, StringUtils.isNotBlank((CharSequence)jedis.get(RedisKeyEnum.USE_VOICECOUNT.getKey())) ? jedis.get(RedisKeyEnum.USE_VOICECOUNT.getKey()) : String.valueOf(0));
            licenseInfo.put("useChannelCount", StringUtils.isNotBlank((CharSequence)jedis.get(RedisKeyEnum.USE_CHANNEL_COUNT.getKey())) ? jedis.get(RedisKeyEnum.USE_CHANNEL_COUNT.getKey()) : String.valueOf(0));
            Set loginUsers = jedis.keys(RedisKeyEnum.LOGIN_SOFT_CONSOLE_PREFIX.getKey());
            licenseInfo.put(USE_CONSOLECOUNT, CollectionUtils.isEmpty((Collection)loginUsers) ? String.valueOf(0) : String.valueOf(loginUsers.size()));
            LicenseUtils licenseUtils = LicenseUtils.getInstance();
            License license = licenseUtils.getLicense(jedis, false);
            if (!ObjectUtils.isEmpty((Object)license)) {
                jedis.set(RedisKeyEnum.LICENSE.getKey(), LicenseUtils.encoder((String)JSONObject.toJSONString((Object)license)));
                licenseInfo.put(LicenseEnum.LSR_USER_NUM.getCode(), license.getLsrUserNum());
                licenseInfo.put(LicenseEnum.LSR_MAIL_COUNT.getCode(), license.getLsrMailCount());
                licenseInfo.put(LicenseEnum.LSR_CONF_COUNT.getCode(), license.getLsrConfCount());
                licenseInfo.put(LicenseEnum.LSR_CONSOLE_COUNT.getCode(), license.getLsrConsoleCount());
                licenseInfo.put(LicenseEnum.LICENSE_NO.getCode(), license.getVersion());
                licenseInfo.put(LicenseEnum.ESN.getCode(), license.getEsn());
                licenseInfo.put(LicenseEnum.EXPIRATION.getCode(), license.getExpiration());
            }
        }
        return licenseInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(InputStream fis, File toFile) throws IOException {
        try (FileOutputStream os = new FileOutputStream(toFile);){
            int length;
            byte[] b = new byte[1024];
            while ((length = fis.read(b)) > 0) {
                ((OutputStream)os).write(b, 0, length);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

