/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.uscale.common.annotation.Log;
import com.uscale.common.annotation.RepeatSubmit;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.ip.IpUtils;
import com.uscale.system.entity.SysDevice;
import com.uscale.system.model.BmsConfig;
import com.uscale.system.service.BmsConfigService;
import com.uscale.system.service.ISmDeviceMngService;
import com.uscale.system.service.ISysDeviceService;
import com.uscale.system.service.SysConfigInfoService;
import com.uscale.system.vo.IpAddrVo;
import com.uscale.system.vo.IpAliasVo;
import com.uscale.system.vo.SyncExtraInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u8bbe\u5907\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/systemMng/deviceMng"})
public class SmDeviceMngController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(SmDeviceMngController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(SmDeviceMngController.class);
    @Autowired
    private ISmDeviceMngService smDeviceMngService;
    @Autowired
    private ISysDeviceService sysDeviceService;
    @Autowired
    private SysConfigInfoService sysConfigInfoService;
    @Autowired
    private BmsConfigService bmsConfigService;

    @GetMapping(value={"/list"})
    public TableDataInfo getIpAddr() {
        return this.getDataTable(this.sysDeviceService.getIpInfo());
    }

    @ApiOperation(value="\u83b7\u53d6IP\u5730\u5740\u4fe1\u606f")
    @GetMapping(value={"/ifcfg"})
    public AjaxResult<IpAddrVo> getIfcfg() {
        IpAddrVo result = this.sysConfigInfoService.getIpAddr();
        return AjaxResult.success((Object)result);
    }

    @GetMapping(value={"/boardinfo"})
    public TableDataInfo<SysDevice> getBoardInfo() {
        return this.getDataTable(this.sysDeviceService.getBoardInfo());
    }

    @ApiOperation(value="\u83b7\u53d6IP\u522b\u540d\u4fe1\u606f")
    @GetMapping(value={"/aliasInfo"})
    public AjaxResult<IpAliasVo> aliasInfo() {
        return AjaxResult.success((Object)this.sysConfigInfoService.aliasInfo());
    }

    @RepeatSubmit
    @Log(title="\u8bbe\u5907\u7ba1\u7406:IP\u522b\u540d", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/updateAlias"})
    public AjaxResult<Object> updateIpAlias(@RequestBody IpAliasVo ipAliasVo) {
        return this.toAjax(this.sysConfigInfoService.updateIpAlias(ipAliasVo));
    }

    @RepeatSubmit
    @Log(title="\u8bbe\u5907\u7ba1\u7406:IP\u5730\u5740", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/update"})
    public AjaxResult<Object> updateIpAddr(@RequestBody IpAddrVo ipAddrVo) {
        return this.toAjax(this.sysConfigInfoService.saveOrUpdateIpAddr(ipAddrVo));
    }

    @ApiOperation(value="\u83b7\u53d6\u69fd\u4f4d\u4fe1\u606f")
    @PostMapping(value={"/dict"})
    public AjaxResult<List<Map<String, String>>> dict(@ApiParam(value="\u69fd\u7c7b\u578b") @RequestBody List<String> slotType) {
        List list = this.sysDeviceService.dict(slotType);
        return AjaxResult.success((Object)list);
    }

    @ApiOperation(value="\u6784\u9020\u672c\u5c40\u8282\u70b9")
    @GetMapping(value={"/at0List"})
    public AjaxResult<Map<String, Object>> at0List() {
        return AjaxResult.success((Object)this.sysDeviceService.at0List());
    }

    @ApiOperation(value="\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u4fe1\u606f")
    @GetMapping(value={"/getConfFile"})
    public void getConfFile(HttpServletResponse response, @ApiParam(value="\u7c7b\u578b") @RequestParam String type, @ApiParam(value="\u8bbe\u5907\u7c7b\u578b") @RequestParam String slotName, @ApiParam(value="\u7b7e\u540d") String sign) throws IOException {
        this.sysDeviceService.getConfigFile(response, type, slotName, sign);
    }

    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u7248\u914d\u7f6e\u4fe1\u606f")
    @PostMapping(value={"/getUiadConf"})
    public Map<String, Object> getUiadConf(HttpServletRequest request, @ApiParam(value="\u529f\u80fd\u7248\u914d\u7f6e\u4fe1\u606f") String frame) {
        String ipAddr = IpUtils.getIpAddr((HttpServletRequest)request);
        return this.sysDeviceService.getUiadConf(ipAddr, frame);
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f", notes="\u6839\u636eID\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f")
    @GetMapping(value={"{id}"})
    public AjaxResult<SysDevice> get(@ApiParam(value="ID") @PathVariable Integer id) {
        return AjaxResult.success((Object)this.sysDeviceService.getById(id));
    }

    @ApiOperation(value="\u6839\u636e\u69fd\u4f4d\u53f7\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f", notes="\u6839\u636e\u69fd\u4f4d\u53f7\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f")
    @GetMapping(value={"/getBySlot/{slot}"})
    public AjaxResult<SysDevice> getOne(@ApiParam(value="\u69fd\u4f4d\u53f7") @PathVariable String slot) {
        return AjaxResult.success((Object)this.sysDeviceService.getBySlot(slot));
    }

    @ApiOperation(value="\u66f4\u65b0\u8bbe\u5907\u4fe1\u606f")
    @Log(title="\u529f\u80fd\u677f\u914d\u7f6e", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult<Object> update(@RequestBody SysDevice device) {
        this.sysDeviceService.updateById((Object)device);
        return AjaxResult.operateSuccess();
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u9ed8\u8ba4\u914d\u7f6e\u4fe1\u606f", notes="\u7c7b\u578b\u4e0d\u540c\uff0c\u8fd4\u56de\u7684\u6570\u636e\u7ed3\u6784\u4e0d\u540c\uff0c\u6839\u636e\u5177\u4f53\u7684\u7c7b\u578b\u5206\u6790")
    @GetMapping(value={"/defaultConfig/{type}"})
    public AjaxResult<Object> getDefaultBaseConfig(@ApiParam(value="\u7c7b\u578b") @PathVariable String type) {
        return this.smDeviceMngService.getDefaultBaseConfig(type);
    }

    @Log(title="\u529f\u80fd\u677f\u914d\u7f6e", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/removeSlot/{slot}"})
    @ApiOperation(value="\u5220\u9664\u5f53\u524d\u69fd\u53f7\u53ca\u76f8\u5173\u7684\u6240\u6709\u914d\u7f6e")
    public AjaxResult removeSlot(@PathVariable String slot) {
        this.sysDeviceService.removeSlot(slot);
        return AjaxResult.operateSuccess();
    }

    @Log(title="\u529f\u80fd\u677f\u914d\u7f6e", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/cleanOldSlotConfig/{slot}"})
    @ApiOperation(value="\u5220\u9664\u529f\u80fd\u677f\u65e7\u914d\u7f6e,\u751f\u6210\u9ed8\u8ba4\u914d\u7f6e")
    public AjaxResult cleanOldSlotConfig(@PathVariable String slot) {
        this.sysDeviceService.cleanOldSlotConfig(slot);
        return AjaxResult.operateSuccess();
    }

    @Log(title="\u529f\u80fd\u677f\u914d\u7f6e", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/ignoreChange/{slot}"})
    @ApiOperation(value="\u5ffd\u7565\u529f\u80fd\u677f\u5207\u6362\u8b66\u544a")
    public AjaxResult ignoreChange(@PathVariable String slot) {
        this.sysDeviceService.ignoreChange(slot);
        return AjaxResult.operateSuccess();
    }

    @Log(title="\u529f\u80fd\u677f\u914d\u7f6e", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/cleanSlotRelatedConfig/{slot}"})
    @ApiOperation(value="\u5220\u9664\u69fd\u53f7\u76f8\u5173\u914d\u7f6e\uff08pots\u7528\u6237\uff0c\u4e2d\u7ee7\uff09")
    public AjaxResult cleanSlotRelatedConfig(@PathVariable String slot) {
        this.sysDeviceService.cleanSlotRelatedConfig(slot);
        return AjaxResult.operateSuccess();
    }

    @Log(title="\u529f\u80fd\u677f\u914d\u7f6e", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/slotChangeInfo"})
    @ApiOperation(value="\u529f\u80fd\u677f\u4fee\u6539\u7684\u69fd\u53f7")
    public AjaxResult<List<String>> slotChangeInfo() {
        return AjaxResult.success((Object)this.sysDeviceService.slotChangeInfo());
    }

    @ApiOperation(value="\u4e0b\u8f7d\u529f\u80fd\u677f\u5347\u7ea7\u5305")
    @GetMapping(value={"/syncExtra/download/{fileName}"})
    public void download(@PathVariable(value="fileName") String fileName, HttpServletResponse response) throws IOException {
        this.sysDeviceService.download(fileName, response);
    }

    @ApiOperation(value="\u4e0a\u4f20\u529f\u80fd\u677f\u5347\u7ea7\u5305")
    @PostMapping(value={"/syncExtra/upload"})
    public AjaxResult upload(MultipartFile file) throws IOException {
        if (ObjectUtils.isEmpty((Object)file)) {
            return AjaxResult.error();
        }
        this.sysDeviceService.upload(file);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u529f\u80fd\u677f\u5347\u7ea7\u5305\u4fe1\u606f")
    @GetMapping(value={"/getSyncExtra"})
    public AjaxResult<SyncExtraInfoVo> getSyncExtra() throws IOException {
        return AjaxResult.success((Object)this.sysDeviceService.getSyncExtra());
    }

    @ApiOperation(value="\u529f\u80fd\u677f\u5347\u7ea7")
    @GetMapping(value={"/upgrade/{type}"})
    public AjaxResult upgrade(@PathVariable(value="type") String type) {
        this.sysDeviceService.upgrade(type);
        return AjaxResult.success();
    }

    @Log(title="\u66f4\u65b0\u8ba1\u8d39\u7cfb\u7edf\u914d\u7f6e", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/billingConfig"})
    @ApiOperation(value="\u66f4\u65b0\u8ba1\u8d39\u7cfb\u7edf\u914d\u7f6e")
    public AjaxResult billingConfig(@RequestBody BmsConfig bmsConfig) {
        this.bmsConfigService.saveOrUpdate((Object)bmsConfig);
        return AjaxResult.operateSuccess();
    }

    @GetMapping(value={"/getBillingConfig"})
    @ApiOperation(value="\u83b7\u53d6\u8ba1\u8d39\u7cfb\u7edf\u914d\u7f6e")
    public AjaxResult<BmsConfig> getBillingConfig() {
        BmsConfig bmsConfig = (BmsConfig)this.bmsConfigService.getOne((Wrapper)new LambdaQueryWrapper().last("limit 1"));
        return AjaxResult.success((Object)bmsConfig);
    }

    @Log(title="\u5220\u9664\u8ba1\u8d39\u7cfb\u7edf\u914d\u7f6e", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/billingConfig/{id}"})
    @ApiOperation(value="\u5220\u9664\u8ba1\u8d39\u7cfb\u7edf\u914d\u7f6e")
    public AjaxResult billingConfig(@PathVariable Long id) {
        this.bmsConfigService.removeById((Serializable)id);
        return AjaxResult.operateSuccess();
    }

    @ApiOperation(value="\u6d4b\u8bd5\u8fde\u63a5\u8ba1\u8d39\u7cfb\u7edf")
    @PostMapping(value={"/pingBms"})
    public AjaxResult pingBms(@RequestBody BmsConfig bmsConfig) {
        try {
            this.bmsConfigService.pingBms(bmsConfig);
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5\u8ba1\u8d39\u7cfb\u7edf\u5931\u8d25", (Throwable)e);
            return AjaxResult.error((String)MessageUtils.message((String)"connect.fail", (Object[])new Object[0]));
        }
        return AjaxResult.success((String)MessageUtils.message((String)"connect.success", (Object[])new Object[0]));
    }
}

