/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.file.FileFilterUtils;
import com.uscale.system.service.ClusterInfoService;
import com.uscale.system.tool.CmdTool;
import com.uscale.system.tool.TimeTool;
import com.uscale.web.controller.systemMng.SmScriptManageController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6570\u636e\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/systemMng/dataMng"})
public class SmDataMngController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmScriptManageController.class);
    private final String BACKUP_PATH = "/datacenter/backup";
    private final String BACKUP_CMD = "/uscale/bin/uscale-setup backup > /var/log/backup.log 2>&1";
    private final String BACKUP_UPLOAD_PATH = "/datacenter/backup/upload";
    private final ClusterInfoService clusterInfoService;

    @Autowired
    public SmDataMngController(ClusterInfoService clusterInfoService) {
        this.clusterInfoService = clusterInfoService;
    }

    @ApiOperation(value="\u83b7\u53d6\u5907\u4efd\u4fe1\u606f")
    @GetMapping(value={"/backupInfo"})
    public AjaxResult<HashMap<String, Object>> getBackupInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        File backUpFile = new File("/datacenter/backup");
        if (backUpFile.exists() && backUpFile.isDirectory()) {
            File[] files = backUpFile.listFiles((FileFilter)new FileFilterUtils.BackFileFilter());
            if (files.length > 0) {
                String fileName = files[0].getName();
                result.put("fileName", fileName);
                long time = files[0].lastModified();
                String timeFormat = TimeTool.timeFormat((long)time);
                result.put("fileTime", timeFormat);
            } else {
                result.put("fileName", "");
                result.put("fileTime", "");
            }
        }
        return AjaxResult.success(result);
    }

    @ApiOperation(value="\u5907\u4efd")
    @Log(title="\u6570\u636e\u7ba1\u7406(\u5907\u4efd)", businessType=BusinessType.OTHER)
    @GetMapping(value={"/backup"})
    public AjaxResult<Object> backup() {
        try {
            CmdTool.execShell((String)"/uscale/bin/uscale-setup backup > /var/log/backup.log 2>&1");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5907\u4efd\u5f02\u5e38:{}", (Throwable)e);
            return AjaxResult.error((String)MessageUtils.message((String)"data.backup.error", (Object[])new Object[0]));
        }
        return AjaxResult.success();
    }

    @ApiOperation(value="\u4e0b\u8f7d")
    @Log(title="\u6570\u636e\u7ba1\u7406(\u4e0b\u8f7d)", businessType=BusinessType.OTHER)
    @GetMapping(value={"/backupDownload"})
    public AjaxResult<Object> backupDownload(@ApiParam(value="\u6587\u4ef6\u540d") @RequestParam(name="backup_file") String fileName, HttpServletResponse response) {
        if (StringUtils.isNotBlank((CharSequence)fileName) && fileName.startsWith("backup_") && fileName.endsWith(".bin")) {
            File file = new File("/datacenter/backup" + File.separator + fileName);
            if (file.exists() && file.isFile()) {
                response.setContentType("application/octet-stream");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                try {
                    com.uscale.common.utils.file.FileUtils.writeBytes((String)("/datacenter/backup" + File.separator + fileName), (OutputStream)response.getOutputStream());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error("\u5907\u4efd\u4e0b\u8f7d\u5f02\u5e38:{}", (Throwable)e);
                    return AjaxResult.error((String)MessageUtils.message((String)"data.download.fail", (Object[])new Object[0]));
                }
            } else {
                return AjaxResult.error((String)MessageUtils.message((String)"data.backup.file.absent", (Object[])new Object[0]));
            }
        }
        return AjaxResult.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4e0a\u4f20")
    @Log(title="\u6570\u636e\u7ba1\u7406(\u4e0a\u4f20)", businessType=BusinessType.OTHER)
    @PostMapping(value={"/uploadBackup"})
    public AjaxResult<HashMap<String, Object>> uploadBackup(@ApiParam(value="\u6587\u4ef6") @RequestParam(value="file") MultipartFile file, @ApiParam(value="fileName") @RequestParam(value="fileName") String fileName, @ApiParam(value="\u5f00\u59cb\u4f4d\u7f6e") @RequestParam(value="shardIndex") String shardIndex, @ApiParam(value="\u603b\u957f\u5ea6") @RequestParam(value="shardTotal") String shardTotal) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (file.isEmpty()) {
            result.put("status", "error");
            result.put("msg", MessageUtils.message((String)"data.upload.fail.back.empty", (Object[])new Object[0]));
            return AjaxResult.success(result);
        }
        if (StringUtils.isBlank((CharSequence)fileName) || StringUtils.isBlank((CharSequence)shardIndex) || StringUtils.isBlank((CharSequence)shardTotal) || !fileName.startsWith("backup_") || !fileName.endsWith(".bin")) {
            result.put("status", "error");
            result.put("msg", MessageUtils.message((String)"data.upload.fail.file.error", (Object[])new Object[0]));
            return AjaxResult.success(result);
        }
        File uploadDir = new File("/datacenter/backup/upload");
        try {
            if (Integer.parseInt(shardIndex) == 1) {
                FileUtils.deleteDirectory((File)uploadDir);
                uploadDir.mkdirs();
            }
            String uploadPath = "/datacenter/backup/upload" + File.separator + shardIndex + "_" + fileName;
            File uploadFile = new File(uploadPath);
            this.upload(file.getInputStream(), uploadFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u4e0a\u4f20\u5931\u8d25:{}", (Throwable)e);
            try {
                FileUtils.deleteDirectory((File)uploadDir);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            result.put("status", "error");
            result.put("msg", MessageUtils.message((String)"data.upload.fail", (Object[])new Object[0]));
            return AjaxResult.success(result);
        }
        if (Integer.parseInt(shardIndex) < Integer.parseInt(shardTotal)) {
            result.put("status", "next");
            result.put("msg", MessageUtils.message((String)"data.upload.success.continue", (Object[])new Object[0]));
            return AjaxResult.success(result);
        }
        if (Integer.parseInt(shardIndex) == Integer.parseInt(shardTotal)) {
            File[] files = null;
            try {
                files = this.merge("/datacenter/backup/upload", fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.error("\u5408\u5e76\u6587\u4ef6\u5f02\u5e38:{}", (Throwable)e);
                result.put("status", "error");
                result.put("msg", MessageUtils.message((String)"data.upload.merge.file.fail", (Object[])new Object[0]));
                AjaxResult ajaxResult = AjaxResult.success(result);
                return ajaxResult;
            }
            finally {
                this.deleteFile(files);
            }
            result.put("status", "success");
            result.put("msg", MessageUtils.message((String)"upload.success", (Object[])new Object[0]));
            return AjaxResult.success(result);
        }
        return AjaxResult.success();
    }

    @ApiOperation(value="\u6062\u590d")
    @Log(title="\u6570\u636e\u7ba1\u7406(\u6062\u590d)", businessType=BusinessType.OTHER)
    @GetMapping(value={"/recovery"})
    public AjaxResult<Object> recovery() {
        File[] files;
        int count = this.clusterInfoService.getClusterCount();
        if (count == 3) {
            return AjaxResult.error((String)MessageUtils.message((String)"data.recover.two.fail", (Object[])new Object[0]));
        }
        File backUpFile = new File("/datacenter/backup/upload");
        if (backUpFile.exists() && backUpFile.isDirectory()) {
            files = backUpFile.listFiles((FileFilter)new FileFilterUtils.BackFileFilter());
            if (files.length <= 0) {
                return AjaxResult.error((String)MessageUtils.message((String)"data.fail.empty.reupload", (Object[])new Object[0]));
            }
        } else {
            return AjaxResult.error((String)MessageUtils.message((String)"data.fail.empty.reupload", (Object[])new Object[0]));
        }
        String fileName = files[0].getName();
        StringBuffer buffer = new StringBuffer();
        buffer.append("echo ");
        buffer.append("\"");
        buffer.append("/datacenter/backup/upload");
        buffer.append(File.separator);
        buffer.append(fileName);
        buffer.append("\"");
        buffer.append(" > /RESTORE_BACKUP");
        String[] cmds = new String[]{buffer.toString(), "sync", "sync", "reboot"};
        new Thread(() -> {
            try {
                Thread.sleep(3000L);
                for (String cmd : cmds) {
                    CmdTool.execShell((String)cmd);
                }
            }
            catch (Exception e) {
                LOGGER.error("\u6062\u590d\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }).start();
        return AjaxResult.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(InputStream fromFileStream, File toFile) throws IOException {
        InputStream fis = fromFileStream;
        try (FileOutputStream os = new FileOutputStream(toFile);){
            int length;
            byte[] b = new byte[1024];
            while ((length = fis.read(b)) > 0) {
                ((OutputStream)os).write(b, 0, length);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public File[] merge(String path, String fileName) throws IOException {
        File file = new File(path);
        File[] files = file.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        List<File> listFiles = Arrays.asList(files);
        listFiles.sort((Comparator<File>)new /* Unavailable Anonymous Inner Class!! */);
        File newFile = new File(path + File.separator + fileName);
        if (newFile.exists()) {
            newFile.delete();
        }
        try (FileOutputStream outputStream = new FileOutputStream(newFile, true);){
            byte[] b = new byte[1024];
            for (File f : listFiles) {
                FileInputStream fileInputStream = new FileInputStream(f);
                Throwable throwable = null;
                try {
                    int length;
                    while ((length = fileInputStream.read(b)) > 0) {
                        outputStream.write(b, 0, length);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileInputStream.close();
                }
            }
        }
        return files;
    }

    public void deleteFile(File[] files) {
        if (files != null) {
            for (File f : files) {
                f.delete();
            }
        }
    }
}

