/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.StringUtils;
import com.uscale.common.utils.ip.IpTool;
import com.uscale.system.tool.CmdTool;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u8bbe\u5907\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/systemMng/remoteAssistance"})
public class RemoteAssistanceController
extends BaseController {
    private final Logger LOGGER = LoggerFactory.getLogger(RemoteAssistanceController.class);
    private static final Gson GSON = new Gson();
    private static final String minivtun_pid = "ps -ef | grep 'minivtun' | grep -v grep | awk '{print $2}'";
    private static final String kill_pid = "kill -9 ";
    private static final String sleep = "sleep 1";

    @ApiOperation(value="\u8fdc\u7a0b\u534f\u52a9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="serverAddr", value="\u670d\u52a1\u7aef\u5730\u5740", required=true, dataType="String"), @ApiImplicitParam(name="serverport", value="\u670d\u52a1\u7aef\u7aef\u53e3", required=true, dataType="int"), @ApiImplicitParam(name="encryptionType", value="\u52a0\u5bc6\u65b9\u5f0f", required=true, dataType="String"), @ApiImplicitParam(name="password", value="\u8fde\u63a5\u79d8\u94a5", required=true, dataType="String"), @ApiImplicitParam(name="cliAddr", value="\u5ba2\u6237\u7aef\u5730\u5740", required=true, dataType="String"), @ApiImplicitParam(name="cliNetwork", value="\u5ba2\u6237\u7aef\u63a9\u7801", required=true, dataType="String")})
    @Log(title="\u8bbe\u5907\u7ba1\u7406:\u8fdc\u7a0b\u534f\u52a9", businessType=BusinessType.OTHER)
    @PostMapping(value={"/remoteAssistance"})
    public AjaxResult<Object> remoteAssistance(@ApiIgnore @RequestBody Map<String, String> param) {
        this.LOGGER.debug("\u8fdc\u7a0b\u534f\u52a9\u63a5\u6536\u5230\u53c2\u6570\u4e3a\uff1aparam=[{}]", (Object)GSON.toJson(param));
        String serverAddr = param.get("serverAddr");
        String serverport = param.get("serverport");
        String encryptionType = param.get("encryptionType");
        String password = param.get("password");
        String cliAddr = param.get("cliAddr");
        String cliNetwork = param.get("cliNetwork");
        if (StringUtils.isBlank((CharSequence)serverAddr)) {
            return AjaxResult.error((String)MessageUtils.message((String)"remote.assistance.server.address.not.null", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)serverport)) {
            return AjaxResult.error((String)MessageUtils.message((String)"remote.assistance.server.port.not.null", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)encryptionType)) {
            return AjaxResult.error((String)MessageUtils.message((String)"remote.assistance.server.encrypt.not.null", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            return AjaxResult.error((String)MessageUtils.message((String)"remote.assistance.server.key.not.null", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)cliAddr)) {
            return AjaxResult.error((String)MessageUtils.message((String)"remote.assistance.client.address.not.null", (Object[])new Object[0]));
        }
        if (!IpTool.ipCheck((String)cliAddr)) {
            return AjaxResult.error((String)MessageUtils.message((String)"remote.assistance.client.address.format.error", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)cliNetwork)) {
            return AjaxResult.error((String)MessageUtils.message((String)"remote.assistance.client.mask.not.null", (Object[])new Object[0]));
        }
        if (!IpTool.isNetMask((String)cliNetwork)) {
            return AjaxResult.error((String)MessageUtils.message((String)"remote.assistance.client.mask.error", (Object[])new Object[0]));
        }
        Integer cliNetworkNum = IpTool.getNetMaskCode((String)cliNetwork);
        if (cliNetworkNum < 1) {
            return AjaxResult.error((String)MessageUtils.message((String)"remote.assistance.client.mask.too.small", (Object[])new Object[0]));
        }
        if (cliNetworkNum > 30) {
            return AjaxResult.error((String)MessageUtils.message((String)"remote.assistance.client.mask.too.large", (Object[])new Object[0]));
        }
        String pid = null;
        try {
            pid = CmdTool.execReadShell((String)minivtun_pid);
            this.LOGGER.debug("get pid", (Object)pid);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.LOGGER.error("\u83b7\u53d6\u8fdb\u7a0bID\u9519\u8bef:{}", (Throwable)e);
            return AjaxResult.error((String)MessageUtils.message((String)"remote.assistance.get.process.id.error", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)pid)) {
            try {
                this.LOGGER.debug("kiil 9 {}", (Object)pid);
                CmdTool.execShell((String)(kill_pid + pid));
            }
            catch (IOException e) {
                e.printStackTrace();
                this.LOGGER.error("\u5173\u95ed\u8fdb\u7a0bID\u9519\u8bef:{}", (Throwable)e);
                return AjaxResult.error((String)MessageUtils.message((String)"remote.assistance.close.process.id.error", (Object[])new Object[0]));
            }
            try {
                CmdTool.execShell((String)sleep);
                this.LOGGER.debug(sleep);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.LOGGER.error("\u7b49\u5f85\u9519\u8bef:{}", (Throwable)e);
                return AjaxResult.error((String)MessageUtils.message((String)"remote.assistance.wait.error", (Object[])new Object[0]));
            }
        }
        try {
            this.LOGGER.debug("start");
            this.start(serverAddr, serverport, cliAddr, cliNetworkNum, password, encryptionType);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.LOGGER.error("\u542f\u52a8\u8fdc\u7a0b\u534f\u52a9\u9519\u8bef:{}", (Throwable)e);
            return AjaxResult.error((String)MessageUtils.message((String)"remote.assistance.start.error", (Object[])new Object[0]));
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return AjaxResult.operateSuccess();
    }

    private void start(String serverAddr, String serverport, String cliAddr, Integer cliNetworkNum, String password, String encryptionType) throws IOException {
        StringBuffer execParam = new StringBuffer();
        execParam.append("/uscale/bin/minivtun -n pbx0 -r ").append(serverAddr).append(":").append(serverport).append(" -a ").append(cliAddr).append("/").append(cliNetworkNum).append(" -e ").append("'").append(password).append("'").append(" -t ").append(encryptionType).append(" -d");
        this.LOGGER.debug("start cmd :{}", (Object)execParam.toString());
        CmdTool.execShell((String)execParam.toString());
    }
}

