/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.domain.model.LoginUser;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.sign.Base64;
import com.uscale.framework.web.service.TokenService;
import com.uscale.system.tool.CmdTool;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"OEM"})
@RestController
@RequestMapping(value={"/systemMng/oem"})
public class OemManagerController
extends BaseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String PRODUCT_DIR = "/datacenter/product";
    private static final String ICON_NAME = "new_logo.png";
    private static final String ICON_PATH = "/datacenter/product" + File.separator + "new_logo.png";
    private static final String BACKGROUND_NAME = "new_background.png";
    private static final String BACKGROUND_PATH = "/datacenter/product" + File.separator + "new_background.png";
    private static final String PRODUCT_INFO = "product-info.conf";
    private static final String PRODUCT_INFO_PATH = "/datacenter/product" + File.separator + "product-info.conf";
    private static final String PRODUCT_NAME_PREFIX = "PRODUCT_NAME=";
    private static final String PJSIP_CUSTOM = "pjsip_custom.conf";
    private static final String PJSIP_CUSTOM_PATH = "/datacenter/product" + File.separator + "pjsip_custom.conf";
    private static final String USER_AGENT_PREFIX = "user_agent=";
    private static final String DEFAULT_FROM_USER_PREFIX = "default_from_user=";
    private static final String DEFAULT_REALM_PREFIX = "default_realm=";
    private final TokenService tokenService;

    @Autowired
    public OemManagerController(TokenService tokenService) {
        this.tokenService = tokenService;
    }

    @ApiOperation(value="\u83b7\u53d6\u56fe\u6807")
    @GetMapping(value={"/getIcon"})
    public AjaxResult<Map<String, Object>> getIcon() throws IOException {
        return this.getImage(ICON_PATH);
    }

    @ApiOperation(value="\u83b7\u53d6\u56fe\u6807")
    @GetMapping(value={"/getIconToToken"})
    public AjaxResult<Map<String, Object>> getIconToToken() throws IOException {
        return this.getImage(ICON_PATH);
    }

    @ApiOperation(value="\u4e0a\u4f20\u56fe\u6807")
    @Log(title="\u4e0a\u4f20\u56fe\u6807", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/uploadIcon"})
    public AjaxResult uploadIcon(@ApiParam(value="\u56fe\u6807") @RequestParam(value="file") MultipartFile file) throws IOException {
        return this.uploadImage(file, PRODUCT_DIR, ICON_PATH);
    }

    @ApiOperation(value="\u83b7\u53d6oem\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/getProductInfo"})
    public AjaxResult<Map<String, String>> getProductInfo() {
        Map result = this.getProductInfoToMap();
        return AjaxResult.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6oem\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/getProductInfoToToken"})
    public AjaxResult<Map<String, String>> getProductInfoToToken() {
        Map result = this.getProductInfoToMap();
        return AjaxResult.success((Object)result);
    }

    private Map<String, String> getProductInfoToMap() {
        File file = new File(PRODUCT_INFO_PATH);
        if (!file.exists()) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("productName", "");
        result.put("modelName", "");
        try {
            String PRODUCT_NAME = CmdTool.execReadShell((String)("grep \"PRODUCT_NAME\" " + PRODUCT_INFO_PATH + " | awk -F'=' '{print $2}'"));
            result.put("productName", PRODUCT_NAME);
            String MODEL_NAME = CmdTool.execReadShell((String)("grep \"MODEL_NAME\" " + PRODUCT_INFO_PATH + " | awk -F'=' '{print $2}'"));
            result.put("modelName", MODEL_NAME);
            String USER_AGENT = CmdTool.execReadShell((String)("grep \"default_realm\" " + PJSIP_CUSTOM_PATH + " | awk -F'=' '{print $2}'"));
            result.put("userAgent", USER_AGENT);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @ApiOperation(value="\u66f4\u65b0oem\u914d\u7f6e\u4fe1\u606f")
    @Log(title="\u66f4\u65b0oem\u914d\u7f6e\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/updateProductInfo"})
    public AjaxResult updateProductInfo(@RequestBody HashMap<String, String> params, HttpServletRequest request) throws IOException, InterruptedException {
        String userAgent;
        String productName;
        LoginUser loginUser = this.tokenService.getLoginUser(request);
        boolean uscaleAdmin = loginUser.getUser().isUscaleAdmin();
        if (!uscaleAdmin) {
            return AjaxResult.error((String)MessageUtils.message((String)"oem.update.no.authority", (Object[])new Object[0]));
        }
        if (params.containsKey("productName") && StringUtils.isNotBlank((CharSequence)(productName = params.get("productName"))) && StringUtils.isNotBlank((CharSequence)(productName = this.formatConfigParam(productName)))) {
            String cmd = "sed -i 's/^PRODUCT_NAME=.*/PRODUCT_NAME=" + productName + "/' " + PRODUCT_INFO_PATH;
            CmdTool.execShell((String)cmd);
            Thread.sleep(500L);
        }
        if (params.containsKey("userAgent") && StringUtils.isNotBlank((CharSequence)(userAgent = params.get("userAgent"))) && StringUtils.isNotBlank((CharSequence)(userAgent = this.formatConfigParam(userAgent)))) {
            String cmd1 = "sed -i 's/^user_agent=.*/user_agent=" + userAgent + " PBX 1.1/' " + PJSIP_CUSTOM_PATH;
            CmdTool.execShell((String)cmd1);
            Thread.sleep(500L);
            String cmd2 = "sed -i 's/^default_from_user=.*/default_from_user=" + userAgent + "/' " + PJSIP_CUSTOM_PATH;
            CmdTool.execShell((String)cmd2);
            Thread.sleep(500L);
            String cmd3 = "sed -i 's/^default_realm=.*/default_realm=" + userAgent + "/' " + PJSIP_CUSTOM_PATH;
            CmdTool.execShell((String)cmd3);
            Thread.sleep(500L);
            String cmd4 = "/asterisk/sbin/asterisk -rx \"pjsip reload\"";
            CmdTool.execShell((String)cmd4);
        }
        return AjaxResult.success();
    }

    public String formatConfigParam(String param) {
        if (StringUtils.isNotBlank((CharSequence)param)) {
            param = param.replaceAll("/", "");
            param = param.replaceAll("\\\\", "");
            param = param.replaceAll("'", "");
            param = param.replaceAll("\"", "");
            param = param.replaceAll(";", "");
            param = param.replaceAll("&", "");
            param = param.replaceAll("\\*", "");
        }
        return param;
    }

    @ApiOperation(value="\u83b7\u53d6\u80cc\u666f\u56fe\u7247")
    @GetMapping(value={"/getBackGround"})
    public AjaxResult<Map<String, Object>> getBackGround() throws IOException {
        return this.getImage(BACKGROUND_PATH);
    }

    @ApiOperation(value="\u83b7\u53d6\u80cc\u666f\u56fe\u7247")
    @GetMapping(value={"/getBackGroundToToken"})
    public AjaxResult<Map<String, Object>> getBackGroundToToken() throws IOException {
        return this.getImage(BACKGROUND_PATH);
    }

    @ApiOperation(value="\u4e0a\u4f20\u80cc\u666f\u56fe\u7247")
    @Log(title="\u4e0a\u4f20\u80cc\u666f\u56fe\u7247", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/uploadBackGround"})
    public AjaxResult uploadBackGround(@ApiParam(value="\u56fe\u6807") @RequestParam(value="file") MultipartFile file, HttpServletRequest request) throws IOException {
        LoginUser loginUser = this.tokenService.getLoginUser(request);
        boolean uscaleAdmin = loginUser.getUser().isUscaleAdmin();
        if (!uscaleAdmin) {
            return AjaxResult.error((String)MessageUtils.message((String)"oem.update.no.authority", (Object[])new Object[0]));
        }
        return this.uploadImage(file, PRODUCT_DIR, BACKGROUND_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AjaxResult<Map<String, Object>> getImage(String path) throws IOException {
        Object data;
        File file = new File(path);
        if (!file.exists()) {
            return AjaxResult.success(null);
        }
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        try (FileInputStream bufferedImage = new FileInputStream(file);){
            data = new byte[((InputStream)bufferedImage).available()];
            int length = 0;
            while ((length = ((InputStream)bufferedImage).read((byte[])data)) != -1) {
                byteArrayOut.write((byte[])data, 0, length);
            }
        }
        data = new HashMap();
        data.put("icon", Base64.encode((byte[])byteArrayOut.toByteArray()));
        return AjaxResult.success((Object)data);
    }

    private AjaxResult uploadImage(@ApiParam(value="\u56fe\u6807") @RequestParam(value="file") MultipartFile file, String dirPath, String filePath) throws IOException {
        if (!file.isEmpty()) {
            File iconDir = new File(dirPath);
            if (!iconDir.exists()) {
                iconDir.mkdirs();
            }
            file.transferTo(new File(filePath));
            return AjaxResult.success((String)MessageUtils.message((String)"upload.success", (Object[])new Object[0]));
        }
        return AjaxResult.error((String)MessageUtils.message((String)"upload.fail", (Object[])new Object[0]));
    }
}

