/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.poi.ExcelUtil;
import com.uscale.system.domain.Person;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.service.LdapService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/systemMng/ldap"})
public class LdapController
extends BaseController {
    private final LdapService ldapService;
    private final ISipUserService iSipUserService;

    @Autowired
    public LdapController(LdapService ldapService, ISipUserService iSipUserService) {
        this.ldapService = ldapService;
        this.iSipUserService = iSipUserService;
    }

    @ApiOperation(value="\u83b7\u53d6Ldap\u901a\u8baf\u5f55\u6240\u6709\u6210\u5458\u4fe1\u606f")
    @GetMapping(value={"/getLdapPersons"})
    public AjaxResult getLdapPersons() {
        List persons = this.ldapService.getLdapPersons();
        List trees = this.ldapService.ldapPersonsToTree(persons);
        List departments = this.ldapService.getDepartments(persons);
        List titles = this.ldapService.getTitles(persons);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("trees", trees);
        result.put("departments", departments);
        result.put("titles", titles);
        return AjaxResult.success(result);
    }

    @ApiOperation(value="\u6839\u636eUID\u83b7\u53d6\u901a\u8baf\u5f55\u4fe1\u606f")
    @GetMapping(value={"/{uid}"})
    public AjaxResult<Person> getLdapPerson(@ApiParam(value="uids") @PathVariable String uid) {
        Person person = this.ldapService.getLdapPersonByUid(uid);
        return AjaxResult.success((Object)person);
    }

    @ApiOperation(value="\u65b0\u589e\u901a\u8baf\u5f55\u4fe1\u606f")
    @PostMapping(value={"/saveLdapPerson"})
    @Log(title="\u65b0\u589e\u901a\u8baf\u5f55\u4fe1\u606f", businessType=BusinessType.INSERT)
    public AjaxResult saveLdapPerson(@RequestBody Person person) {
        if (ObjectUtils.isEmpty((Object)person)) {
            return AjaxResult.error();
        }
        this.ldapService.saveLdapPerson(person);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u5220\u9664\u901a\u8baf\u5f55\u4fe1\u606f")
    @PostMapping(value={"/deleteLdapPerson"})
    @Log(title="\u5220\u9664\u901a\u8baf\u5f55\u4fe1\u606f", businessType=BusinessType.DELETE)
    public AjaxResult deleteLdapPersonByUids(@RequestBody List<String> uids) {
        this.ldapService.deleteLdapPersonByUids(uids);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u66f4\u65b0\u901a\u8baf\u5f55\u4fe1\u606f")
    @PutMapping(value={"/updateLdapPerson"})
    @Log(title="\u66f4\u65b0\u901a\u8baf\u5f55\u4fe1\u606f", businessType=BusinessType.UPDATE)
    public AjaxResult updateLdapPerson(@RequestBody Person person) {
        if (ObjectUtils.isEmpty((Object)person)) {
            return AjaxResult.error();
        }
        this.ldapService.updateLdapPerson(person);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u6839\u636eUID\u4fee\u6539\u901a\u8baf\u5f55\u6210\u5458\u90e8\u95e8")
    @PutMapping(value={"/department/{uids}/{department}"})
    @Log(title="\u4fee\u6539\u901a\u8baf\u5f55\u6210\u5458\u90e8\u95e8", businessType=BusinessType.UPDATE)
    public AjaxResult updateLdapPersonToDepartment(@ApiParam(value="uids") @PathVariable(value="uids") List<String> uids, @ApiParam(value="\u90e8\u95e8") @PathVariable(value="department") String department) {
        if (CollectionUtils.isEmpty(uids)) {
            return AjaxResult.error();
        }
        if (ObjectUtils.isEmpty((Object)department)) {
            return AjaxResult.error();
        }
        this.ldapService.updateLdapPersonDepartmentByUids(uids, department);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u6839\u636eUID\u4fee\u6539\u901a\u8baf\u5f55\u6210\u5458\u804c\u4f4d")
    @PutMapping(value={"/position/{uids}/{position}"})
    @Log(title="\u4fee\u6539\u901a\u8baf\u5f55\u6210\u5458\u804c\u4f4d", businessType=BusinessType.UPDATE)
    public AjaxResult updateLdapPersonToPosition(@ApiParam(value="uids") @PathVariable(value="uids") List<String> uids, @ApiParam(value="\u804c\u4f4d") @PathVariable(value="position") String position) {
        if (CollectionUtils.isEmpty(uids)) {
            return AjaxResult.error();
        }
        if (ObjectUtils.isEmpty((Object)position)) {
            return AjaxResult.error();
        }
        this.ldapService.updateLdapPersonPositionByUids(uids, position);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u5bfc\u51fa\u901a\u8baf\u5f55\u6210\u5458\u4fe1\u606f\u6570\u636e")
    @GetMapping(value={"/exportLdapPersons/{uids}"})
    public AjaxResult<Object> exportLdapPersons(HttpServletResponse response, @ApiParam(value="uids") @PathVariable(value="uids") List<String> uids) {
        ExcelUtil util = new ExcelUtil(Person.class);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String date = simpleDateFormat.format(new Date());
        if (CollectionUtils.isEmpty(uids)) {
            ArrayList persons = new ArrayList();
            return util.exportExcel(persons, "LdapData_" + date);
        }
        List persons = this.ldapService.getLdapPersonsByUids(uids);
        return util.exportExcel(persons, "LdapData_" + date);
    }

    @ApiOperation(value="\u5bfc\u51fa\u5168\u90e8\u901a\u8baf\u5f55\u6210\u5458\u4fe1\u606f\u6570\u636e")
    @GetMapping(value={"/exportAllLdapPersons"})
    public AjaxResult<Object> exportLdapPersons(HttpServletResponse response) {
        ExcelUtil util = new ExcelUtil(Person.class);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String date = simpleDateFormat.format(new Date());
        List persons = this.ldapService.getLdapPersons();
        return util.exportExcel(persons, "LdapData_" + date);
    }

    @ApiOperation(value="\u5bfc\u51fa\u901a\u8baf\u5f55\u6a21\u677f")
    @GetMapping(value={"/exportTemplate"})
    public AjaxResult<Object> exportTemplate() {
        ExcelUtil util = new ExcelUtil(Person.class);
        return util.importTemplateExcel("LdapData_Template");
    }

    @ApiOperation(value="\u5bfc\u5165\u901a\u8baf\u5f55")
    @Log(title="\u5bfc\u5165\u901a\u8baf\u5f55", businessType=BusinessType.INSERT)
    @PostMapping(value={"/importExcelToLdap"})
    public AjaxResult importExcel(@ApiParam(value="\u901a\u8baf\u5f55\u6587\u4ef6") @RequestParam(value="file") MultipartFile file) throws Exception {
        ExcelUtil util = new ExcelUtil(Person.class);
        List personList = util.importExcel(file.getInputStream());
        if (ObjectUtils.isEmpty((Object)personList)) {
            return AjaxResult.error();
        }
        this.ldapService.importExcel(personList);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u540c\u6b65\u7cfb\u7edf\u901a\u8baf\u5f55")
    @Log(title="\u540c\u6b65\u7cfb\u7edf\u901a\u8baf\u5f55", businessType=BusinessType.INSERT)
    @PostMapping(value={"/importSystemUser"})
    public AjaxResult importSystemUser(@RequestBody HashMap<String, String> params) {
        if (!params.containsKey("title") || !params.containsKey("department")) {
            return AjaxResult.error();
        }
        String title = params.get("title");
        String department = params.get("department");
        if (StringUtils.isBlank((CharSequence)department) || StringUtils.isBlank((CharSequence)title)) {
            return AjaxResult.error();
        }
        List sipUsers = this.iSipUserService.list();
        if (CollectionUtils.isEmpty((Collection)sipUsers)) {
            return AjaxResult.success();
        }
        this.ldapService.importSystemUser(sipUsers, department, title);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u540c\u6b651981LDAP\u901a\u8baf\u5f55\u4fe1\u606f")
    @Log(title="\u540c\u6b651981LDAP\u901a\u8baf\u5f55\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @GetMapping(value={"/syncLdap"})
    public AjaxResult syncLdap() {
        this.ldapService.syncLdap();
        return AjaxResult.success();
    }
}

