/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.systemMng;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.poi.ExcelUtil;
import com.uscale.system.entity.AlarmManagement;
import com.uscale.system.model.AlarmManagementModel;
import com.uscale.system.service.AlarmManagementService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/systemMng/alarm"})
public class AlarmManagementController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmManagementController.class);
    private final AlarmManagementService alarmManagementService;

    public AlarmManagementController(AlarmManagementService alarmManagementService) {
        this.alarmManagementService = alarmManagementService;
    }

    @ApiOperation(value="\u67e5\u8be2\u544a\u8b66\u5217\u8868")
    @PostMapping(value={"/list"})
    public TableDataInfo<AlarmManagement> list(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody AlarmManagementModel alarmManagement) {
        LOGGER.debug("\u544a\u8b66\u7ba1\u7406\u5217\u8868\u5206\u9875\u67e5\u8be2\uff0cpageNum=[{}], pageSize=[{}], alarmManagement=[{}]", new Object[]{alarmManagement.getPageNum(), alarmManagement.getPageSize(), alarmManagement});
        Page page = new Page((long)alarmManagement.getPageNum().intValue(), (long)alarmManagement.getPageSize().intValue());
        return this.getDataTable(this.alarmManagementService.listAlarmManagementPage(page, alarmManagement));
    }

    @ApiOperation(value="\u67e5\u8be2\u9009\u62e9\u5217\u8868")
    @GetMapping(value={"/listSelection"})
    public AjaxResult<Object> listSelection() {
        return this.alarmManagementService.listSelection();
    }

    @ApiOperation(value="\u786e\u8ba4\u6e05\u9664\u544a\u8b66")
    @GetMapping(value={"/saveConfirmAndClearAlarm/{id}/{type}/{time}"})
    public AjaxResult<Object> saveConfirmAndClearAlarm(@PathVariable(value="id") Long id, @PathVariable(value="type") Integer type, @PathVariable(value="time") String time) {
        return this.toAjax(this.alarmManagementService.saveConfirmAndClearAlarm(id, type, time));
    }

    @ApiOperation(value="\u4fdd\u5b58\u544a\u8b66\u5907\u6ce8")
    @PostMapping(value={"/saveAlarmRemark"})
    public AjaxResult<Object> saveAlarmRemark(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody AlarmManagementModel alarmManagement) {
        return this.toAjax(this.alarmManagementService.saveAlarmRemark(alarmManagement));
    }

    @ApiOperation(value="\u5bfc\u51fa\u544a\u8b66\u65e5\u5fd7")
    @Log(title="\u544a\u8b66\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/exports"})
    public AjaxResult exports(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") AlarmManagementModel alarmManagement) {
        List list = this.alarmManagementService.selectAlarmManagementList(alarmManagement);
        ExcelUtil util = new ExcelUtil(AlarmManagement.class);
        return util.exportExcel(list, "\u544a\u8b66\u65e5\u5fd7");
    }
}

