/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.system;

import com.uscale.common.annotation.Log;
import com.uscale.common.annotation.RepeatSubmit;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.domain.entity.SysUser;
import com.uscale.common.core.domain.model.LoginUser;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.SecurityUtils;
import com.uscale.common.utils.ServletUtils;
import com.uscale.common.utils.poi.ExcelUtil;
import com.uscale.framework.web.service.TokenService;
import com.uscale.system.service.ISysRoleService;
import com.uscale.system.service.ISysUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/system/user"})
public class SysUserController
extends BaseController {
    @Autowired
    private ISysUserService userService;
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private TokenService tokenService;

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysUser user) {
        this.startPage();
        List list = this.userService.selectUserList(user);
        return this.getDataTable(list);
    }

    @ApiOperation(value="\u5bfc\u51fa\u7528\u6237\u5217\u8868")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/export"})
    public AjaxResult<Object> export(SysUser user) {
        List list = this.userService.selectUserList(user);
        ExcelUtil util = new ExcelUtil(SysUser.class);
        return util.exportExcel(list, "\u7528\u6237\u6570\u636e");
    }

    @ApiOperation(value="\u5bfc\u5165\u7528\u6237\u5217\u8868")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.IMPORT)
    @PostMapping(value={"/importData"})
    public AjaxResult<Object> importData(@ApiParam(value="\u7528\u6237\u5217\u8868\u6587\u4ef6") MultipartFile file, @ApiParam(value="\u662f\u5426\u66f4\u65b0") boolean updateSupport) throws Exception {
        ExcelUtil util = new ExcelUtil(SysUser.class);
        List userList = util.importExcel(file.getInputStream());
        LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
        String operName = loginUser.getUsername();
        String message = this.userService.importUser(userList, Boolean.valueOf(updateSupport), operName);
        return AjaxResult.success((String)message);
    }

    @ApiOperation(value="\u7528\u6237\u6a21\u677f")
    @GetMapping(value={"/importTemplate"})
    public AjaxResult<Object> importTemplate() {
        ExcelUtil util = new ExcelUtil(SysUser.class);
        return util.importTemplateExcel("\u7528\u6237\u6570\u636e");
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u7f16\u53f7\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/", "/{userId}"})
    public AjaxResult<HashMap<String, Object>> getInfo(@ApiParam(value="\u7528\u6237ID") @PathVariable(value="userId", required=false) Long userId) {
        HashMap<String, List> data = new HashMap<String, List>();
        List roles = this.roleService.selectRoleAll();
        data.put("roles", SysUser.isAdmin((Long)userId) ? roles : roles.stream().filter(r -> !r.isAdmin()).collect(Collectors.toList()));
        if (com.uscale.common.utils.StringUtils.isNotNull((Object)userId)) {
            data.put("data", (List)this.userService.selectUserById(userId));
            data.put("roleIds", this.roleService.selectRoleListByUserId(userId));
        }
        return AjaxResult.success(data);
    }

    @ApiOperation(value="\u65b0\u589e\u7528\u6237")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult<Object> add(@Validated @RequestBody SysUser user) {
        if ("1".equals(this.userService.checkUserNameUnique(user.getUserName()))) {
            return AjaxResult.error((String)MessageUtils.message((String)"user.add.fail.account.exist", (Object[])new Object[]{user.getUserName()}));
        }
        if (com.uscale.common.utils.StringUtils.isNotEmpty((String)user.getPhonenumber()) && "1".equals(this.userService.checkPhoneUnique(user))) {
            return AjaxResult.error((String)MessageUtils.message((String)"user.add.fail.phone.exist", (Object[])new Object[]{user.getUserName()}));
        }
        if (com.uscale.common.utils.StringUtils.isNotEmpty((String)user.getEmail()) && "1".equals(this.userService.checkEmailUnique(user))) {
            return AjaxResult.error((String)MessageUtils.message((String)"user.add.fail.email.exist", (Object[])new Object[]{user.getUserName()}));
        }
        user.setCreateBy(SecurityUtils.getUsername());
        user.setPassword(SecurityUtils.encryptPassword((String)user.getPassword()));
        return this.toAjax(this.userService.insertUser(user));
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237")
    @RepeatSubmit
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult<Object> edit(@Validated @RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        if (com.uscale.common.utils.StringUtils.isNotEmpty((String)user.getPhonenumber()) && "1".equals(this.userService.checkPhoneUnique(user))) {
            return AjaxResult.error((String)MessageUtils.message((String)"user.update.fail.phone.exist", (Object[])new Object[]{user.getUserName()}));
        }
        if (com.uscale.common.utils.StringUtils.isNotEmpty((String)user.getEmail()) && "1".equals(this.userService.checkEmailUnique(user))) {
            return AjaxResult.error((String)MessageUtils.message((String)"user.update.fail.email.exist", (Object[])new Object[]{user.getUserName()}));
        }
        user.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.userService.updateUser(user));
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{userIds}"})
    public AjaxResult<Object> remove(@ApiParam(value="\u7528\u6237ID") @PathVariable Long[] userIds) {
        return this.toAjax(this.userService.deleteUserByIds(userIds));
    }

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/resetPwd"})
    public AjaxResult<Object> resetPwd(@RequestBody SysUser user) {
        user.setPassword(SecurityUtils.encryptPassword((String)user.getPassword()));
        user.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.userService.resetPwd(user));
    }

    @ApiOperation(value="\u72b6\u6001\u4fee\u6539")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/changeStatus"})
    public AjaxResult<Object> changeStatus(@RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        user.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.userService.updateUserStatus(user));
    }

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801\uff1a\u6839\u636e\u7528\u6237ID\u548c\u65e7\u5bc6\u7801\u5339\u914d", notes="\u6839\u636e\u7528\u6237ID\u548c\u65e7\u5bc6\u7801\u5339\u914d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="oldPassword", value="\u65e7\u5bc6\u7801", required=true, dataType="String"), @ApiImplicitParam(name="newPassword", value="\u65b0\u5bc6\u7801", required=true, dataType="String")})
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/resetPwds"})
    public AjaxResult<Object> resetPwds(@ApiIgnore @RequestBody Map<String, String> requestData) {
        SysUser loginSysUser = SecurityUtils.getLoginUser().getUser();
        Long userId = loginSysUser.getUserId();
        String oldPassword = requestData.get("oldPassword");
        String newPassword = requestData.get("newPassword");
        if (StringUtils.isBlank((CharSequence)oldPassword) || StringUtils.isBlank((CharSequence)newPassword)) {
            return AjaxResult.error((String)MessageUtils.message((String)"please.enter.password", (Object[])new Object[0]));
        }
        SysUser sysUser = this.userService.selectUserById(userId);
        if (ObjectUtils.isEmpty((Object)sysUser)) {
            return AjaxResult.error((String)MessageUtils.message((String)"user.not.exist", (Object[])new Object[0]));
        }
        if (!SecurityUtils.matchesPassword((String)oldPassword, (String)sysUser.getPassword())) {
            return AjaxResult.error((String)MessageUtils.message((String)"user.password.error", (Object[])new Object[0]));
        }
        SysUser user = new SysUser();
        user.setUserId(userId);
        user.setPassword(SecurityUtils.encryptPassword((String)newPassword));
        user.setUpdateBy(SecurityUtils.getUsername());
        int resetPwd = this.userService.resetPwd(user);
        if (resetPwd > 0) {
            this.tokenService.delLoginUserTouserName(loginSysUser.getUserName());
        }
        return this.toAjax(resetPwd);
    }
}

