/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.system;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.domain.entity.SysRole;
import com.uscale.common.core.domain.model.LoginUser;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.SecurityUtils;
import com.uscale.common.utils.ServletUtils;
import com.uscale.common.utils.StringUtils;
import com.uscale.common.utils.poi.ExcelUtil;
import com.uscale.framework.web.service.SysPermissionService;
import com.uscale.framework.web.service.TokenService;
import com.uscale.system.service.ISysRoleService;
import com.uscale.system.service.ISysUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u89d2\u8272\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/system/role"})
public class SysRoleController
extends BaseController {
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private SysPermissionService permissionService;
    @Autowired
    private ISysUserService userService;

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysRole role) {
        this.startPage();
        List list = this.roleService.selectRoleList(role);
        return this.getDataTable(list);
    }

    @ApiOperation(value="\u5bfc\u51fa\u89d2\u8272\u5217\u8868")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/export"})
    public AjaxResult<Object> export(SysRole role) {
        List list = this.roleService.selectRoleList(role);
        ExcelUtil util = new ExcelUtil(SysRole.class);
        return util.exportExcel(list, "\u89d2\u8272\u6570\u636e");
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7f16\u53f7\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{roleId}"})
    public AjaxResult<SysRole> getInfo(@PathVariable Long roleId) {
        return AjaxResult.success((Object)this.roleService.selectRoleById(roleId));
    }

    @ApiOperation(value="\u6dfb\u52a0\u89d2\u8272")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult<Object> add(@Validated @RequestBody SysRole role) {
        if ("1".equals(this.roleService.checkRoleNameUnique(role))) {
            return AjaxResult.error((String)MessageUtils.message((String)"role.add.fail.name.exist", (Object[])new Object[]{role.getRoleName()}));
        }
        if ("1".equals(this.roleService.checkRoleKeyUnique(role))) {
            return AjaxResult.error((String)MessageUtils.message((String)"role.add.fail.authority.exist", (Object[])new Object[]{role.getRoleName()}));
        }
        role.setCreateBy(SecurityUtils.getUsername());
        return this.toAjax(this.roleService.insertRole(role));
    }

    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult<Object> edit(@Validated @RequestBody SysRole role) {
        this.roleService.checkRoleAllowed(role);
        if ("1".equals(this.roleService.checkRoleNameUnique(role))) {
            return AjaxResult.error((String)MessageUtils.message((String)"role.update.fail.name.exist", (Object[])new Object[]{role.getRoleName()}));
        }
        if ("1".equals(this.roleService.checkRoleKeyUnique(role))) {
            return AjaxResult.error((String)MessageUtils.message((String)"role.update.fail.authority.exist", (Object[])new Object[]{role.getRoleName()}));
        }
        role.setUpdateBy(SecurityUtils.getUsername());
        if (this.roleService.updateRole(role) > 0) {
            LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
            if (StringUtils.isNotNull((Object)loginUser.getUser()) && !loginUser.getUser().isAdmin()) {
                loginUser.setPermissions(this.permissionService.getMenuPermission(loginUser.getUser()));
                loginUser.setUser(this.userService.selectUserByUserName(loginUser.getUser().getUserName()));
                this.tokenService.setLoginUser(loginUser);
            }
            return AjaxResult.success();
        }
        return AjaxResult.error((String)MessageUtils.message((String)"role.update.fail", (Object[])new Object[]{role.getRoleName()}));
    }

    @ApiOperation(value="\u4fee\u6539\u4fdd\u5b58\u6570\u636e\u6743\u9650")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/dataScope"})
    public AjaxResult<Object> dataScope(@RequestBody SysRole role) {
        this.roleService.checkRoleAllowed(role);
        return this.toAjax(this.roleService.authDataScope(role));
    }

    @ApiOperation(value="\u72b6\u6001\u4fee\u6539")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/changeStatus"})
    public AjaxResult<Object> changeStatus(@RequestBody SysRole role) {
        this.roleService.checkRoleAllowed(role);
        role.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.roleService.updateRoleStatus(role));
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{roleIds}"})
    public AjaxResult<Object> remove(@PathVariable Long[] roleIds) {
        return this.toAjax(this.roleService.deleteRoleByIds(roleIds));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u9009\u62e9\u6846\u5217\u8868")
    @GetMapping(value={"/optionselect"})
    public AjaxResult<List<SysRole>> optionselect() {
        return AjaxResult.success((Object)this.roleService.selectRoleAll());
    }
}

