/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.system;

import com.uscale.common.annotation.Log;
import com.uscale.common.config.TydicConfig;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.domain.entity.SysUser;
import com.uscale.common.core.domain.model.LoginUser;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.SecurityUtils;
import com.uscale.common.utils.ServletUtils;
import com.uscale.common.utils.file.FileUploadUtils;
import com.uscale.framework.web.service.TokenService;
import com.uscale.system.service.ISysUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u4e2a\u4eba\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/system/user/profile"})
public class SysProfileController
extends BaseController {
    @Autowired
    private ISysUserService userService;
    @Autowired
    private TokenService tokenService;

    @ApiOperation(value="\u83b7\u53d6\u4e2a\u4eba\u4fe1\u606f")
    @GetMapping
    public AjaxResult<HashMap<String, Object>> profile() {
        LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("roleGroup", this.userService.selectUserRoleGroup(loginUser.getUsername()));
        data.put("user", (String)user);
        return AjaxResult.success(data);
    }

    @ApiOperation(value="\u66f4\u65b0\u4e2a\u4eba\u4fe1\u606f")
    @Log(title="\u4e2a\u4eba\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult<Object> updateProfile(@RequestBody SysUser user) {
        if (this.userService.updateUserProfile(user) > 0) {
            LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
            loginUser.getUser().setNickName(user.getNickName());
            loginUser.getUser().setPhonenumber(user.getPhonenumber());
            loginUser.getUser().setEmail(user.getEmail());
            loginUser.getUser().setSex(user.getSex());
            this.tokenService.setLoginUser(loginUser);
            return AjaxResult.success();
        }
        return AjaxResult.error((String)MessageUtils.message((String)"profile.update.exception", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    @Log(title="\u4e2a\u4eba\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/updatePwd"})
    public AjaxResult<Object> updatePwd(@ApiParam(value="\u65e7\u5bc6\u7801") String oldPassword, @ApiParam(value="\u65b0\u5bc6\u7801") String newPassword) {
        LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
        String userName = loginUser.getUsername();
        String password = loginUser.getPassword();
        if (!SecurityUtils.matchesPassword((String)oldPassword, (String)password)) {
            return AjaxResult.error((String)MessageUtils.message((String)"profile.update.password.fail.old", (Object[])new Object[0]));
        }
        if (SecurityUtils.matchesPassword((String)newPassword, (String)password)) {
            return AjaxResult.error((String)MessageUtils.message((String)"profile.update.password.fail.same", (Object[])new Object[0]));
        }
        if (this.userService.resetUserPwd(userName, SecurityUtils.encryptPassword((String)newPassword)) > 0) {
            loginUser.getUser().setPassword(SecurityUtils.encryptPassword((String)newPassword));
            this.tokenService.setLoginUser(loginUser);
            return AjaxResult.success();
        }
        return AjaxResult.error((String)MessageUtils.message((String)"profile.update.password.exception", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u5934\u50cf\u4e0a\u4f20")
    @Log(title="\u7528\u6237\u5934\u50cf", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/avatar"})
    public AjaxResult<HashMap<String, String>> avatar(@ApiParam(value="\u5934\u50cf") @RequestParam(value="avatarfile") MultipartFile file) throws IOException {
        if (!file.isEmpty()) {
            LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
            String avatar = FileUploadUtils.upload((String)TydicConfig.getAvatarPath(), (MultipartFile)file);
            if (this.userService.updateUserAvatar(loginUser.getUsername(), avatar)) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("imgUrl", avatar);
                AjaxResult ajax = AjaxResult.success(data);
                loginUser.getUser().setAvatar(avatar);
                this.tokenService.setLoginUser(loginUser);
                return ajax;
            }
        }
        return AjaxResult.error((String)MessageUtils.message((String)"profile.upload.image.exception", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u83b7\u53d6\u5934\u50cf")
    @GetMapping(value={"/avatar/{fileName}"})
    public AjaxResult<Object> getAvatar(@PathVariable(value="fileName") String fileName, HttpServletResponse response) throws IOException {
        String replace = fileName.replace("/profile", TydicConfig.getProfile());
        try {
            File file = FileUtils.getFile((String[])new String[]{replace});
            if (!file.exists()) {
                throw new RuntimeException(MessageUtils.message((String)"profile.file.not.exist", (Object[])new Object[]{replace}));
            }
            ServletOutputStream outputStream = response.getOutputStream();
            byte[] bytes = FileUtils.readFileToByteArray((File)file);
            response.setHeader("Content-Disposition", "attachment;filename=" + file.getName());
            outputStream.write(bytes);
            outputStream.flush();
            outputStream.close();
            return AjaxResult.success((String)"success");
        }
        catch (Exception e) {
            return AjaxResult.error((String)e.getMessage());
        }
    }
}

