/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.system;

import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.domain.TreeSelect;
import com.uscale.common.core.domain.entity.SysMenu;
import com.uscale.common.core.domain.model.LoginUser;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.SecurityUtils;
import com.uscale.common.utils.ServletUtils;
import com.uscale.common.utils.StringUtils;
import com.uscale.framework.web.service.TokenService;
import com.uscale.system.model.LiteModel;
import com.uscale.system.model.menu.CreateMenu;
import com.uscale.system.service.ISysMenuService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u83dc\u5355\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/system/menu"})
public class SysMenuController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysMenuController.class);
    private static final Gson GSON = new Gson();
    @Autowired
    private ISysMenuService menuService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private LiteModel liteModel;

    @GetMapping(value={"/getLiteModel"})
    public AjaxResult<?> getLiteModel() {
        return AjaxResult.success((Object)this.liteModel);
    }

    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u5217\u8868")
    @GetMapping(value={"/list"})
    public AjaxResult<List<SysMenu>> list(SysMenu menu) {
        LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
        Long userId = loginUser.getUser().getUserId();
        List menus = this.menuService.selectMenuList(menu, userId);
        return AjaxResult.success((Object)menus);
    }

    @ApiOperation(value="\u6839\u636e\u83dc\u5355\u7f16\u53f7\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{menuId}"})
    public AjaxResult<CreateMenu> getInfo(@PathVariable Long menuId) {
        return AjaxResult.success((Object)this.menuService.selectMenuById(menuId));
    }

    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u4e0b\u62c9\u6811\u5217\u8868")
    @GetMapping(value={"/treeselect"})
    public AjaxResult<List<TreeSelect>> treeselect(SysMenu menu) {
        LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
        Long userId = loginUser.getUser().getUserId();
        List menus = this.menuService.selectMenuList(menu, userId);
        return AjaxResult.success((Object)this.menuService.buildMenuTreeSelect(menus));
    }

    @ApiOperation(value="\u52a0\u8f7d\u5bf9\u5e94\u89d2\u8272\u83dc\u5355\u5217\u8868\u6811", notes="\u6839\u636e\u89d2\u8272ID\u52a0\u8f7d\u5bf9\u5e94\u89d2\u8272\u83dc\u5355\u5217\u8868\u6811")
    @GetMapping(value={"/roleMenuTreeselect/{roleId}"})
    public AjaxResult<HashMap<String, Object>> roleMenuTreeselect(@PathVariable(value="roleId") Long roleId) {
        LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
        List menus = this.menuService.selectMenuList(loginUser.getUser().getUserId());
        HashMap<String, List> data = new HashMap<String, List>();
        data.put("checkedKeys", this.menuService.selectMenuListByRoleId(roleId));
        data.put("menus", this.menuService.buildMenuTreeSelect(menus));
        return AjaxResult.success(data);
    }

    @ApiOperation(value="\u6dfb\u52a0\u83dc\u5355")
    @Log(title="\u83dc\u5355\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult<Object> add(@Validated @RequestBody CreateMenu menu) {
        LOGGER.debug("\u83dc\u5355\u65b0\u589e\uff0c\u53c2\u6570\uff1amenu=[{}]", (Object)GSON.toJson((Object)menu));
        if ("1".equals(this.menuService.checkMenuNameUnique(menu))) {
            return AjaxResult.error((String)MessageUtils.message((String)"menu.add.fail.exist", (Object[])new Object[]{menu.getMenuName()}));
        }
        if ("0".equals(menu.getIsFrame()) && !StringUtils.startsWithAny((CharSequence)menu.getPath(), (CharSequence[])new CharSequence[]{"http://", "https://"})) {
            return AjaxResult.error((String)MessageUtils.message((String)"menu.add.fail.https", (Object[])new Object[]{menu.getMenuName()}));
        }
        if (this.menuService.checkI18nCodeUnique(menu) > 0) {
            return this.toAjax(false);
        }
        menu.setCreateBy(SecurityUtils.getUsername());
        return this.toAjax(this.menuService.insertMenu(menu));
    }

    @ApiOperation(value="\u4fee\u6539\u83dc\u5355")
    @Log(title="\u83dc\u5355\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult<Object> edit(@Validated @RequestBody CreateMenu menu) {
        if ("1".equals(this.menuService.checkMenuNameUnique(menu))) {
            return AjaxResult.error((String)MessageUtils.message((String)"menu.update.fail.exist", (Object[])new Object[]{menu.getMenuName()}));
        }
        if ("0".equals(menu.getIsFrame()) && !StringUtils.startsWithAny((CharSequence)menu.getPath(), (CharSequence[])new CharSequence[]{"http://", "https://"})) {
            return AjaxResult.error((String)MessageUtils.message((String)"menu.update.fail.https", (Object[])new Object[]{menu.getMenuName()}));
        }
        if (menu.getMenuId().equals(menu.getParentId())) {
            return AjaxResult.error((String)MessageUtils.message((String)"menu.update.fail.last", (Object[])new Object[]{menu.getMenuName()}));
        }
        menu.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.menuService.updateMenu(menu));
    }

    @ApiOperation(value="\u5220\u9664\u83dc\u5355", notes="\u6839\u636e\u83dc\u5355ID\u5220\u9664\u83dc\u5355")
    @Log(title="\u83dc\u5355\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{menuId}"})
    public AjaxResult<Object> remove(@PathVariable(value="menuId") Long menuId) {
        if (this.menuService.hasChildByMenuId(menuId)) {
            return AjaxResult.error((String)MessageUtils.message((String)"menu.delete.fail.exist", (Object[])new Object[0]));
        }
        if (this.menuService.checkMenuExistRole(menuId)) {
            return AjaxResult.error((String)MessageUtils.message((String)"menu.delete.fail.allot", (Object[])new Object[0]));
        }
        return this.toAjax(this.menuService.deleteMenuById(menuId));
    }
}

