/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.system;

import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.domain.entity.SysUser;
import com.uscale.common.core.domain.model.LoginBody;
import com.uscale.common.core.domain.model.LoginUser;
import com.uscale.common.utils.ServletUtils;
import com.uscale.framework.web.service.SysLoginService;
import com.uscale.framework.web.service.SysPermissionService;
import com.uscale.framework.web.service.TokenService;
import com.uscale.system.domain.vo.RouterVo;
import com.uscale.system.entity.SysMasterSlave;
import com.uscale.system.service.ISysMenuService;
import com.uscale.system.service.SysMasterSlaveService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u767b\u5f55\u9a8c\u8bc1"})
@RestController
public class SysLoginController {
    private final TokenService tokenService;
    private final ISysMenuService menuService;
    private final SysLoginService loginService;
    private final SysPermissionService permissionService;
    private final SysMasterSlaveService sysMasterSlaveService;

    @Autowired
    public SysLoginController(TokenService tokenService, ISysMenuService menuService, SysLoginService loginService, SysPermissionService permissionService, SysMasterSlaveService sysMasterSlaveService) {
        this.tokenService = tokenService;
        this.menuService = menuService;
        this.loginService = loginService;
        this.permissionService = permissionService;
        this.sysMasterSlaveService = sysMasterSlaveService;
    }

    @ApiOperation(value="\u767b\u5f55")
    @PostMapping(value={"/login"})
    public AjaxResult<HashMap<String, String>> login(@ApiParam(value="\u767b\u5f55\u4fe1\u606f") @RequestBody LoginBody loginBody) {
        String token = this.loginService.login(loginBody);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("token", token);
        String mode = "";
        SysMasterSlave sysMasterSlave = this.sysMasterSlaveService.getMasterSlave();
        if (ObjectUtils.isNotEmpty((Object)sysMasterSlave)) {
            mode = sysMasterSlave.getType();
        }
        data.put("mode", mode);
        return AjaxResult.success(data);
    }

    @ApiOperation(value="\u767b\u5f55\u9875\u5237\u65b0")
    @GetMapping(value={"/login"})
    public void login(HttpServletResponse response) throws IOException {
        response.sendRedirect("/");
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"getInfo"})
    public AjaxResult<Map<String, Object>> getInfo() {
        LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        Set roles = new HashSet();
        Set permissions = new HashSet();
        if (user.isUscaleAdmin()) {
            roles = this.permissionService.getRolePermission(user);
            permissions = this.permissionService.getMenuPermission(user);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("user", user);
        data.put("roles", roles);
        data.put("permissions", permissions);
        return AjaxResult.success(data);
    }

    @ApiOperation(value="\u83b7\u53d6\u8def\u7531\u4fe1\u606f")
    @GetMapping(value={"/getRouters"})
    public AjaxResult<List<RouterVo>> getRouters() {
        LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
        List menuList = this.menuService.selectMenuTreeByUser(loginUser);
        return AjaxResult.success((Object)menuList);
    }
}

