/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.system;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.domain.entity.SysDept;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.SecurityUtils;
import com.uscale.common.utils.StringUtils;
import com.uscale.system.service.ISysDeptService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/dept"})
public class SysDeptController
extends BaseController {
    @Autowired
    private ISysDeptService deptService;

    @GetMapping(value={"/list"})
    public AjaxResult list(SysDept dept) {
        List depts = this.deptService.selectDeptList(dept);
        return AjaxResult.success((Object)depts);
    }

    @GetMapping(value={"/list/exclude/{deptId}"})
    public AjaxResult excludeChild(@PathVariable(value="deptId", required=false) Long deptId) {
        List depts = this.deptService.selectDeptList(new SysDept());
        Iterator it = depts.iterator();
        while (it.hasNext()) {
            SysDept d = (SysDept)it.next();
            if ((long)d.getDeptId().intValue() != deptId && !ArrayUtils.contains((Object[])StringUtils.split((String)d.getAncestors(), (String)","), (Object)(deptId + ""))) continue;
            it.remove();
        }
        return AjaxResult.success((Object)depts);
    }

    @GetMapping(value={"/{deptId}"})
    public AjaxResult getInfo(@PathVariable Long deptId) {
        return AjaxResult.success((Object)this.deptService.selectDeptById(deptId));
    }

    @GetMapping(value={"/treeselect"})
    public AjaxResult treeselect(SysDept dept) {
        List depts = this.deptService.selectDeptList(dept);
        return AjaxResult.success((Object)this.deptService.buildDeptTreeSelect(depts));
    }

    @GetMapping(value={"/roleDeptTreeselect/{roleId}"})
    public AjaxResult<HashMap<String, Object>> roleDeptTreeselect(@PathVariable(value="roleId") Long roleId) {
        List depts = this.deptService.selectDeptList(new SysDept());
        HashMap<String, List> data = new HashMap<String, List>();
        data.put("checkedKeys", this.deptService.selectDeptListByRoleId(roleId));
        data.put("depts", this.deptService.buildDeptTreeSelect(depts));
        return AjaxResult.success(data);
    }

    @Log(title="\u90e8\u95e8\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysDept dept) {
        if ("1".equals(this.deptService.checkDeptNameUnique(dept))) {
            return AjaxResult.error((String)MessageUtils.message((String)"dept.add.fail", (Object[])new Object[]{dept.getDeptName()}));
        }
        dept.setCreateBy(SecurityUtils.getUsername());
        return this.toAjax(this.deptService.insertDept(dept));
    }

    @Log(title="\u90e8\u95e8\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysDept dept) {
        if ("1".equals(this.deptService.checkDeptNameUnique(dept))) {
            return AjaxResult.error((String)MessageUtils.message((String)"dept.update.fail.exist", (Object[])new Object[]{dept.getDeptName()}));
        }
        if (dept.getParentId().equals(dept.getDeptId())) {
            return AjaxResult.error((String)MessageUtils.message((String)"dept.update.fail.last.dept", (Object[])new Object[]{dept.getDeptName()}));
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)dept.getStatus()) && this.deptService.selectNormalChildrenDeptById(dept.getDeptId()) > 0) {
            return AjaxResult.error((String)MessageUtils.message((String)"dept.update.fail.contain.use", (Object[])new Object[0]));
        }
        dept.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.deptService.updateDept(dept));
    }

    @Log(title="\u90e8\u95e8\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{deptId}"})
    public AjaxResult remove(@PathVariable Long deptId) {
        if (this.deptService.hasChildByDeptId(deptId)) {
            return AjaxResult.error((String)MessageUtils.message((String)"dept.delete.fail", (Object[])new Object[0]));
        }
        if (this.deptService.checkDeptExistUser(deptId)) {
            return AjaxResult.error((String)MessageUtils.message((String)"dept.delete.fail.exist.user", (Object[])new Object[0]));
        }
        return this.toAjax(this.deptService.deleteDeptById(deptId));
    }
}

