/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.system;

import com.uscale.common.core.domain.AjaxResult;
import com.uscale.system.service.CliCommandService;
import com.uscale.system.service.CliCommandTreeService;
import com.uscale.system.service.CliParamService;
import com.uscale.system.vo.CliCommandVo;
import com.uscale.system.vo.CliOptionVo;
import com.uscale.system.vo.CliParamVo;
import com.uscale.system.vo.CliParamsVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/cli"})
public class SysCliController {
    @Autowired
    private CliCommandService service;
    @Autowired
    private CliCommandTreeService cliCommandTreeService;
    @Autowired
    private CliParamService cliParamService;

    @PostMapping(value={"/tree"})
    public AjaxResult<List<CliCommandVo>> tree() {
        return AjaxResult.success((Object)this.service.tree());
    }

    @PutMapping(value={""})
    public AjaxResult<String> save(@RequestBody CliCommandVo cliCommandVo) {
        this.service.save(cliCommandVo);
        return AjaxResult.operateSuccess();
    }

    @DeleteMapping(value={"/{id}"})
    public AjaxResult<String> remove(@PathVariable Long id) {
        this.service.remove(id);
        return AjaxResult.operateSuccess();
    }

    @GetMapping(value={"/cliTree"})
    public AjaxResult<List<CliOptionVo>> cliTree() {
        return AjaxResult.success((Object)this.cliCommandTreeService.cliTree());
    }

    @GetMapping(value={"/commandParams/{optionId}"})
    public AjaxResult<List<CliParamVo>> commandParams(@PathVariable Long optionId) {
        return AjaxResult.success((Object)this.cliParamService.commandParams(optionId));
    }

    @PutMapping(value={"/saveCliCommand"})
    public AjaxResult<String> saveCliCommand(@RequestBody CliOptionVo cliOptionVo) {
        this.cliCommandTreeService.saveCliCommand(cliOptionVo);
        return AjaxResult.operateSuccess();
    }

    @PutMapping(value={"/saveCliCommandParam"})
    public AjaxResult<String> saveCliCommandParam(@RequestBody CliParamsVo cliParamsVo) {
        this.cliCommandTreeService.saveCliCommandParam(cliParamsVo);
        return AjaxResult.operateSuccess();
    }

    @DeleteMapping(value={"/removeCliCommand/{id}"})
    public AjaxResult<String> removeCliCommand(@PathVariable Long id) {
        this.cliCommandTreeService.removeCliCommand(id);
        return AjaxResult.operateSuccess();
    }

    @DeleteMapping(value={"/removeParams/{ids}"})
    public AjaxResult<String> removeParams(@PathVariable List<Long> ids) {
        this.cliCommandTreeService.removeParams(ids);
        return AjaxResult.operateSuccess();
    }
}

