/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.system;

import com.uscale.common.core.domain.AjaxResult;
import com.uscale.system.entity.api.ClientPermission;
import com.uscale.system.service.ApiService;
import com.uscale.system.vo.ClientRoleVo;
import com.uscale.system.vo.ClientVo;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"OPEN API\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/system/api"})
public class SysApiController {
    @Autowired
    private ApiService apiService;

    @PostMapping(value={"/client/list"})
    public AjaxResult<List<ClientVo>> list() {
        return AjaxResult.success((Object)this.apiService.clientList());
    }

    @PutMapping(value={"/client"})
    public AjaxResult<Object> saveClient(@RequestBody ClientVo clientVo) {
        this.apiService.saveClient(clientVo);
        return AjaxResult.success();
    }

    @DeleteMapping(value={"/client/{id}"})
    public AjaxResult<Object> removeClient(@PathVariable String id) {
        this.apiService.removeClient(id);
        return AjaxResult.success();
    }

    @PostMapping(value={"/role/list"})
    public AjaxResult<List<ClientRoleVo>> roleList() {
        return AjaxResult.success((Object)this.apiService.roleList());
    }

    @PutMapping(value={"/role"})
    public AjaxResult<Object> saveRole(@RequestBody ClientRoleVo clientRoleVo) {
        this.apiService.saveRole(clientRoleVo);
        return AjaxResult.success();
    }

    @DeleteMapping(value={"/role/{id}"})
    public AjaxResult<Object> removeRole(@PathVariable Long id) {
        this.apiService.removeRole(id);
        return AjaxResult.success();
    }

    @PostMapping(value={"/permission/list"})
    public AjaxResult<List<ClientPermission>> permissionList() {
        return AjaxResult.success((Object)this.apiService.permissionList());
    }

    @PutMapping(value={"/permission"})
    public AjaxResult<Object> savePermission(@RequestBody ClientPermission clientPermission) {
        this.apiService.saveClientPermission(clientPermission);
        return AjaxResult.success();
    }

    @DeleteMapping(value={"/permission/{id}"})
    public AjaxResult<Object> removePermission(@PathVariable Long id) {
        this.apiService.removeClientPermission(id);
        return AjaxResult.success();
    }

    @GetMapping(value={"/role/dict"})
    public AjaxResult<List<Map<String, Object>>> roleDict() {
        return AjaxResult.success((Object)this.apiService.roleDict());
    }

    @GetMapping(value={"/permission/dict"})
    public AjaxResult<List<Map<String, Object>>> permissionDict() {
        return AjaxResult.success((Object)this.apiService.permissionDict());
    }
}

