/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.self_service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.annotation.RepeatSubmit;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.domain.model.LoginUser;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.framework.web.service.TokenService;
import com.uscale.system.entity.SipUser;
import com.uscale.system.entity.UmUserAbbreviatedDialing;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.service.IUmUserAbbreviatedDialingService;
import com.uscale.web.controller.userMng.SipUserController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u81ea\u52a9\u670d\u52a1-\u7f29\u4f4d\u62e8\u53f7"})
@RestController
@RequestMapping(value={"/self/sipUser/abbreviated"})
public class UmUserAbbreviatedDialingController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SipUserController.class);
    private static final Gson GSON = new Gson();
    private final TokenService tokenService;
    private final IUmUserAbbreviatedDialingService umUserAbbreviatedDialingService;
    private final ISipUserService iSipUserService;

    @Autowired
    public UmUserAbbreviatedDialingController(TokenService tokenService, IUmUserAbbreviatedDialingService umUserAbbreviatedDialingService, ISipUserService iSipUserService) {
        this.tokenService = tokenService;
        this.umUserAbbreviatedDialingService = umUserAbbreviatedDialingService;
        this.iSipUserService = iSipUserService;
    }

    @ApiOperation(value="\u67e5\u8be2\u7f29\u4f4d\u62e8\u53f7\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(HttpServletRequest request, @ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u6761\u6570") Integer pageSize) {
        LoginUser loginUser = this.tokenService.getLoginUser(request);
        LOGGER.debug("\u67e5\u8be2\u7f29\u4f4d\u62e8\u53f7\u5217\u8868\uff0cpageNum=[{}], pageSize=[{}]", (Object)pageNum, (Object)pageSize);
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        SipUser sipUser = this.iSipUserService.getSipUserByNumber(loginUser.getUsername());
        wrapper.eq(UmUserAbbreviatedDialing::getDeviceId, (Object)sipUser.getDeviceId());
        return this.getDataTable((Page)this.umUserAbbreviatedDialingService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u65b0\u589e\u7f29\u4f4d\u62e8\u53f7\u53f7\u7801")
    @RepeatSubmit
    @Log(title="\u81ea\u52a9\u670d\u52a1:\u7f29\u4f4d\u62e8\u53f7", businessType=BusinessType.INSERT)
    @PostMapping(value={"/create"})
    public AjaxResult<Object> add(HttpServletRequest request, @Validated @RequestBody List<UmUserAbbreviatedDialing> list) {
        LOGGER.debug("\u65b0\u589e\u7f29\u4f4d\u62e8\u53f7\u53f7\u7801\uff0c\u83b7\u53d6\u5230\u53c2\u6570\uff1alist=[{}]", (Object)GSON.toJson(list));
        LoginUser loginUser = this.tokenService.getLoginUser(request);
        SipUser sipUser = this.iSipUserService.getSipUserByNumber(loginUser.getUsername());
        return this.umUserAbbreviatedDialingService.createOrUpdate(sipUser, list);
    }

    @ApiOperation(value="\u5220\u9664SIP\u7528\u6237\u4fe1\u4efb\u53f7\u7801")
    @RepeatSubmit
    @Log(title="\u81ea\u52a9\u670d\u52a1:\u7f29\u4f4d\u62e8\u53f7", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult<Object> remove(HttpServletRequest request, @PathVariable Long[] ids) {
        if (ObjectUtils.isEmpty((Object[])ids) || CollectionUtils.isEmpty(Arrays.asList((Object[])ids.clone()))) {
            return AjaxResult.error();
        }
        LoginUser loginUser = this.tokenService.getLoginUser(request);
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.in((Object)"id", Arrays.asList((Object[])ids.clone()))).eq((Object)"device_id", (Object)loginUser.getUsername());
        return this.toAjax(this.umUserAbbreviatedDialingService.remove((Wrapper)wrapper));
    }
}

